/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.mixture.gibbssampling;

import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.models.mixture.gibbssampling.BurnInTest;

public class SimpleBurnInTest
extends BurnInTest {
    private int burnInLength;

    public SimpleBurnInTest(int burnInLength) {
        if (burnInLength < 0) {
            throw new IllegalArgumentException("The length of the burn-in phase has to be non-negative");
        }
        this.burnInLength = burnInLength;
    }

    public SimpleBurnInTest(StringBuffer xml) throws NonParsableException {
        this.burnInLength = XMLParser.extractIntForTag(XMLParser.extractForTag(xml, this.getClass().getSimpleName()), "burnInLength");
    }

    @Override
    public void setCurrentSamplingIndex(int index) {
    }

    @Override
    public void setValue(double val) {
    }

    @Override
    public void resetAllValues() {
    }

    @Override
    public int getLengthOfBurnIn() {
        return this.burnInLength;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(2000);
        XMLParser.appendIntWithTags(xml, this.burnInLength, "burnInLength");
        XMLParser.addTags(xml, this.getClass().getSimpleName());
        return xml;
    }

    @Override
    public String getInstanceName() {
        return "simple burn in test (length=" + this.burnInLength + ")";
    }
}

