/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery;

import de.jstacs.algorithms.optimization.ConstantStartDistance;
import de.jstacs.algorithms.optimization.DifferentiableFunction;
import de.jstacs.algorithms.optimization.NegativeDifferentiableFunction;
import de.jstacs.algorithms.optimization.Optimizer;
import de.jstacs.algorithms.optimization.StartDistanceForecaster;
import de.jstacs.algorithms.optimization.termination.CombinedCondition;
import de.jstacs.algorithms.optimization.termination.IterationCondition;
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.classifier.scoringFunctionBased.OptimizableFunction;
import de.jstacs.classifier.scoringFunctionBased.SFBasedOptimizableFunction;
import de.jstacs.data.RecyclableSequenceEnumerator;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.WrongLengthException;
import de.jstacs.io.ArrayHandler;
import de.jstacs.motifDiscovery.MotifDiscovererToolBox;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.motifDiscovery.SignificantMotifOccurrencesFinder;
import de.jstacs.motifDiscovery.history.History;
import de.jstacs.scoringFunctions.NormalizableScoringFunction;
import de.jstacs.scoringFunctions.ScoringFunction;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.SafeOutputStream;
import java.io.OutputStream;
import java.util.Arrays;

public final class MutableMotifDiscovererToolbox
extends MotifDiscovererToolBox {
    private static double pVal = 1.0E-4;
    private static double threshold = 0.8;
    private static TerminationCondition steps = new IterationCondition(10);
    private static final SafeOutputStream DISCARD_OUT = new SafeOutputStream(null);
    private static final int NUMBER_OF_PERMUTATIONS = 1000;

    public static Sequence enumerate(ScoringFunction[] funs, int classIndex, int motifIndex, RecyclableSequenceEnumerator rse, double weight, SFBasedOptimizableFunction opt, OutputStream out) throws Exception {
        return MutableMotifDiscovererToolbox.enumerate(funs, new int[]{classIndex}, new int[]{motifIndex}, new RecyclableSequenceEnumerator[]{rse}, weight, opt, out)[0];
    }

    public static Sequence[] enumerate(ScoringFunction[] funs, int[] classIndex, int[] motifIndex, RecyclableSequenceEnumerator[] rse, double weight, SFBasedOptimizableFunction opt, OutputStream out) throws Exception {
        int i;
        Sample[] data = opt.getData();
        double[][] dataWeights = opt.getSequenceWeights();
        int num = 0;
        Object[] seq = new Sequence[classIndex.length];
        Object[] bestSeq = new Sequence[classIndex.length];
        Sample[] s = new Sample[classIndex.length];
        boolean[] adjust = new boolean[funs.length];
        Arrays.fill(adjust, false);
        for (i = 0; i < classIndex.length; ++i) {
            adjust[classIndex[i]] = true;
        }
        MutableMotifDiscoverer[] mmd = new MutableMotifDiscoverer[funs.length];
        for (i = 0; i < funs.length; ++i) {
            mmd[i] = adjust[i] ? (MutableMotifDiscoverer)((Object)funs[i]) : null;
        }
        int[] len = new int[classIndex.length];
        for (i = 0; i < classIndex.length; ++i) {
            len[i] = mmd[classIndex[i]].getMotifLength(motifIndex[i]);
            rse[i].reset();
            seq[i] = (Sequence)rse[i].nextElement();
            s[i] = new Sample("sample " + i, seq[i]);
        }
        int idx = classIndex.length - 1;
        double best = Double.NEGATIVE_INFINITY;
        double[][] weights = new double[motifIndex.length][];
        Arrays.fill((Object[])weights, new double[]{weight});
        while (true) {
            MutableMotifDiscovererToolbox.initMotif(idx, classIndex, motifIndex, s, weights, adjust, mmd, len, data, dataWeights);
            opt.reset();
            double[] pars = opt.getParameters(OptimizableFunction.KindOfParameter.PLUGIN);
            double curr = opt.evaluateFunction(pars);
            out.write((num++ + "\t" + Arrays.toString(seq) + "\t" + curr + "\n").getBytes());
            if (curr > best) {
                best = curr;
                System.arraycopy(seq, 0, bestSeq, 0, seq.length);
            }
            for (idx = 0; idx < rse.length && !rse[idx].hasMoreElements(); ++idx) {
                rse[idx].reset();
                seq[idx] = (Sequence)rse[idx].nextElement();
                s[idx] = new Sample("sample " + idx, new Sequence[]{seq[idx]});
            }
            if (idx >= rse.length) break;
            seq[idx] = (Sequence)rse[idx].nextElement();
            s[idx] = new Sample("sample " + idx, new Sequence[]{seq[idx]});
        }
        out.write(("best: " + Arrays.toString(bestSeq) + " " + best + "\n").getBytes());
        for (i = 0; i < classIndex.length; ++i) {
            s[i] = new Sample("sample " + i, new Sequence[]{bestSeq[i]});
        }
        MutableMotifDiscovererToolbox.initMotif(classIndex.length - 1, classIndex, motifIndex, s, weights, adjust, mmd, len, data, dataWeights);
        return bestSeq;
    }

    public static void initMotif(int idx, int[] classIndex, int[] motifIndex, Sample[] s, double[][] seqWeights, boolean[] adjust, MutableMotifDiscoverer[] mmd, int[] len, Sample[] data, double[][] dataWeights) throws Exception {
        int i;
        for (i = 0; i <= idx; ++i) {
            int sl = s[i].getElementLength();
            if (sl > len[i]) {
                throw new WrongLengthException(sl);
            }
            if (sl < len[i]) {
                mmd[classIndex[i]].modifyMotif(motifIndex[i], 0, sl - len[i]);
            }
            mmd[classIndex[i]].initializeMotif(motifIndex[i], s[i], seqWeights[i]);
            if (sl >= len[i]) continue;
            mmd[classIndex[i]].modifyMotif(motifIndex[i], -((int)Math.floor((double)(len[i] - sl) / 2.0)), (int)Math.ceil((double)(len[i] - sl) / 2.0));
        }
        for (i = 0; i < adjust.length; ++i) {
            if (!adjust[i]) continue;
            mmd[classIndex[i]].adjustHiddenParameters(classIndex[i], data, dataWeights);
        }
    }

    public static ComparableElement<double[], Double>[] getSortedInitialParameters(ScoringFunction[] funs, InitMethodForScoringFunction[] init, SFBasedOptimizableFunction opt, int n, OutputStream stream, int optimizationSteps) throws Exception {
        SafeOutputStream info = SafeOutputStream.getSafeOutputStream(stream);
        Sample[] data = opt.getData();
        double[][] oldParams = new double[funs.length][];
        for (int j = 0; j < funs.length; ++j) {
            if (init[j] != InitMethodForScoringFunction.NOTHING) continue;
            oldParams[j] = funs[j].getCurrentParameterValues();
        }
        Object[] erg = new ComparableElement[n];
        ConstantStartDistance cs = new ConstantStartDistance(1.0);
        SafeOutputStream out = new SafeOutputStream(null);
        NegativeDifferentiableFunction nOpt = new NegativeDifferentiableFunction(opt);
        IterationCondition condition = new IterationCondition(optimizationSteps);
        for (int i = 0; i < n; ++i) {
            block8: for (int j = 0; j < funs.length; ++j) {
                switch (init[j]) {
                    case PLUG_IN: {
                        funs[j].initializeFunction(j, false, data, null);
                        continue block8;
                    }
                    case MOTIF_RANDOMLY: {
                        if (!(funs[j] instanceof MutableMotifDiscoverer)) continue block8;
                        MutableMotifDiscoverer mmd = (MutableMotifDiscoverer)((Object)funs[j]);
                        int m = mmd.getNumberOfMotifs();
                        for (int k = 0; k < m; ++k) {
                            mmd.initializeMotifRandomly(k);
                        }
                        continue block8;
                    }
                    case RANDOMLY: {
                        funs[j].initializeFunctionRandomly(false);
                        continue block8;
                    }
                    case NOTHING: {
                        funs[j].setParameters(oldParams[j], 0);
                    }
                }
            }
            opt.reset();
            double[] params = opt.getParameters(OptimizableFunction.KindOfParameter.PLUGIN);
            if (optimizationSteps > 0) {
                Optimizer.optimize((byte)10, nOpt, params, condition, 1.0E-10, cs, out);
            }
            double c = opt.evaluateFunction(params);
            info.writeln(i + "\t" + c);
            erg[i] = new ComparableElement<double[], Double>(params, c);
        }
        Arrays.sort(erg);
        info.writeln("[" + ((ComparableElement)erg[0]).getWeight() + " .. " + ((ComparableElement)erg[n - 1]).getWeight() + "]");
        return erg;
    }

    public static int[][] createMinimalNewLengthArray(ScoringFunction[] funs) {
        int[][] minimalNewLength = new int[funs.length][];
        for (int j = 0; j < funs.length; ++j) {
            if (!(funs[j] instanceof MutableMotifDiscoverer)) continue;
            MutableMotifDiscoverer disc = (MutableMotifDiscoverer)((Object)funs[j]);
            minimalNewLength[j] = new int[disc.getNumberOfMotifs()];
            for (int i = 0; i < minimalNewLength[j].length; ++i) {
                minimalNewLength[j][i] = disc.getMotifLength(i);
            }
        }
        return minimalNewLength;
    }

    public static History[][] createHistoryArray(ScoringFunction[] funs, History template) throws CloneNotSupportedException {
        History[][] history = new History[funs.length][];
        for (int j = 0; j < funs.length; ++j) {
            if (!(funs[j] instanceof MutableMotifDiscoverer)) continue;
            history[j] = new History[((MutableMotifDiscoverer)((Object)funs[j])).getNumberOfMotifs()];
            if (template == null) continue;
            for (int i = 0; i < history[j].length; ++i) {
                history[j][i] = template.clone();
            }
        }
        return history;
    }

    public static void clearHistoryArray(History[][] history) {
        for (int j = 0; j < history.length; ++j) {
            if (history[j] == null) continue;
            for (int i = 0; i < history[j].length; ++i) {
                if (history[j][i] == null) continue;
                history[j][i].clear();
            }
        }
    }

    public static double[][] optimize(ScoringFunction[] funs, SFBasedOptimizableFunction opt, byte algorithm, double eps, double linEps, StartDistanceForecaster startDistance, SafeOutputStream out, boolean breakOnChanged, History template, OptimizableFunction.KindOfParameter plugIn, boolean maxPos) throws Exception {
        return MutableMotifDiscovererToolbox.optimize(funs, opt, algorithm, eps, linEps, startDistance, out, breakOnChanged, MutableMotifDiscovererToolbox.createHistoryArray(funs, template), MutableMotifDiscovererToolbox.createMinimalNewLengthArray(funs), plugIn, maxPos);
    }

    public static double[][] optimize(ScoringFunction[] funs, SFBasedOptimizableFunction opt, byte algorithm, double eps, double linEps, StartDistanceForecaster startDistance, SafeOutputStream out, boolean breakOnChanged, History[][] hist, int[][] minimalNewLength, OptimizableFunction.KindOfParameter plugIn, boolean maxPos) throws Exception {
        NegativeDifferentiableFunction neg = new NegativeDifferentiableFunction(opt);
        ScoringFunction[] best = null;
        double[] classParams = null;
        Sample[] data = opt.getData();
        double[][] weights = opt.getSequenceWeights();
        double bestVal = Double.NEGATIVE_INFINITY;
        TerminationCondition condition = new SmallDifferenceOfFunctionEvaluationsCondition(eps);
        do {
            opt.reset();
            startDistance.reset();
            double[] params = opt.getParameters(plugIn);
            plugIn = OptimizableFunction.KindOfParameter.LAST;
            Optimizer.optimize(algorithm, neg, params, condition, linEps, startDistance, out);
            double current = opt.evaluateFunction(params);
            if (current > bestVal) {
                best = null;
                System.gc();
                best = (ScoringFunction[])ArrayHandler.clone((Cloneable[])funs);
                bestVal = current;
                classParams = opt.getClassParams(params);
            }
            if (!(condition instanceof SmallDifferenceOfFunctionEvaluationsCondition)) continue;
            condition = new CombinedCondition(1, condition, steps);
        } while (MutableMotifDiscovererToolbox.doHeuristicSteps(funs, data, weights, opt, neg, algorithm, linEps, startDistance, out, breakOnChanged, hist, minimalNewLength, maxPos));
        for (int k = 0; k < funs.length; ++k) {
            funs[k] = best[k];
        }
        return new double[][]{{bestVal}, classParams};
    }

    public static boolean doHeuristicSteps(ScoringFunction[] funs, Sample[] data, double[][] weights, SFBasedOptimizableFunction opt, DifferentiableFunction neg, byte algorithm, double linEps, StartDistanceForecaster startDistance, SafeOutputStream out, boolean breakOnChanged, History[][] hist, int[][] minimalNewLength, boolean maxPos) throws Exception {
        boolean changed = false;
        for (int k = 0; !(k >= funs.length || changed && breakOnChanged); ++k) {
            double normOld;
            NormalizableScoringFunction nsf;
            if (!(funs[k] instanceof MutableMotifDiscoverer) || ((MutableMotifDiscoverer)((Object)funs[k])).getNumberOfMotifs() <= 0) continue;
            out.writeln("MutableMotifDiscoverer " + k + ":\n" + funs[k].toString());
            if (funs[k] instanceof NormalizableScoringFunction) {
                nsf = (NormalizableScoringFunction)funs[k];
                normOld = nsf.getLogNormalizationConstant();
            } else {
                nsf = null;
                normOld = 0.0;
            }
            MutableMotifDiscoverer currMD = (MutableMotifDiscoverer)((Object)funs[k]);
            int numMotifs = currMD.getNumberOfMotifs();
            boolean changedThisOne = false;
            for (int l = 0; !(l >= numMotifs || changedThisOne && breakOnChanged); ++l) {
                if (hist[k][l] == null) continue;
                changedThisOne |= MutableMotifDiscovererToolbox.findModification(k, l, currMD, funs, data, opt, neg, algorithm, linEps, startDistance, out, hist[k][l], minimalNewLength[k][l], maxPos);
            }
            if (!changedThisOne) continue;
            changed = true;
            if (nsf == null) continue;
            double normNew = nsf.getLogNormalizationConstant();
            opt.addTermToClassParameter(k, normOld - normNew);
        }
        return changed;
    }

    public static boolean findModification(int clazz, int motif, MutableMotifDiscoverer mmd, ScoringFunction[] score, Sample[] data, SFBasedOptimizableFunction opt, DifferentiableFunction neg, byte algo, double linEps, StartDistanceForecaster startDistance, SafeOutputStream out, History hist, int minimalNewLength, boolean maxPos) throws Exception {
        double[] params = opt.getParameters(OptimizableFunction.KindOfParameter.LAST);
        int len = mmd.getMotifLength(motif) / 2;
        boolean[] in = new boolean[data.length];
        Arrays.fill(in, true);
        in[clazz] = false;
        Sample[] my = new Sample[]{data[clazz], Sample.union(data, in)};
        SignificantMotifOccurrencesFinder smof = my[1] != null ? new SignificantMotifOccurrencesFinder(mmd, my[1], pVal) : new SignificantMotifOccurrencesFinder(mmd, SignificantMotifOccurrencesFinder.RandomSeqType.PERMUTED, true, 1000, pVal);
        int current = smof.getNumberOfBoundSequences(my[0], motif);
        out.writeln("optimized predicted bound sequences: " + current);
        out.writeln("====================================");
        int[] notSignif = new int[2];
        out.writeln("shift downstream");
        notSignif[0] = MutableMotifDiscovererToolbox.heuristic(clazz, motif, len, 1, my, opt, neg, algo, linEps, startDistance, params, score, current, out, maxPos);
        out.writeln();
        out.writeln("shift upstream");
        notSignif[1] = MutableMotifDiscovererToolbox.heuristic(clazz, motif, len, -1, my, opt, neg, algo, linEps, startDistance, params, score, current, out, maxPos);
        out.writeln();
        out.writeln("not significant: " + Arrays.toString(notSignif));
        boolean modified = MutableMotifDiscovererToolbox.modify(notSignif, mmd, clazz, motif, hist, minimalNewLength, out);
        if (modified) {
            opt.reset();
        }
        return modified;
    }

    private static int heuristic(int clazz, int motif, int len, int direction, Sample[] data, SFBasedOptimizableFunction test, DifferentiableFunction neg, byte algo, double linEps, StartDistanceForecaster startDistance, double[] params, ScoringFunction[] score, int pred, SafeOutputStream out, boolean maxPos) throws Exception {
        int i;
        int dir2;
        test.setParams(params);
        MutableMotifDiscoverer mmd = (MutableMotifDiscoverer)((Object)score[0]);
        double normOld = Double.NEGATIVE_INFINITY;
        int[] val = new int[len];
        int dir1 = dir2 = direction;
        if (direction > 0) {
            dir1 = direction;
        } else {
            dir2 = direction;
        }
        for (i = 1; i <= len; ++i) {
            if (score[clazz] instanceof NormalizableScoringFunction) {
                normOld = ((NormalizableScoringFunction)score[clazz]).getLogNormalizationConstant();
            }
            if (mmd.modifyMotif(motif, i * dir1, i * dir2)) {
                if (score[clazz] instanceof NormalizableScoringFunction) {
                    test.addTermToClassParameter(0, normOld - ((NormalizableScoringFunction)score[clazz]).getLogNormalizationConstant());
                }
                test.reset();
                double[] params_copy = test.getParameters(OptimizableFunction.KindOfParameter.LAST);
                Optimizer.optimize(algo, neg, params_copy, steps, linEps, startDistance, DISCARD_OUT);
                test.setParams(params_copy);
                SignificantMotifOccurrencesFinder smof = data.length > 1 && data[1] != null ? new SignificantMotifOccurrencesFinder(mmd, data[1], pVal) : new SignificantMotifOccurrencesFinder(mmd, SignificantMotifOccurrencesFinder.RandomSeqType.PERMUTED, true, 1000, pVal);
                val[i - 1] = smof.getNumberOfBoundSequences(data[0], motif);
                mmd.modifyMotif(motif, -i * dir1, -i * dir2);
                test.reset();
                test.setParams(params);
            } else {
                val[i - 1] = 0;
            }
            out.writeln(i + "\t" + val[i - 1]);
        }
        if (!maxPos) {
            for (i = 0; i < val.length && (double)val[i] >= (double)pred * threshold; ++i) {
            }
            --i;
        } else {
            i = -1;
            double max = (double)pred * threshold;
            for (int j = 0; j < val.length; ++j) {
                if (!((double)val[j] >= max)) continue;
                max = val[j];
                i = j;
            }
        }
        return i + 1;
    }

    private static boolean modify(int[] notSignif, MutableMotifDiscoverer md, int clazz, int motif, History hist, int minimalNewLength, SafeOutputStream out) throws Exception {
        boolean modified = false;
        int sum = notSignif[0] + notSignif[1];
        int ml = md.getMotifLength(motif);
        int[] modification = new int[2];
        if (sum > 0) {
            if (sum < ml) {
                modification[0] = notSignif[0] >= notSignif[1] ? notSignif[0] : -notSignif[1];
                modification[1] = modification[0];
                if (hist.operationAllowed(modification)) {
                    modified = md.modifyMotif(motif, modification[0], modification[1]);
                }
            }
            if (!modified) {
                if (sum < ml) {
                    modification[0] = notSignif[0];
                    modification[1] = -notSignif[1];
                } else {
                    modification[0] = 0;
                    modification[1] = 1 - md.getMotifLength(motif);
                }
                if (modification[0] != modification[1] && hist.operationAllowed(modification)) {
                    modified = md.modifyMotif(motif, modification[0], modification[1]);
                }
            }
        } else {
            if (md.getMotifLength(motif) < minimalNewLength) {
                modification[0] = 0;
                modification[1] = minimalNewLength - md.getMotifLength(motif);
                if (!hist.operationAllowed(modification)) {
                    modification[0] = -(minimalNewLength - md.getMotifLength(motif));
                    modification[1] = 0;
                }
            } else {
                modification[0] = -1;
                modification[1] = 1;
            }
            if (hist.operationAllowed(modification)) {
                modified = md.modifyMotif(motif, modification[0], modification[1]);
            }
        }
        if (modified) {
            hist.operationPerfomed(modification);
            out.writeln("class " + clazz + ": modified motif " + motif + " => " + Arrays.toString(modification));
        }
        return modified;
    }

    public static enum InitMethodForScoringFunction {
        PLUG_IN,
        MOTIF_RANDOMLY,
        RANDOMLY,
        NOTHING;

    }
}

