/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.scoringFunctionBased;

import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.classifier.scoringFunctionBased.AbstractOptimizableFunction;
import de.jstacs.data.Sample;

public abstract class AbstractMultiThreadedOptimizableFunction
extends AbstractOptimizableFunction {
    private Worker[] worker;
    protected double[] params;

    public static final int getNumberOfAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public AbstractMultiThreadedOptimizableFunction(int threads, Sample[] data, double[][] weights, boolean norm, boolean freeParams) throws IllegalArgumentException {
        super(data, weights, norm, freeParams);
        if (threads < 1) {
            throw new IllegalArgumentException("The number of threads has to be positive.");
        }
        this.worker = new Worker[threads];
        this.prepareThreads();
    }

    @Override
    public void setDataAndWeights(Sample[] data, double[][] weights) throws IllegalArgumentException {
        super.setDataAndWeights(data, weights);
        if (this.worker != null) {
            this.prepareThreads();
        }
    }

    private void prepareThreads() {
        int i;
        int anz = 0;
        for (i = 0; i < this.cl; ++i) {
            anz += this.data[i].getNumberOfElements();
        }
        anz = (int)Math.ceil((double)anz / (double)this.worker.length);
        int endClass = 0;
        int endSeq = 0;
        for (i = 0; i < this.worker.length; ++i) {
            int startSeq = endSeq;
            int startClass = endClass;
            if (i == this.worker.length - 1) {
                endClass = this.cl - 1;
                endSeq = this.data[endClass].getNumberOfElements();
            } else {
                int c;
                for (c = anz; endClass < this.data.length && this.data[endClass].getNumberOfElements() - endSeq < c; c -= this.data[endClass].getNumberOfElements() - endSeq, ++endClass) {
                    endSeq = 0;
                }
                if (endClass >= this.data.length || startClass == endClass && startSeq == (endSeq += c)) {
                    throw new IllegalArgumentException("There are less sequence than threads used for the optimization. This seems to be unlikely. Please check your data or reduce the number of threads.");
                }
            }
            if (this.worker[i] != null) {
                if (this.worker[i].isWaiting()) {
                    this.worker[i].setIndices(startClass, startSeq, endClass, endSeq);
                    continue;
                }
                this.stopThreads();
                throw new RuntimeException();
            }
            this.worker[i] = new Worker(i, startClass, startSeq, endClass, endSeq);
            this.worker[i].start();
        }
    }

    @Override
    public final double[] evaluateGradientOfFunction(double[] x) throws DimensionException, EvaluationException {
        this.setParams(x);
        this.waitUntilWorkersFinished(WorkerTask.EVALUATE_GRADIENT);
        return this.joinGradients();
    }

    protected abstract void evaluateGradientOfFunction(int var1, int var2, int var3, int var4, int var5);

    protected abstract double[] joinGradients() throws EvaluationException;

    @Override
    public final double evaluateFunction(double[] x) throws DimensionException, EvaluationException {
        this.setParams(x);
        this.waitUntilWorkersFinished(WorkerTask.EVALUATE);
        return this.joinFunction();
    }

    protected abstract void evaluateFunction(int var1, int var2, int var3, int var4, int var5) throws EvaluationException;

    protected abstract double joinFunction() throws EvaluationException, DimensionException;

    @Override
    public final void setParams(double[] params) throws DimensionException {
        if (this.params == null || this.params.length != params.length) {
            this.params = (double[])params.clone();
        } else {
            System.arraycopy(params, 0, this.params, 0, params.length);
        }
        this.setThreadIndependentParameters();
        this.waitUntilWorkersFinished(WorkerTask.SET_PARAMETERS);
    }

    protected abstract void setThreadIndependentParameters() throws DimensionException;

    protected abstract void setParams(int var1) throws DimensionException;

    private synchronized void waitUntilWorkersFinished(WorkerTask wt) {
        for (int t = 0; t < this.worker.length; ++t) {
            this.worker[t].setTask(wt);
        }
        while (true) {
            int i;
            for (i = 0; i < this.worker.length && this.worker[i].isWaiting(); ++i) {
            }
            if (i == this.worker.length) break;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public final void stopThreads() {
        if (this.worker.length > 1) {
            for (int i = 0; i < this.worker.length; ++i) {
                this.worker[i].setTask(WorkerTask.STOP);
            }
            this.worker = null;
        }
    }

    public final int getNumberOfThreads() {
        return this.worker.length;
    }

    private class Worker
    extends Thread {
        private WorkerTask task;
        private int index;
        private int startClass;
        private int startSeq;
        private int endClass;
        private int endSeq;

        public Worker(int index, int startClass, int startSeq, int endClass, int endSeq) {
            super("worker thread " + index);
            this.setDaemon(true);
            this.index = index;
            this.setIndices(startClass, startSeq, endClass, endSeq);
        }

        private void setIndices(int startClass, int startSeq, int endClass, int endSeq) {
            this.startClass = startClass;
            this.startSeq = startSeq;
            this.endClass = endClass;
            this.endSeq = endSeq;
            this.task = WorkerTask.WAIT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            while (this.task != WorkerTask.STOP) {
                if (this.task != WorkerTask.WAIT) {
                    try {
                        switch (this.task) {
                            case SET_PARAMETERS: {
                                AbstractMultiThreadedOptimizableFunction.this.setParams(this.index);
                                break;
                            }
                            case EVALUATE: {
                                AbstractMultiThreadedOptimizableFunction.this.evaluateFunction(this.index, this.startClass, this.startSeq, this.endClass, this.endSeq);
                                break;
                            }
                            case EVALUATE_GRADIENT: {
                                AbstractMultiThreadedOptimizableFunction.this.evaluateGradientOfFunction(this.index, this.startClass, this.startSeq, this.endClass, this.endSeq);
                            }
                        }
                    }
                    catch (Exception e) {
                        RuntimeException re = new RuntimeException(e.getClass().getName() + ": " + e.getMessage());
                        re.setStackTrace(e.getStackTrace());
                        throw re;
                    }
                    AbstractMultiThreadedOptimizableFunction e = AbstractMultiThreadedOptimizableFunction.this;
                    synchronized (e) {
                        this.task = WorkerTask.WAIT;
                        AbstractMultiThreadedOptimizableFunction.this.notify();
                        continue;
                    }
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public synchronized void setTask(WorkerTask task) {
            this.task = task;
            this.notify();
        }

        public boolean isWaiting() {
            return this.task == WorkerTask.WAIT;
        }
    }

    private static enum WorkerTask {
        STOP,
        WAIT,
        SET_PARAMETERS,
        EVALUATE,
        EVALUATE_GRADIENT;

    }
}

