/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery.history;

import de.jstacs.motifDiscovery.history.History;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;

public class RestrictedRepeatHistory
implements History {
    private int threshold;
    private int[] anz;
    private int[] last;
    private Hashtable<String, int[]> hash;
    private boolean allowShift;
    private boolean allowShrink;
    private boolean allowExpand;
    private boolean allowReverse;

    public RestrictedRepeatHistory() {
        this(true, true, true, true, 1);
    }

    public RestrictedRepeatHistory(boolean allowReverse) {
        this(true, true, true, allowReverse, 1);
    }

    public RestrictedRepeatHistory(int threshold) {
        this(true, true, true, true, threshold);
    }

    public RestrictedRepeatHistory(boolean allowShift, boolean allowShrink, boolean allowExpand) {
        this(allowShift, allowShrink, allowExpand, true, 1);
    }

    public RestrictedRepeatHistory(boolean allowShift, boolean allowShrink, boolean allowExpand, boolean allowReverse, int threshold) throws IllegalArgumentException {
        this.allowShift = allowShift;
        this.allowShrink = allowShrink;
        this.allowExpand = allowExpand;
        this.allowReverse = allowReverse;
        if (threshold < 1) {
            throw new IllegalArgumentException("The threshold has to be at least 1.");
        }
        this.threshold = threshold;
        this.hash = new Hashtable();
        this.last = new int[2];
        this.clear();
    }

    @Override
    public RestrictedRepeatHistory clone() throws CloneNotSupportedException {
        RestrictedRepeatHistory clone = (RestrictedRepeatHistory)super.clone();
        clone.anz = this.anz == null ? null : (int[])this.anz.clone();
        clone.hash = new Hashtable();
        for (Map.Entry<String, int[]> e : this.hash.entrySet()) {
            clone.hash.put(e.getKey(), (int[])e.getValue().clone());
        }
        clone.last = (int[])this.last.clone();
        return clone;
    }

    @Override
    public void clear() {
        this.hash.clear();
    }

    @Override
    public boolean operationAllowed(int ... op) {
        if (op.length != 2 || !this.allowReverse && op[0] == -this.last[0] && op[1] == -this.last[1]) {
            return false;
        }
        int sum = op[1] - op[0];
        if (!this.allowShift && sum == 0 || !this.allowShrink && sum < 0 || !this.allowExpand && sum > 0) {
            return false;
        }
        if (this.allowShrink && sum < 0) {
            return true;
        }
        this.anz = this.hash.get(Arrays.toString(op));
        return this.anz == null || this.anz[0] < this.threshold;
    }

    @Override
    public void operationPerfomed(int ... op) {
        String s = Arrays.toString(op);
        this.anz = this.hash.get(s);
        if (this.anz == null) {
            this.anz = new int[]{1};
        } else {
            this.anz[0] = this.anz[0] + 1;
        }
        this.hash.put(s, this.anz);
        this.last[0] = op[0];
        this.last[1] = op[1];
    }
}

