/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.io.XMLParser;
import java.util.TreeMap;

public final class DoubleList
implements Storable {
    private int size;
    private double[] array;

    public DoubleList() {
        this(10);
    }

    public DoubleList(int size) throws IllegalArgumentException {
        if (size <= 0) {
            throw new IllegalArgumentException("The size has to be positive.");
        }
        this.size = 0;
        this.array = new double[size];
    }

    public DoubleList(StringBuffer rep) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(rep, this.getClass().getSimpleName());
        this.size = XMLParser.extractIntForTag(xml, "size");
        this.array = new double[this.size];
        TreeMap<String, String> filter = new TreeMap<String, String>();
        for (int i = 0; i < this.size; ++i) {
            filter.clear();
            filter.put("val", "" + i);
            this.array[i] = XMLParser.extractDoubleAndAttributesForTag(xml, "pos", null, filter);
        }
    }

    public void add(double val) {
        if (this.array.length == this.size) {
            double[] help = new double[2 * this.array.length];
            System.arraycopy(this.array, 0, help, 0, this.size);
            this.array = help;
        }
        this.array[this.size++] = val;
    }

    public void add(double val, int fromIndex, int toIndex) {
        if (toIndex > this.array.length) {
            double[] help = new double[toIndex];
            System.arraycopy(this.array, 0, help, 0, this.size);
            this.array = help;
        }
        while (fromIndex < toIndex) {
            this.array[fromIndex++] = val;
        }
        if (this.size < toIndex) {
            this.size = toIndex;
        }
    }

    public void clear() {
        this.size = 0;
    }

    public double get(int index) {
        if (index < this.size) {
            return this.array[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public int length() {
        return this.size;
    }

    public double[] toArray() {
        double[] erg = new double[this.size];
        System.arraycopy(this.array, 0, erg, 0, this.size);
        return erg;
    }

    public void multiply(int start, int end, double factor) {
        while (start < end) {
            int n = start++;
            this.array[n] = this.array[n] * factor;
        }
    }

    public double mean(int start, int end) {
        if (start >= end) {
            throw new IllegalArgumentException("The start index has to be smaller than the end index.");
        }
        double sum = 0.0;
        for (int k = start; k < end; ++k) {
            sum += this.array[k];
        }
        return sum / (double)(end - start);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(this.size * 30);
        XMLParser.appendIntWithTags(xml, this.size, "size");
        for (int i = 0; i < this.size; ++i) {
            XMLParser.appendDoubleWithTagsAndAttributes(xml, this.array[i], "pos", "val=\"" + i + "\"");
        }
        XMLParser.addTags(xml, this.getClass().getSimpleName());
        return xml;
    }
}

