/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sequence;

public class Alignment {
    private Sequence s1;
    private Sequence s2;
    private Costs costs;
    private D[][] d;
    private E[][] e;
    private F[][] f;

    public Alignment(Sequence s1, Sequence s2, Costs costs) {
        this.s1 = s1;
        this.s2 = s2;
        this.costs = costs;
    }

    public StringAlignment getAlignment() {
        this.d = new D[this.s1.getLength() + 1][this.s2.getLength() + 1];
        this.e = new E[this.s1.getLength() + 1][this.s2.getLength() + 1];
        this.f = new F[this.s1.getLength() + 1][this.s2.getLength() + 1];
        for (int i = 0; i <= this.s1.getLength(); ++i) {
            for (int j = 0; j <= this.s2.getLength(); ++j) {
                this.e[i][j] = new E(i, j);
                this.f[i][j] = new F(i, j);
                this.d[i][j] = new D(i, j);
            }
        }
        Element curr = null;
        curr = this.e[this.s1.getLength()][this.s2.getLength()].cost < this.f[this.s1.getLength()][this.s2.getLength()].cost && this.e[this.s1.getLength()][this.s2.getLength()].cost < this.d[this.s1.getLength()][this.s2.getLength()].cost ? this.e[this.s1.getLength()][this.s2.getLength()] : (this.f[this.s1.getLength()][this.s2.getLength()].cost < this.d[this.s1.getLength()][this.s2.getLength()].cost ? this.f[this.s1.getLength()][this.s2.getLength()] : this.d[this.s1.getLength()][this.s2.getLength()]);
        double cost = curr.cost;
        StringBuffer b1 = new StringBuffer();
        StringBuffer b2 = new StringBuffer();
        AlphabetContainer cont = this.s1.getAlphabetContainer();
        while (curr.pre != null) {
            if (curr.direction == Costs.Direction.DIAGONAL) {
                b1.insert(0, cont.getSymbol(curr.i - 1, this.s1.discreteVal(curr.i - 1)));
                b2.insert(0, cont.getSymbol(curr.j - 1, this.s2.discreteVal(curr.j - 1)));
            } else if (curr.direction == Costs.Direction.LEFT) {
                b1.insert(0, '-');
                b2.insert(0, cont.getSymbol(curr.j - 1, this.s2.discreteVal(curr.j - 1)));
            } else if (curr.direction == Costs.Direction.TOP) {
                b1.insert(0, cont.getSymbol(curr.j - 1, this.s2.discreteVal(curr.j - 1)));
                b2.insert(0, '-');
            }
            curr = curr.pre;
        }
        return new StringAlignment(b1.toString(), b2.toString(), cost);
    }

    public static interface Costs {
        public double getCostFor(Sequence var1, Sequence var2, int var3, int var4, Direction var5);

        public double getGapCostsFor(int var1);

        public double getElongateCosts();

        public static enum Direction {
            TOP,
            LEFT,
            DIAGONAL,
            SELF;

        }
    }

    public static class SimpleCosts
    implements Costs {
        private double mismatch;
        private double start;
        private double elong;

        public SimpleCosts(double mismatch, double start, double elong) {
            this.start = start;
            this.elong = elong;
            this.mismatch = mismatch;
        }

        @Override
        public double getCostFor(Sequence s1, Sequence s2, int i, int j, Costs.Direction from) {
            if (from == Costs.Direction.TOP || from == Costs.Direction.LEFT) {
                return this.start + this.elong;
            }
            if (s1.discreteVal(i - 1) != s2.discreteVal(j - 1)) {
                return this.mismatch;
            }
            return 0.0;
        }

        @Override
        public double getElongateCosts() {
            return this.elong;
        }

        @Override
        public double getGapCostsFor(int length) {
            return this.start + (double)length * this.elong;
        }
    }

    private class F
    extends Element {
        private F(int i, int j) {
            super(i, j);
            if (i == 0) {
                this.cost = Double.POSITIVE_INFINITY;
            } else if (i > 0 && j == 0) {
                this.direction = Costs.Direction.TOP;
                this.cost = Alignment.this.costs.getGapCostsFor(j);
                this.pre = Alignment.this.f[i - 1][j];
            } else {
                double start;
                double elong = ((Alignment)Alignment.this).f[i - 1][j].cost + Alignment.this.costs.getElongateCosts();
                if (elong < (start = ((Alignment)Alignment.this).d[i - 1][j].cost + Alignment.this.costs.getGapCostsFor(1))) {
                    this.cost = elong;
                    this.direction = Costs.Direction.TOP;
                    this.pre = Alignment.this.f[i - 1][j];
                } else {
                    this.cost = start;
                    this.direction = Costs.Direction.TOP;
                    this.pre = Alignment.this.d[i - 1][j];
                }
            }
        }
    }

    private class E
    extends Element {
        private E(int i, int j) {
            super(i, j);
            if (j == 0) {
                this.cost = Double.POSITIVE_INFINITY;
            } else if (i == 0 && j > 0) {
                this.direction = Costs.Direction.LEFT;
                this.cost = Alignment.this.costs.getGapCostsFor(j);
                this.pre = Alignment.this.e[i][j - 1];
            } else {
                double start;
                double elong = ((Alignment)Alignment.this).e[i][j - 1].cost + Alignment.this.costs.getElongateCosts();
                if (elong < (start = ((Alignment)Alignment.this).d[i][j - 1].cost + Alignment.this.costs.getGapCostsFor(1))) {
                    this.cost = elong;
                    this.direction = Costs.Direction.LEFT;
                    this.pre = Alignment.this.e[i][j - 1];
                } else {
                    this.cost = start;
                    this.direction = Costs.Direction.LEFT;
                    this.pre = Alignment.this.d[i][j - 1];
                }
            }
        }
    }

    private class D
    extends Element {
        private D(int i, int j) {
            super(i, j);
            if (i == 0 && j == 0) {
                this.cost = 0.0;
            } else if (i == 0 && j > 0) {
                this.cost = Double.POSITIVE_INFINITY;
                this.direction = Costs.Direction.LEFT;
            } else if (i > 0 && j == 0) {
                this.cost = Double.POSITIVE_INFINITY;
                this.direction = Costs.Direction.TOP;
            } else {
                double diag = ((Alignment)Alignment.this).d[i - 1][j - 1].cost + Alignment.this.costs.getCostFor(Alignment.this.s1, Alignment.this.s2, i, j, Costs.Direction.DIAGONAL);
                double left = ((Alignment)Alignment.this).e[i][j].cost;
                double top = ((Alignment)Alignment.this).f[i][j].cost;
                if (diag < left && diag < top) {
                    this.cost = diag;
                    this.direction = Costs.Direction.DIAGONAL;
                    this.pre = Alignment.this.d[i - 1][j - 1];
                } else if (left < top) {
                    this.cost = left;
                    this.direction = Costs.Direction.SELF;
                    this.pre = Alignment.this.e[i][j];
                } else {
                    this.cost = top;
                    this.direction = Costs.Direction.SELF;
                    this.pre = Alignment.this.f[i][j];
                }
            }
        }
    }

    private abstract class Element {
        protected int i;
        protected int j;
        double cost;
        protected Costs.Direction direction;
        protected Element pre;

        public Element(int i, int j) {
            this.i = i;
            this.j = j;
        }
    }

    public static class StringAlignment {
        private String r1;
        private String r2;
        private double cost;

        protected StringAlignment(String r1, String r2, double cost) {
            this.r1 = r1;
            this.r2 = r2;
            this.cost = cost;
        }

        public double getCost() {
            return this.cost;
        }

        public String getFirst() {
            return this.r1;
        }

        public String getSecond() {
            return this.r2;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(this.r1);
            buf.append("\n");
            buf.append(this.r2);
            buf.append("\n");
            buf.append("costs: ");
            buf.append(this.cost);
            return buf.toString();
        }
    }
}

