/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.scoringFunctionBased.gendismix;

public enum LearningPrinciple {
    ML,
    MAP,
    MCL,
    MSP;

    public static final int CONDITIONAL_LIKELIHOOD_INDEX = 0;
    public static final int LIKELIHOOD_INDEX = 1;
    public static final int PRIOR_INDEX = 2;

    public static double[] getBeta(LearningPrinciple key) {
        double[] beta = new double[3];
        switch (key) {
            case ML: {
                beta[1] = 1.0;
                break;
            }
            case MAP: {
                beta[2] = 0.5;
                beta[1] = 0.5;
                break;
            }
            case MCL: {
                beta[0] = 1.0;
                break;
            }
            case MSP: {
                beta[2] = 0.5;
                beta[0] = 0.5;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown key");
            }
        }
        return beta;
    }

    public static double[] checkWeights(double[] weights) throws IllegalArgumentException {
        if (weights.length != 3) {
            throw new IllegalArgumentException("Wrong dimension for the weights.");
        }
        double sum = weights[0] + weights[1] + weights[2];
        if (Math.abs(1.0 - sum) > 1.0E-9) {
            throw new IllegalArgumentException("The weights have to be normalized to 1.");
        }
        return new double[]{weights[0], weights[1], weights[2]};
    }
}

