/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import de.jstacs.data.sequences.annotation.NullSequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.io.AbstractStringExtractor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class SparseStringExtractor
extends AbstractStringExtractor {
    private BufferedReader reader;
    private String current;
    private String next;
    private String old;
    private StringBuffer help;
    protected SequenceAnnotationParser annotationParser;

    public SparseStringExtractor(String fName) throws IOException, FileNotFoundException {
        this(fName, '#');
    }

    public SparseStringExtractor(File f) throws IOException {
        this(f, '#');
    }

    public SparseStringExtractor(String fName, SequenceAnnotationParser parser) throws IOException, FileNotFoundException {
        this(fName, '#', parser);
    }

    public SparseStringExtractor(String fName, char ignore) throws IOException, FileNotFoundException {
        this(fName, ignore, null);
    }

    public SparseStringExtractor(File f, char ignore) throws IOException {
        this(f, ignore, f.getName(), null);
    }

    public SparseStringExtractor(String fName, char ignore, SequenceAnnotationParser parser) throws IOException, FileNotFoundException {
        this(fName, ignore, fName, parser);
    }

    public SparseStringExtractor(String fName, String annotation, SequenceAnnotationParser parser) throws IOException, FileNotFoundException {
        this(fName, '#', annotation, parser);
    }

    public SparseStringExtractor(String fName, char ignore, String annotation, SequenceAnnotationParser parser) throws IOException, FileNotFoundException {
        this(new File(fName), ignore, annotation, parser);
    }

    public SparseStringExtractor(File f, char ignore, String annotation, SequenceAnnotationParser parser) throws IOException {
        super(ignore);
        this.annotationParser = parser == null ? NullSequenceAnnotationParser.DEFAULT_INSTANCE : parser;
        this.annotationParser.clearAnnotation();
        this.old = null;
        this.reader = new BufferedReader(new FileReader(f));
        this.help = new StringBuffer();
        this.next = this.getNext();
        this.annotation = annotation;
    }

    @Override
    public boolean hasMoreElements() {
        return this.next != null;
    }

    @Override
    public String nextElement() {
        this.current = this.next;
        this.next = this.getNext();
        return this.current;
    }

    private String getNext() {
        String res = null;
        int anz = 0;
        try {
            String line;
            this.annotationParser.clearAnnotation();
            if (this.old != null) {
                this.annotationParser.addToAnnotation(this.old);
                ++anz;
            }
            this.old = null;
            while ((line = this.reader.readLine()) != null && (anz < 1 || this.ignore != '>') && this.ignorePattern.matcher(line).matches()) {
                this.annotationParser.addToAnnotation(line);
                ++anz;
            }
            if (line == null || this.ignore != '>') {
                res = anz > 0 && line == null ? "" : line;
            } else {
                while (line != null && !this.ignorePattern.matcher(line).matches()) {
                    this.help.append(line);
                    line = this.reader.readLine();
                }
                if (line != null && this.ignorePattern.matcher(line).matches()) {
                    this.old = line;
                }
                res = this.help.toString();
                this.help.delete(0, this.help.length());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Forwarding IOException: " + e.getMessage());
        }
        return res;
    }

    protected void finalize() throws Throwable {
        this.reader.close();
        super.finalize();
    }

    @Override
    public SequenceAnnotation[] getCurrentSequenceAnnotations() {
        return this.annotationParser.getCurrentAnnotation();
    }
}

