/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.io;

import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;

public class XMLParser {
    private static Map<String, String> parseAttributes(String attrs) throws NonParsableException {
        TreeMap<String, String> map = new TreeMap<String, String>();
        String[] parts = attrs.split("(?<!=)\\s+(?!=)");
        int vallength = 0;
        for (String part : parts) {
            if ((part = part.trim()).length() <= 0) continue;
            String[] keyVal = part.split("=");
            if (keyVal.length != 2) {
                throw new NonParsableException("Malformed attributes: " + attrs);
            }
            keyVal[0] = keyVal[0].trim();
            keyVal[1] = keyVal[1].trim();
            vallength = keyVal[1].length();
            if (keyVal[1].charAt(0) == '\"' && keyVal[1].charAt(vallength - 1) == '\"') {
                keyVal[1] = keyVal[1].substring(1, vallength - 1);
            }
            map.put(keyVal[0], keyVal[1]);
        }
        return map;
    }

    private static boolean testFilter(Map<String, String> myAttrs, Map<String, String> filterAttributes) {
        Set<String> keys = filterAttributes.keySet();
        String myVal = null;
        String filterVal = null;
        for (String key : keys) {
            myVal = myAttrs.get(key);
            filterVal = filterAttributes.get(key);
            if (myVal == null && filterVal == null) continue;
            if (myVal == null) {
                return false;
            }
            if ((myVal = myVal.trim()).equals(filterVal = filterVal.trim())) continue;
            return false;
        }
        return true;
    }

    public static StringBuffer extractForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractForTag(source, tag, null, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static StringBuffer extractForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        int start;
        if (source == null || source.length() == 0) {
            return null;
        }
        int taglength = tag.length();
        int endOfStart = 0;
        Map<String, String> myMap = null;
        boolean found = false;
        do {
            if ((start = source.indexOf("<" + tag, endOfStart)) < 0) {
                return null;
            }
            endOfStart = source.indexOf(">", start + taglength);
            if (start < 0 || endOfStart < 0) {
                throw new NonParsableException("Could not find appropriate start tag for tag " + tag + " and attributes " + Arrays.toString(filterAttributes.keySet().toArray()));
            }
            ++endOfStart;
            char c = source.charAt(start + taglength + 1);
            if (c != ' ' && c != '>') continue;
            if (filterAttributes != null || attributes != null) {
                myMap = XMLParser.parseAttributes(source.substring(start + taglength + 2, endOfStart - 1));
            }
            found = filterAttributes != null ? XMLParser.testFilter(myMap, filterAttributes) : true;
        } while (!found);
        Stack<String> tags = new Stack<String>();
        tags.push(tag);
        int pos = 0;
        int closepos = 0;
        int closepos2 = 0;
        int nextpos = source.indexOf("<", endOfStart);
        while ((pos = nextpos) > 0) {
            closepos = source.indexOf(">", pos + 1);
            nextpos = source.indexOf("<", pos + 1);
            if (source.charAt(pos - 1) == '\\' || nextpos >= 0 && nextpos < closepos) continue;
            if (source.charAt(pos + 1) == '/') {
                if (!source.substring(pos + 2, closepos).equals(tags.peek())) throw new NonParsableException("Malformed XML: Nested tags may not overlap. Open tags: " + tags.toString() + ",  found end tag " + source.substring(pos + 2, closepos));
                tags.pop();
            } else {
                int endOfTag;
                String current;
                closepos2 = source.indexOf(" ", pos + 1);
                if (closepos2 < 0) {
                    closepos2 = closepos;
                }
                if ((current = source.substring(pos + 1, endOfTag = Math.min(closepos, closepos2))).startsWith("!--") || current.startsWith("![CDATA[") || current.startsWith("?") || source.charAt(closepos - 1) == '/') continue;
                tags.push(source.substring(pos + 1, endOfTag));
            }
            if (tags.size() != 0) continue;
            if (attributes != null) {
                attributes.putAll(myMap);
            }
            StringBuffer result = new StringBuffer(source.substring(endOfStart, pos));
            source.delete(start, closepos + 1);
            return result;
        }
        throw new NonParsableException("Malformed XML: No end tag found for " + tag + ".");
    }

    public static boolean extractBooleanForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractBooleanAndAttributesForTag(source, tag, null, null);
    }

    public static boolean extractBooleanAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        return Boolean.valueOf(XMLParser.extractForTag(source, tag, attributes, filterAttributes).toString().trim());
    }

    public static byte extractByteForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractByteAndAttributesForTag(source, tag, null, null);
    }

    public static byte extractByteAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        try {
            return Byte.parseByte(ex.toString());
        }
        catch (NumberFormatException e) {
            throw new NonParsableException("Could not parse \"" + tag + "\" to int.");
        }
        catch (NullPointerException e) {
            throw new NonParsableException("Could not find \"" + tag + "\".");
        }
    }

    public static <T extends Enum<T>> T extractEnumForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractEnumAndAttributesForTag(source, tag, null, null);
    }

    public static <T extends Enum<T>> T extractEnumAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        Object erg;
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        if (ex == null) {
            throw new NonParsableException("Could not find \"" + tag + "\".");
        }
        String enumName = XMLParser.extractStringForTag(ex, "enumName");
        try {
            erg = Enum.valueOf(Class.forName(enumName), XMLParser.extractStringForTag(ex, "name"));
        }
        catch (Exception e) {
            throw XMLParser.getNonParsableException("problem at " + enumName + ": " + e.getClass().getSimpleName() + ": " + e.getCause().toString(), e);
        }
        return (T)erg;
    }

    public static int extractIntForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractIntAndAttributesForTag(source, tag, null, null);
    }

    public static int extractIntAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        try {
            return Integer.parseInt(ex.toString());
        }
        catch (NumberFormatException e) {
            throw new NonParsableException("Could not parse \"" + tag + "\" to int.");
        }
        catch (NullPointerException e) {
            throw new NonParsableException("Could not find \"" + tag + "\".");
        }
    }

    public static long extractLongForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractLongAndAttributesForTag(source, tag, null, null);
    }

    public static long extractLongAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        try {
            return Long.parseLong(ex.toString());
        }
        catch (NumberFormatException e) {
            throw new NonParsableException("Could not parse \"" + tag + "\" to int.");
        }
        catch (NullPointerException e) {
            throw new NonParsableException("Could not find \"" + tag + "\".");
        }
    }

    public static double extractDoubleForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractDoubleAndAttributesForTag(source, tag, null, null);
    }

    public static double extractDoubleAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        try {
            return Double.parseDouble(ex.toString());
        }
        catch (NumberFormatException e) {
            throw new NonParsableException("Could not parse \"" + tag + "\" to double.");
        }
        catch (NullPointerException e) {
            throw new NonParsableException("Could not find \"" + tag + "\".");
        }
    }

    public static Storable extractStorableForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractStorableAndAttributesForTag(source, tag, null, null);
    }

    public static Storable extractStorableAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        return XMLParser.extractStorableAndAttributesForTag(source, tag, attributes, filterAttributes, null);
    }

    public static Storable extractStorableForTag(StringBuffer source, String tag, Class<? extends Storable> clazz) throws NonParsableException {
        return XMLParser.extractStorableAndAttributesForTag(source, tag, null, null, clazz);
    }

    public static Storable extractStorableAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes, Class<? extends Storable> clazz) throws NonParsableException {
        Storable erg;
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        if (ex == null) {
            throw new NonParsableException("Could not find \"" + tag + "\".");
        }
        if (ex.toString().trim().equals("null")) {
            return null;
        }
        if (clazz == null) {
            try {
                clazz = Class.forName(XMLParser.extractStringForTag(ex, "className"));
            }
            catch (Exception e) {
                throw XMLParser.getNonParsableException("Class not found.", e);
            }
        }
        try {
            erg = clazz.getConstructor(StringBuffer.class).newInstance(ex);
        }
        catch (NoSuchMethodException e) {
            throw XMLParser.getNonParsableException("You must provide a constructor " + clazz.getName() + "(StringBuffer).", e);
        }
        catch (Exception e) {
            throw XMLParser.getNonParsableException("problem at " + clazz.getName() + ": " + e.getClass().getSimpleName() + ": " + e.getCause().toString(), e);
        }
        return erg;
    }

    private static final NonParsableException getNonParsableException(String s, Exception e) {
        NonParsableException n = new NonParsableException(s);
        n.setStackTrace(e.getStackTrace());
        return n;
    }

    public static String extractStringForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractStringAndAttributesForTag(source, tag, null, null);
    }

    public static String extractStringAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        if (ex == null) {
            throw new NonParsableException("Could not find \"" + tag + "\".");
        }
        return ex.toString();
    }

    public static boolean[] extractBooleanArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractBooleanArrayAndAttributesForTag(source, tag, null, null);
    }

    public static boolean[] extractBooleanArrayAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        int l = XMLParser.extractIntForTag(ex, "length");
        boolean[] array = new boolean[l];
        TreeMap<String, String> myFilterAttributes = new TreeMap<String, String>();
        for (int i = 0; i < l; ++i) {
            myFilterAttributes.clear();
            myFilterAttributes.put("val", "" + i);
            array[i] = XMLParser.extractBooleanAndAttributesForTag(ex, "pos", null, myFilterAttributes);
        }
        return array;
    }

    public static byte[] extractByteArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractByteArrayAndAttributesForTag(source, tag, null, null);
    }

    public static byte[] extractByteArrayAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        int l = XMLParser.extractIntForTag(ex, "length");
        byte[] array = new byte[l];
        TreeMap<String, String> myFilterAttributes = new TreeMap<String, String>();
        for (int i = 0; i < l; ++i) {
            myFilterAttributes.clear();
            myFilterAttributes.put("val", "" + i);
            array[i] = XMLParser.extractByteAndAttributesForTag(ex, "pos", null, myFilterAttributes);
        }
        return array;
    }

    public static int[] extractIntArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractIntArrayAndAttributesForTag(source, tag, null, null);
    }

    public static int[] extractIntArrayAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        int l = XMLParser.extractIntForTag(ex, "length");
        int[] array = new int[l];
        TreeMap<String, String> myFilterAttributes = new TreeMap<String, String>();
        for (int i = 0; i < l; ++i) {
            myFilterAttributes.clear();
            myFilterAttributes.put("val", "" + i);
            array[i] = XMLParser.extractIntAndAttributesForTag(ex, "pos", null, myFilterAttributes);
        }
        return array;
    }

    public static double[] extractDoubleArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractDoubleArrayAndAttributesForTag(source, tag, null, null);
    }

    public static double[] extractDoubleArrayAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        int l = XMLParser.extractIntForTag(ex, "length");
        double[] array = new double[l];
        TreeMap<String, String> myFilterAttributes = new TreeMap<String, String>();
        for (int i = 0; i < l; ++i) {
            myFilterAttributes.clear();
            myFilterAttributes.put("val", "" + i);
            array[i] = XMLParser.extractDoubleAndAttributesForTag(ex, "pos", null, myFilterAttributes);
        }
        return array;
    }

    public static Storable[] extractStorableArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractStorableArrayAndAttributesForTag(source, tag, null, null);
    }

    public static Storable[] extractStorableArrayAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        return XMLParser.extractStorableArrayAndAttributesForTag(source, tag, attributes, filterAttributes, null);
    }

    public static Storable[] extractStorableArrayForTag(StringBuffer source, String tag, Class<? extends Storable> clazz) throws NonParsableException {
        return XMLParser.extractStorableArrayAndAttributesForTag(source, tag, null, null, clazz);
    }

    public static Storable[] extractStorableArrayAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes, Class<? extends Storable> clazz) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        int l = XMLParser.extractIntForTag(ex, "length");
        Storable[] array = clazz == null ? new Storable[l] : (Storable[])Array.newInstance(clazz, l);
        TreeMap<String, String> myFilterAttributes = new TreeMap<String, String>();
        for (int i = 0; i < l; ++i) {
            myFilterAttributes.clear();
            myFilterAttributes.put("val", "" + i);
            array[i] = XMLParser.extractStorableAndAttributesForTag(ex, "pos", null, myFilterAttributes, clazz);
        }
        return array;
    }

    public static String[] extractStringArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractStringArrayAndAttributesForTag(source, tag, null, null);
    }

    public static String[] extractStringArrayAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        int l = XMLParser.extractIntForTag(ex, "length");
        String[] array = new String[l];
        TreeMap<String, String> myFilterAttributes = new TreeMap<String, String>();
        for (int i = 0; i < l; ++i) {
            myFilterAttributes.clear();
            myFilterAttributes.put("val", "" + i);
            array[i] = XMLParser.extractStringAndAttributesForTag(ex, "pos", null, myFilterAttributes);
        }
        return array;
    }

    public static Storable[][] extractStorable2ArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractStorable2ArrayAndAttributesForTag(source, tag, null, null);
    }

    public static Storable[][] extractStorable2ArrayAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        return XMLParser.extractStorable2ArrayAndAttributesForTag(source, tag, attributes, filterAttributes, null);
    }

    public static Storable[][] extractStorable2ArrayForTag(StringBuffer source, String tag, Class<? extends Storable> clazz) throws NonParsableException {
        return XMLParser.extractStorable2ArrayAndAttributesForTag(source, tag, null, null, clazz);
    }

    public static Storable[][] extractStorable2ArrayAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes, Class<? extends Storable> clazz) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        int l = XMLParser.extractIntForTag(ex, "length");
        Object array = new Storable[l][];
        array = clazz == null ? new Storable[l][] : (Storable[][])Array.newInstance(clazz, l, 0);
        TreeMap<String, String> myFilterAttributes = new TreeMap<String, String>();
        for (int i = 0; i < l; ++i) {
            myFilterAttributes.clear();
            myFilterAttributes.put("val", "" + i);
            array[i] = XMLParser.extractStorableArrayAndAttributesForTag(ex, "pos", null, myFilterAttributes, clazz);
        }
        return array;
    }

    public static Storable[][][] extractStorable3ArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractStorable3ArrayAndAttributesForTag(source, tag, null, null);
    }

    public static Storable[][][] extractStorable3ArrayAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        return XMLParser.extractStorable3ArrayAndAttributesForTag(source, tag, attributes, filterAttributes, null);
    }

    public static Storable[][][] extractStorable3ArrayForTag(StringBuffer source, String tag, Class<? extends Storable> clazz) throws NonParsableException {
        return XMLParser.extractStorable3ArrayAndAttributesForTag(source, tag, null, null, clazz);
    }

    public static Storable[][][] extractStorable3ArrayAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes, Class<? extends Storable> clazz) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        int l = XMLParser.extractIntForTag(ex, "length");
        Object array = clazz == null ? new Storable[l][][] : (Storable[][][])Array.newInstance(clazz, l, 0, 0);
        TreeMap<String, String> myFilterAttributes = new TreeMap<String, String>();
        for (int i = 0; i < l; ++i) {
            myFilterAttributes.clear();
            myFilterAttributes.put("val", "" + i);
            array[i] = XMLParser.extractStorable2ArrayAndAttributesForTag(ex, "pos", null, myFilterAttributes, clazz);
        }
        return array;
    }

    public static boolean[][] extractBoolean2ArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractBoolean2ArrayAndAttributesForTag(source, tag, null, null);
    }

    public static boolean[][] extractBoolean2ArrayAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        int l = XMLParser.extractIntForTag(ex, "length");
        boolean[][] array = new boolean[l][];
        TreeMap<String, String> myFilterAttributes = new TreeMap<String, String>();
        for (int i = 0; i < l; ++i) {
            myFilterAttributes.clear();
            myFilterAttributes.put("val", "" + i);
            array[i] = XMLParser.extractBooleanArrayAndAttributesForTag(ex, "pos", null, myFilterAttributes);
        }
        return array;
    }

    public static byte[][] extractByte2ArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractByte2ArrayAndAttributesForTag(source, tag, null, null);
    }

    public static byte[][] extractByte2ArrayAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        int l = XMLParser.extractIntForTag(ex, "length");
        byte[][] array = new byte[l][];
        TreeMap<String, String> myFilterAttributes = new TreeMap<String, String>();
        for (int i = 0; i < l; ++i) {
            myFilterAttributes.clear();
            myFilterAttributes.put("val", "" + i);
            array[i] = XMLParser.extractByteArrayAndAttributesForTag(ex, "pos", null, myFilterAttributes);
        }
        return array;
    }

    public static int[][] extractInt2ArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractInt2ArrayAndAttributesForTag(source, tag, null, null);
    }

    public static int[][] extractInt2ArrayAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        int l = XMLParser.extractIntForTag(ex, "length");
        int[][] array = new int[l][];
        TreeMap<String, String> myFilterAttributes = new TreeMap<String, String>();
        for (int i = 0; i < l; ++i) {
            myFilterAttributes.clear();
            myFilterAttributes.put("val", "" + i);
            array[i] = XMLParser.extractIntArrayAndAttributesForTag(ex, "pos", null, myFilterAttributes);
        }
        return array;
    }

    public static double[][] extractDouble2ArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractDouble2ArrayAndAttributesForTag(source, tag, null, null);
    }

    public static double[][] extractDouble2ArrayAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        int l = XMLParser.extractIntForTag(ex, "length");
        double[][] array = new double[l][];
        TreeMap<String, String> myFilterAttributes = new TreeMap<String, String>();
        for (int i = 0; i < l; ++i) {
            myFilterAttributes.clear();
            myFilterAttributes.put("val", "" + i);
            array[i] = XMLParser.extractDoubleArrayAndAttributesForTag(ex, "pos", null, myFilterAttributes);
        }
        return array;
    }

    public static String[][] extractString2ArrayForTag(StringBuffer source, String tag) throws NonParsableException {
        return XMLParser.extractString2ArrayAndAttributesForTag(source, tag, null, null);
    }

    public static String[][] extractString2ArrayAndAttributesForTag(StringBuffer source, String tag, Map<String, String> attributes, Map<String, String> filterAttributes) throws NonParsableException {
        StringBuffer ex = XMLParser.extractForTag(source, tag, attributes, filterAttributes);
        int l = XMLParser.extractIntForTag(ex, "length");
        String[][] array = new String[l][];
        TreeMap<String, String> myFilterAttributes = new TreeMap<String, String>();
        for (int i = 0; i < l; ++i) {
            myFilterAttributes.clear();
            myFilterAttributes.put("val", "" + i);
            array[i] = XMLParser.extractStringArrayAndAttributesForTag(ex, "pos", null, myFilterAttributes);
        }
        return array;
    }

    public static void addTags(StringBuffer source, String tag) {
        XMLParser.addTagsAndAttributes(source, tag, null);
    }

    public static void addTagsAndAttributes(StringBuffer source, String tag, String attributes) {
        source.insert(0, "<" + tag + (attributes == null ? "" : " " + attributes) + ">\n");
        source.insert(source.length(), "</" + tag + ">\n");
    }

    public static void appendBooleanWithTags(StringBuffer source, boolean b, String tag) {
        XMLParser.appendBooleanWithTagsAndAttributes(source, b, tag, null);
    }

    public static void appendBooleanWithTagsAndAttributes(StringBuffer source, boolean b, String tag, String attributes) {
        XMLParser.appendStringWithTagsAndAttributes(source, "" + b, tag, attributes);
    }

    public static void appendByteWithTags(StringBuffer source, byte b, String tag) {
        XMLParser.appendByteWithTagsAndAttributes(source, b, tag, null);
    }

    public static void appendByteWithTagsAndAttributes(StringBuffer source, byte b, String tag, String attributes) {
        XMLParser.appendStringWithTagsAndAttributes(source, "" + b, tag, attributes);
    }

    public static <T extends Enum<T>> void appendEnumWithTags(StringBuffer source, Enum<T> e, String tag) {
        XMLParser.appendEnumWithTagsAndAttributes(source, e, tag, null);
    }

    public static <T extends Enum<T>> void appendEnumWithTagsAndAttributes(StringBuffer source, Enum<T> e, String tag, String attributes) {
        StringBuffer help = new StringBuffer(1000);
        XMLParser.appendStringWithTags(help, e.getClass().getName(), "enumName");
        XMLParser.appendStringWithTags(help, e.name(), "name");
        XMLParser.addTagsAndAttributes(help, tag, attributes);
        source.append(help);
    }

    public static void appendIntWithTags(StringBuffer source, int i, String tag) {
        XMLParser.appendIntWithTagsAndAttributes(source, i, tag, null);
    }

    public static void appendIntWithTagsAndAttributes(StringBuffer source, int i, String tag, String attributes) {
        XMLParser.appendStringWithTagsAndAttributes(source, "" + i, tag, attributes);
    }

    public static void appendLongWithTags(StringBuffer source, long i, String tag) {
        XMLParser.appendLongWithTagsAndAttributes(source, i, tag, null);
    }

    public static void appendLongWithTagsAndAttributes(StringBuffer source, long l, String tag, String attributes) {
        XMLParser.appendStringWithTagsAndAttributes(source, "" + l, tag, attributes);
    }

    public static void appendDoubleWithTags(StringBuffer source, double d, String tag) {
        XMLParser.appendDoubleWithTagsAndAttributes(source, d, tag, null);
    }

    public static void appendDoubleWithTagsAndAttributes(StringBuffer source, double d, String tag, String attributes) {
        XMLParser.appendStringWithTagsAndAttributes(source, "" + d, tag, attributes);
    }

    public static void appendStorableWithTags(StringBuffer source, Storable s, String tag) {
        XMLParser.appendStorableWithTagsAndAttributes(source, s, tag, null);
    }

    public static void appendStorableWithTagsAndAttributes(StringBuffer source, Storable s, String tag, String attributes) {
        StringBuffer help = new StringBuffer(1000);
        if (s != null) {
            XMLParser.appendStringWithTags(help, s.getClass().getName(), "className");
            help.append(s.toXML());
        } else {
            help.append("null");
        }
        XMLParser.addTagsAndAttributes(help, tag, attributes);
        source.append(help);
    }

    public static void appendStringWithTags(StringBuffer source, String s, String tag) {
        XMLParser.appendStringWithTagsAndAttributes(source, s, tag, null);
    }

    public static void appendStringWithTagsAndAttributes(StringBuffer source, String s, String tag, String attributes) {
        source.append("<" + tag + (attributes == null ? "" : " " + attributes) + ">" + s + "</" + tag + ">\n");
    }

    protected static StringBuffer getByteArrayWithTags(byte[] b) {
        int l = b.length;
        StringBuffer source = new StringBuffer(25 + l * 30);
        source.append("\t");
        XMLParser.appendIntWithTags(source, l, "length");
        for (int j = 0; j < l; ++j) {
            source.append("\t");
            XMLParser.appendByteWithTagsAndAttributes(source, b[j], "pos", "val=\"" + j + "\"");
        }
        return source;
    }

    protected static StringBuffer getIntArrayWithTags(int[] i) {
        int l = i.length;
        StringBuffer source = new StringBuffer(25 + l * 30);
        source.append("\t");
        XMLParser.appendIntWithTags(source, l, "length");
        for (int j = 0; j < l; ++j) {
            source.append("\t");
            XMLParser.appendIntWithTagsAndAttributes(source, i[j], "pos", "val=\"" + j + "\"");
        }
        return source;
    }

    protected static StringBuffer getDoubleArrayWithTags(double[] d) {
        int l = d.length;
        StringBuffer source = new StringBuffer(25 + l * 40);
        source.append("\t");
        XMLParser.appendIntWithTags(source, l, "length");
        for (int j = 0; j < l; ++j) {
            source.append("\t");
            XMLParser.appendDoubleWithTagsAndAttributes(source, d[j], "pos", "val=\"" + j + "\"");
        }
        return source;
    }

    protected static StringBuffer getBooleanArrayWithTags(boolean[] b) {
        int l = b.length;
        StringBuffer source = new StringBuffer(25 + l * 40);
        source.append("\t");
        XMLParser.appendIntWithTags(source, l, "length");
        for (int j = 0; j < l; ++j) {
            source.append("\t");
            XMLParser.appendBooleanWithTagsAndAttributes(source, b[j], "pos", "val=\"" + j + "\"");
        }
        return source;
    }

    protected static StringBuffer getStringArrayWithTags(String[] s) {
        int l = s.length;
        StringBuffer source = new StringBuffer(25 + l * 30);
        source.append("\t");
        XMLParser.appendIntWithTags(source, l, "length");
        for (int j = 0; j < l; ++j) {
            source.append("\t");
            XMLParser.appendStringWithTagsAndAttributes(source, s[j], "pos", "val=\"" + j + "\"");
        }
        return source;
    }

    protected static StringBuffer getStorableArrayWithTags(Storable[] s) {
        int l = s.length;
        StringBuffer source = new StringBuffer(25 + l * 1030);
        source.append("\t");
        XMLParser.appendIntWithTags(source, l, "length");
        for (int j = 0; j < l; ++j) {
            source.append("\t");
            XMLParser.appendStorableWithTagsAndAttributes(source, s[j], "pos", "val=\"" + j + "\"");
        }
        return source;
    }

    public static void appendBooleanArrayWithTags(StringBuffer source, boolean[] b, String tag) {
        XMLParser.appendBooleanArrayWithTagsAndAttributes(source, b, tag, null);
    }

    public static void appendBooleanArrayWithTagsAndAttributes(StringBuffer source, boolean[] b, String tag, String attributes) {
        StringBuffer help = XMLParser.getBooleanArrayWithTags(b);
        XMLParser.addTagsAndAttributes(help, tag, attributes);
        source.append(help);
    }

    public static void appendByteArrayWithTags(StringBuffer source, byte[] b, String tag) {
        XMLParser.appendByteArrayWithTagsAndAttributes(source, b, tag, null);
    }

    public static void appendByteArrayWithTagsAndAttributes(StringBuffer source, byte[] b, String tag, String attributes) {
        StringBuffer help = XMLParser.getByteArrayWithTags(b);
        XMLParser.addTagsAndAttributes(help, tag, attributes);
        source.append(help);
    }

    public static void appendIntArrayWithTags(StringBuffer source, int[] i, String tag) {
        XMLParser.appendIntArrayWithTagsAndAttributes(source, i, tag, null);
    }

    public static void appendIntArrayWithTagsAndAttributes(StringBuffer source, int[] i, String tag, String attributes) {
        StringBuffer help = XMLParser.getIntArrayWithTags(i);
        XMLParser.addTagsAndAttributes(help, tag, attributes);
        source.append(help);
    }

    public static void appendDoubleArrayWithTags(StringBuffer source, double[] d, String tag) {
        XMLParser.appendDoubleArrayWithTagsAndAttributes(source, d, tag, null);
    }

    public static void appendDoubleArrayWithTagsAndAttributes(StringBuffer source, double[] d, String tag, String attributes) {
        StringBuffer help = XMLParser.getDoubleArrayWithTags(d);
        XMLParser.addTagsAndAttributes(help, tag, attributes);
        source.append(help);
    }

    public static void appendStorableArrayWithTags(StringBuffer source, Storable[] s, String tag) {
        XMLParser.appendStorableArrayWithTagsAndAttributes(source, s, tag, null);
    }

    public static void appendStorableArrayWithTagsAndAttributes(StringBuffer source, Storable[] s, String tag, String attributes) {
        StringBuffer help = XMLParser.getStorableArrayWithTags(s);
        XMLParser.addTagsAndAttributes(help, tag, attributes);
        source.append(help);
    }

    public static void appendStringArrayWithTags(StringBuffer source, String[] s, String tag) {
        XMLParser.appendStringArrayWithTagsAndAttributes(source, s, tag, null);
    }

    public static void appendStringArrayWithTagsAndAttributes(StringBuffer source, String[] s, String tag, String attributes) {
        StringBuffer help = XMLParser.getStringArrayWithTags(s);
        XMLParser.addTagsAndAttributes(help, tag, attributes);
        source.append(help);
    }

    public static void appendBoolean2ArrayWithTags(StringBuffer source, boolean[][] i, String tag) {
        XMLParser.appendBoolean2ArrayWithTagsAndAttributes(source, i, tag, null);
    }

    public static void appendBoolean2ArrayWithTagsAndAttributes(StringBuffer source, boolean[][] i, String tag, String attributes) {
        int l = i.length;
        StringBuffer help1 = new StringBuffer(2500);
        help1.append("\t");
        XMLParser.appendIntWithTags(help1, l, "length");
        for (int j = 0; j < l; ++j) {
            StringBuffer help2 = XMLParser.getBooleanArrayWithTags(i[j]);
            help2.append("\t");
            XMLParser.addTagsAndAttributes(help2, "pos", "val=\"" + j + "\"");
            help2.insert(0, "\n\t");
            help1.append(help2);
        }
        XMLParser.addTagsAndAttributes(help1, tag, attributes);
        source.append(help1);
    }

    public static void appendByte2ArrayWithTags(StringBuffer source, byte[][] b, String tag) {
        XMLParser.appendByte2ArrayWithTagsAndAttributes(source, b, tag, null);
    }

    public static void appendByte2ArrayWithTagsAndAttributes(StringBuffer source, byte[][] b, String tag, String attributes) {
        int l = b.length;
        StringBuffer help1 = new StringBuffer(2500);
        help1.append("\t");
        XMLParser.appendIntWithTags(help1, l, "length");
        for (int j = 0; j < l; ++j) {
            StringBuffer help2 = XMLParser.getByteArrayWithTags(b[j]);
            help2.append("\t");
            XMLParser.addTagsAndAttributes(help2, "pos", "val=\"" + j + "\"");
            help2.insert(0, "\n\t");
            help1.append(help2);
        }
        XMLParser.addTagsAndAttributes(help1, tag, attributes);
        source.append(help1);
    }

    public static void appendInt2ArrayWithTags(StringBuffer source, int[][] i, String tag) {
        XMLParser.appendInt2ArrayWithTagsAndAttributes(source, i, tag, null);
    }

    public static void appendInt2ArrayWithTagsAndAttributes(StringBuffer source, int[][] i, String tag, String attributes) {
        int l = i.length;
        StringBuffer help1 = new StringBuffer(2500);
        help1.append("\t");
        XMLParser.appendIntWithTags(help1, l, "length");
        for (int j = 0; j < l; ++j) {
            StringBuffer help2 = XMLParser.getIntArrayWithTags(i[j]);
            help2.append("\t");
            XMLParser.addTagsAndAttributes(help2, "pos", "val=\"" + j + "\"");
            help2.insert(0, "\n\t");
            help1.append(help2);
        }
        XMLParser.addTagsAndAttributes(help1, tag, attributes);
        source.append(help1);
    }

    public static void appendDouble2ArrayWithTags(StringBuffer source, double[][] d, String tag) {
        XMLParser.appendDouble2ArrayWithTagsAndAttributes(source, d, tag, null);
    }

    public static void appendDouble2ArrayWithTagsAndAttributes(StringBuffer source, double[][] d, String tag, String attributes) {
        int l = d.length;
        StringBuffer help1 = new StringBuffer(2500);
        help1.append("\t");
        XMLParser.appendIntWithTags(help1, l, "length");
        for (int j = 0; j < l; ++j) {
            StringBuffer help2 = XMLParser.getDoubleArrayWithTags(d[j]);
            help2.append("\t");
            XMLParser.addTagsAndAttributes(help2, "pos", "val=\"" + j + "\"");
            help2.insert(0, "\n\t");
            help1.append(help2);
        }
        XMLParser.addTagsAndAttributes(help1, tag, attributes);
        source.append(help1);
    }

    public static void appendStorable2ArrayWithTags(StringBuffer source, Storable[][] s, String tag) {
        XMLParser.appendStorable2ArrayWithTagsAndAttributes(source, s, tag, null);
    }

    public static void appendStorable2ArrayWithTagsAndAttributes(StringBuffer source, Storable[][] s, String tag, String attributes) {
        int l = s.length;
        StringBuffer help1 = new StringBuffer(2500);
        help1.append("\t");
        XMLParser.appendIntWithTags(help1, l, "length");
        for (int j = 0; j < l; ++j) {
            StringBuffer help2 = XMLParser.getStorableArrayWithTags(s[j]);
            help2.append("\t");
            XMLParser.addTagsAndAttributes(help2, "pos", "val=\"" + j + "\"");
            help2.insert(0, "\n\t");
            help1.append(help2);
        }
        XMLParser.addTagsAndAttributes(help1, tag, attributes);
        source.append(help1);
    }

    public static void appendStorable3ArrayWithTags(StringBuffer source, Storable[][][] s, String tag) {
        XMLParser.appendStorable3ArrayWithTagsAndAttributes(source, s, tag, null);
    }

    public static void appendStorable3ArrayWithTagsAndAttributes(StringBuffer source, Storable[][][] s, String tag, String attributes) {
        int l = s.length;
        StringBuffer help1 = new StringBuffer(2500);
        help1.append("\t");
        XMLParser.appendIntWithTags(help1, l, "length");
        for (int j = 0; j < l; ++j) {
            XMLParser.appendStorable2ArrayWithTagsAndAttributes(help1, s[j], "pos", "val=\"" + j + "\"");
        }
        XMLParser.addTagsAndAttributes(help1, tag, attributes);
        source.append(help1);
    }

    public static void appendString2ArrayWithTags(StringBuffer source, String[][] s, String tag) {
        XMLParser.appendString2ArrayWithTagsAndAttributes(source, s, tag, null);
    }

    public static void appendString2ArrayWithTagsAndAttributes(StringBuffer source, String[][] s, String tag, String attributes) {
        int l = s.length;
        StringBuffer help1 = new StringBuffer(2500);
        help1.append("\t");
        XMLParser.appendIntWithTags(help1, l, "length");
        for (int j = 0; j < l; ++j) {
            StringBuffer help2 = XMLParser.getStringArrayWithTags(s[j]);
            help2.append("\t");
            XMLParser.addTagsAndAttributes(help2, "pos", "val=\"" + j + "\"");
            help2.insert(0, "\n\t");
            help1.append(help2);
        }
        XMLParser.addTagsAndAttributes(help1, tag, attributes);
        source.append(help1);
    }
}

