/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete.inhomogeneous;

import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.models.discrete.inhomogeneous.InhConstraint;
import de.jstacs.models.discrete.inhomogeneous.SequenceIterator;
import java.util.Arrays;

public class MEMConstraint
extends InhConstraint {
    private double[] expLambda;
    private double[] lambda;
    private int[] corrected_positions;
    private static String XML_TAG = "MEMConstraint";

    private static int[] isSorted(int[] pos) throws IllegalArgumentException {
        int i;
        for (i = 1; i < pos.length && pos[i - 1] < pos[i]; ++i) {
        }
        if (i < pos.length) {
            throw new IllegalArgumentException("The position array is not unique.");
        }
        return pos;
    }

    public MEMConstraint(int[] pos, int[] alphabetLength) throws IllegalArgumentException {
        super(MEMConstraint.isSorted(pos), alphabetLength);
        this.expLambda = new double[this.counts.length];
        Arrays.fill(this.expLambda, 1.0);
        this.lambda = new double[this.counts.length];
        this.corrected_positions = this.usedPositions;
    }

    public MEMConstraint(int[] pos, int[] alphabetLength, int[] corrected_positions) throws IllegalArgumentException {
        super(MEMConstraint.isSorted(pos), alphabetLength);
        if (pos.length != corrected_positions.length) {
            throw new IllegalArgumentException("The length of pos and corrected_positions is not equal.");
        }
        this.expLambda = new double[this.counts.length];
        this.lambda = new double[this.counts.length];
        this.corrected_positions = (int[])corrected_positions.clone();
    }

    public MEMConstraint(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public MEMConstraint clone() throws CloneNotSupportedException {
        MEMConstraint clone = (MEMConstraint)super.clone();
        clone.expLambda = (double[])this.expLambda.clone();
        clone.lambda = (double[])this.lambda.clone();
        clone.corrected_positions = this.corrected_positions == this.usedPositions ? clone.usedPositions : (int[])this.corrected_positions.clone();
        return clone;
    }

    @Override
    public void estimate(double ess) {
        this.estimateUnConditional(0, this.freq.length, ess / (double)this.freq.length, true);
    }

    public int getCorrectedPosition(int index) {
        return this.corrected_positions[index];
    }

    public double getExpLambda(int index) {
        return this.expLambda[index];
    }

    public double getLambda(int index) {
        return this.lambda[index];
    }

    public void multiplyExpLambdaWith(int index, double val) {
        int n = index;
        this.expLambda[n] = this.expLambda[n] * val;
        int n2 = index;
        this.lambda[n2] = this.lambda[n2] + Math.log(val);
    }

    @Override
    public void reset() {
        super.reset();
        Arrays.fill(this.expLambda, 1.0);
        Arrays.fill(this.lambda, 0.0);
    }

    public int satisfiesSpecificConstraint(SequenceIterator sequence) {
        int erg = 0;
        for (int i = 0; i < this.corrected_positions.length; ++i) {
            erg += this.offset[i] * sequence.seq[this.corrected_positions[i]];
        }
        return erg;
    }

    @Override
    public double getFreq(int index) {
        return this.freq[index];
    }

    public void setExpLambda(int index, double val) {
        this.expLambda[index] = val;
        this.lambda[index] = Math.log(val);
    }

    public void setLambda(int index, double val) {
        this.expLambda[index] = Math.exp(val);
        this.lambda[index] = val;
    }

    @Override
    public String toString() {
        String erg = "" + this.usedPositions[0];
        for (int i = 1; i < this.usedPositions.length; ++i) {
            erg = erg + ", " + this.usedPositions[i];
        }
        return erg;
    }

    @Override
    protected void appendAdditionalInfo(StringBuffer xml) {
        super.appendAdditionalInfo(xml);
        XMLParser.appendDoubleArrayWithTags(xml, this.lambda, "lambda");
        if (this.corrected_positions != this.usedPositions) {
            StringBuffer b = new StringBuffer(500);
            XMLParser.appendIntArrayWithTags(b, this.corrected_positions, "corrected_positions");
            XMLParser.addTags(b, "corrected");
            xml.append(b);
        }
    }

    @Override
    protected String getXMLTag() {
        return XML_TAG;
    }

    @Override
    protected void extractAdditionalInfo(StringBuffer xml) throws NonParsableException {
        super.extractAdditionalInfo(xml);
        this.lambda = XMLParser.extractDoubleArrayForTag(xml, "lambda");
        this.expLambda = new double[this.lambda.length];
        for (int i = 0; i < this.lambda.length; ++i) {
            this.expLambda[i] = Math.exp(this.lambda[i]);
        }
        StringBuffer corrected = XMLParser.extractForTag(xml, "corrected");
        this.corrected_positions = corrected == null ? this.usedPositions : XMLParser.extractIntArrayForTag(corrected, "corrected_positions");
    }
}

