/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery.history;

import de.jstacs.motifDiscovery.history.History;

public class CappedHistory
implements History {
    private int threshold;
    private int number;
    private History h;

    public CappedHistory(int t, History h) throws CloneNotSupportedException {
        if (t < 0) {
            throw new IllegalArgumentException("The threshold has to be non-negative.");
        }
        this.threshold = t;
        this.h = h.clone();
        this.clear();
    }

    @Override
    public CappedHistory clone() throws CloneNotSupportedException {
        CappedHistory clone = (CappedHistory)super.clone();
        clone.h = this.h.clone();
        return clone;
    }

    @Override
    public void clear() {
        this.number = 0;
        this.h.clear();
    }

    @Override
    public boolean operationAllowed(int ... op) {
        if (this.number < this.threshold) {
            return this.h.operationAllowed(op);
        }
        return false;
    }

    @Override
    public void operationPerfomed(int ... op) {
        ++this.number;
        if (this.number <= this.threshold) {
            this.h.operationPerfomed(op);
        }
    }
}

