/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery.history;

import de.jstacs.motifDiscovery.history.History;
import java.util.Iterator;
import java.util.LinkedList;

public class NoRevertHistory
implements History {
    private int[] current;
    private LinkedList<int[]> list;
    private boolean allowShift;
    private boolean allowShrink;
    private boolean allowExpand;

    public NoRevertHistory() {
        this(true, true, true);
    }

    public NoRevertHistory(boolean allowShift, boolean allowShrink, boolean allowExpand) {
        this.allowShift = allowShift;
        this.allowShrink = allowShrink;
        this.allowExpand = allowExpand;
        this.list = new LinkedList();
        this.clear();
    }

    @Override
    public NoRevertHistory clone() throws CloneNotSupportedException {
        NoRevertHistory clone = (NoRevertHistory)super.clone();
        clone.current = (int[])this.current.clone();
        clone.list = new LinkedList();
        Iterator it = this.list.iterator();
        while (it.hasNext()) {
            clone.list.add((int[])((int[])it.next()).clone());
        }
        return clone;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.current = new int[]{0, 0};
        this.list.add((int[])this.current.clone());
    }

    @Override
    public boolean operationAllowed(int ... op) {
        if (op.length != 2) {
            return false;
        }
        int sum = op[1] - op[0];
        if (sum < 0) {
            return this.allowShrink;
        }
        if (!this.allowShift && sum == 0 || !this.allowExpand && sum > 0) {
            return false;
        }
        Iterator it = this.list.iterator();
        int[] temp = new int[]{this.current[0] + op[0], this.current[1] + op[1]};
        while (it.hasNext()) {
            int[] temp2 = (int[])it.next();
            if (temp[0] != temp2[0] || temp[1] != temp2[1]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void operationPerfomed(int ... op) {
        this.current[0] = this.current[0] + op[0];
        this.current[1] = this.current[1] + op[1];
        this.list.add((int[])this.current.clone());
    }
}

