/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;
import java.util.Collection;

public class ResultSet
implements Storable {
    protected Result[] results;

    public ResultSet(Result result) {
        this.results = new Result[]{result};
    }

    public ResultSet(Result[] ... results) {
        if (results == null) {
            this.results = new Result[0];
        } else {
            int i;
            int c = 0;
            for (i = 0; i < results.length; ++i) {
                c += results[i] == null ? 0 : results[i].length;
            }
            this.results = new Result[c];
            c = 0;
            for (i = 0; i < results.length; ++i) {
                if (results[i] == null) continue;
                System.arraycopy(results[i], 0, this.results, c, results[i].length);
                c += results[i].length;
            }
        }
    }

    public ResultSet(Collection<? extends Result> results) {
        this.results = results.toArray(new Result[0]);
    }

    public ResultSet(StringBuffer representation) throws NonParsableException {
        this.fromXML(representation);
    }

    public Result getResultAt(int index) {
        return this.results[index];
    }

    public Result[] getResults() {
        Result[] res = new Result[this.results.length];
        System.arraycopy(this.results, 0, res, 0, res.length);
        return res;
    }

    public int getNumberOfResults() {
        return this.results.length;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendStorableArrayWithTags(buf, this.results, "resStrings");
        XMLParser.addTags(buf, "resultSet");
        return buf;
    }

    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "resultSet");
        this.results = ArrayHandler.cast(Result.class, XMLParser.extractStorableArrayForTag(representation, "resStrings"));
    }

    public String toString() {
        StringBuffer help = new StringBuffer(100 * this.results.length);
        for (int i = 0; i < this.results.length; ++i) {
            help.append(this.results[i].toString() + "\n");
        }
        return help.toString();
    }

    public int findColumn(String columnName) {
        for (int i = 0; i < this.results.length; ++i) {
            if (!this.results[i].getName().equals(columnName)) continue;
            return i;
        }
        return -1;
    }
}

