/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.directedGraphicalModels;

import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.Mutable;
import de.jstacs.scoringFunctions.directedGraphicalModels.BayesianNetworkScoringFunction;
import de.jstacs.scoringFunctions.directedGraphicalModels.ParameterTree;
import de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.InhomogeneousMarkov;
import de.jstacs.scoringFunctions.mix.motifSearch.DurationScoringFunction;

public class MutableMarkovModelScoringFunction
extends BayesianNetworkScoringFunction
implements Mutable {
    private DurationScoringFunction lengthPenalty;
    private static final String XML_TAG = "MutableMarkovModelScoringFunction";

    public MutableMarkovModelScoringFunction(AlphabetContainer alphabet, int length, double ess, boolean plugInParameters, int order, DurationScoringFunction lengthPenalty) throws Exception {
        this(alphabet, length, ess, plugInParameters, new InhomogeneousMarkov(order), lengthPenalty);
    }

    public MutableMarkovModelScoringFunction(AlphabetContainer alphabet, int length, double ess, boolean plugInParameters, InhomogeneousMarkov structureMeasure) throws Exception {
        super(alphabet, length, ess, plugInParameters, structureMeasure);
    }

    public MutableMarkovModelScoringFunction(AlphabetContainer alphabet, int length, double ess, boolean plugInParameters, InhomogeneousMarkov structureMeasure, DurationScoringFunction lengthPenalty) throws Exception {
        this(alphabet, length, ess, plugInParameters, structureMeasure);
        this.lengthPenalty = lengthPenalty;
        if (lengthPenalty != null && !lengthPenalty.isPossible(length)) {
            throw new IllegalArgumentException("This motif length is not possible: " + length);
        }
    }

    public MutableMarkovModelScoringFunction(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    protected void fromXML(StringBuffer source) throws NonParsableException {
        StringBuffer sb = XMLParser.extractForTag(source, XML_TAG);
        this.lengthPenalty = (DurationScoringFunction)XMLParser.extractStorableForTag(sb, "lengthPenalty");
        super.fromXML(sb);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer sb = super.toXML();
        XMLParser.appendStorableWithTags(sb, this.lengthPenalty, "lengthPenalty");
        XMLParser.addTags(sb, XML_TAG);
        return sb;
    }

    @Override
    public double getLogPriorTerm() {
        if (this.lengthPenalty != null) {
            return super.getLogPriorTerm() + this.lengthPenalty.getLogScore(this.length);
        }
        return super.getLogPriorTerm();
    }

    @Override
    public boolean modify(int offsetLeft, int offsetRight) {
        if (!this.getAlphabetContainer().isSimple()) {
            return false;
        }
        if (offsetLeft == 0 && offsetRight == 0) {
            return true;
        }
        this.precomputeNormalization();
        this.normalizeParameters();
        this.precomputeNormalization();
        ParameterTree[] backTrees = this.trees;
        int backLength = this.length;
        try {
            this.length = this.length - offsetLeft + offsetRight;
            if (this.lengthPenalty != null && !this.lengthPenalty.isPossible(this.length)) {
                throw new IllegalArgumentException("This motif length is not possible: " + this.length);
            }
            this.createTrees(new Sample[]{null, null}, new double[][]{null, null});
            int indexNew = 0;
            int indexOld = 0;
            if (offsetLeft >= 0) {
                indexOld = offsetLeft;
            } else {
                indexNew = -offsetLeft;
            }
            while (indexOld < backTrees.length && indexNew < this.trees.length) {
                this.trees[indexNew].copy(backTrees[indexOld]);
                ++indexNew;
                ++indexOld;
            }
            if (indexNew < this.trees.length) {
                indexNew = this.trees.length;
            }
            this.logNormalizationConstant = null;
            return true;
        }
        catch (Exception e) {
            this.length = backLength;
            this.trees = backTrees;
            this.logNormalizationConstant = null;
            return false;
        }
    }

    private void normalizeParameters() {
        for (int i = 0; i < this.trees.length; ++i) {
            this.trees[i].normalizeParameters();
        }
    }
}

