/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.Measure;

public class InhomogeneousMarkov
extends Measure {
    private int order;
    private InhomogeneousMarkovParameterSet parameters;

    public InhomogeneousMarkov(int order) {
        this.order = order;
    }

    public InhomogeneousMarkov(InhomogeneousMarkovParameterSet parameters) {
        this(parameters.getOrder());
        this.parameters = parameters;
    }

    public InhomogeneousMarkov(StringBuffer buf) throws NonParsableException {
        buf = XMLParser.extractForTag(buf, "inhomogeneousMarkov");
        this.order = XMLParser.extractIntForTag(buf, "order");
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public InhomogeneousMarkov clone() throws CloneNotSupportedException {
        return (InhomogeneousMarkov)super.clone();
    }

    @Override
    public String getInstanceName() {
        return "Inhomogeneous Markov model of order " + this.order;
    }

    @Override
    public int[][] getParents(Sample fg, Sample bg, double[] weightsFg, double[] weightsBg, int length) throws Exception {
        int[][] parents = new int[length][];
        for (int i = 0; i < parents.length; ++i) {
            parents[i] = new int[(this.order < i ? this.order : i) + 1];
            for (int j = i; j >= i - this.order && j >= 0; --j) {
                parents[i][parents[i].length - (i - j) - 1] = j;
            }
        }
        return parents;
    }

    @Override
    public boolean isShiftable() {
        return true;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendIntWithTags(buf, this.order, "order");
        XMLParser.addTags(buf, "inhomogeneousMarkov");
        return buf;
    }

    @Override
    public InstanceParameterSet getCurrentParameterSet() throws Exception {
        if (this.parameters != null) {
            return this.parameters;
        }
        return new InhomogeneousMarkovParameterSet(this.order);
    }

    public static class InhomogeneousMarkovParameterSet
    extends InstanceParameterSet {
        public InhomogeneousMarkovParameterSet() {
            super(InhomogeneousMarkov.class);
        }

        public InhomogeneousMarkovParameterSet(int order) throws Exception {
            super(InhomogeneousMarkov.class);
            this.loadParameters();
            ((Parameter)this.parameters.get(0)).setValue(order);
        }

        public InhomogeneousMarkovParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        @Override
        public String getInstanceComment() {
            return "Inhomogeneous Markov model structure";
        }

        @Override
        public String getInstanceName() {
            return "Inhomogeneous Markov model";
        }

        public int getOrder() {
            return (Integer)((Parameter)this.parameters.get(0)).getValue();
        }

        @Override
        protected void loadParameters() throws Exception {
            this.initParameterList();
            this.parameters.add(new SimpleParameter(DataType.INT, "Order", "The order of the Markov model.", true));
        }
    }
}

