/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

public class Normalisation {
    public static double getLogSum(double ... lnVal) {
        return Normalisation.getLogSum(0, lnVal.length, lnVal);
    }

    public static double getLogSum(int start, int end, double ... lnVal) {
        int i;
        double offset = lnVal[start];
        double sum = 0.0;
        for (i = start + 1; i < end; ++i) {
            offset = Math.max(offset, lnVal[i]);
        }
        if (Double.isInfinite(offset)) {
            return Double.NEGATIVE_INFINITY;
        }
        for (i = start; i < end; ++i) {
            sum += Math.exp(lnVal[i] - offset);
        }
        return offset + Math.log(sum);
    }

    public static double logSumNormalisation(double[] d) {
        return Normalisation.logSumNormalisation(d, 0, d.length, d, 0);
    }

    public static double logSumNormalisation(double[] d, int startD, int endD) {
        return Normalisation.logSumNormalisation(d, startD, endD, d, startD);
    }

    public static double logSumNormalisation(double[] d, int startD, int endD, double[] secondValues) {
        return Normalisation.logSumNormalisation(d, startD, endD, secondValues, d, startD);
    }

    public static double logSumNormalisation(double[] d, int startD, int endD, double[] dest, int startDest) {
        return Normalisation.logSumNormalisation(d, startD, endD, null, dest, startDest);
    }

    public static double logSumNormalisation(double[] d, int startD, int endD, double[] secondValues, double[] dest, int startDest) {
        int i;
        double offset = Double.NEGATIVE_INFINITY;
        for (i = startD; i < endD; ++i) {
            offset = Math.max(offset, d[i]);
        }
        if (secondValues != null) {
            for (i = 0; i < secondValues.length; ++i) {
                offset = Math.max(offset, secondValues[i]);
            }
        }
        return Normalisation.logSumNormalisation(d, startD, endD, offset, secondValues, dest, startDest);
    }

    public static double logSumNormalisation(double[] d, double offset) {
        return Normalisation.logSumNormalisation(d, 0, d.length, offset, d, 0);
    }

    public static double logSumNormalisation(double[] d, int startD, int endD, double offset, double[] dest, int startDest) {
        return Normalisation.logSumNormalisation(d, startD, endD, offset, null, dest, startDest);
    }

    public static double logSumNormalisation(double[] d, int startD, int endD, double offset, double[] secondValues, double[] dest, int startDest) {
        int i;
        double sum = 0.0;
        int l = endD - startD;
        for (i = 0; i < l; ++i) {
            dest[startDest + i] = Math.exp(d[startD + i] - offset);
            sum += dest[startDest + i];
        }
        if (secondValues != null) {
            for (i = 0; i < secondValues.length; ++i) {
                secondValues[i] = Math.exp(secondValues[i] - offset);
                sum += secondValues[i];
            }
        }
        if (sum != 1.0) {
            Normalisation.normalisation(dest, sum, startDest, startDest + l);
            if (secondValues != null) {
                Normalisation.normalisation(secondValues, sum);
            }
        }
        return offset + Math.log(sum);
    }

    public static double sumNormalisation(double[] d) {
        return Normalisation.sumNormalisation(d, d, 0);
    }

    public static double sumNormalisation(double[] d, double[] dest, int start) {
        double sum = d[0];
        for (int i = 1; i < d.length; ++i) {
            sum += d[i];
        }
        Normalisation.normalisation(d, sum, dest, start);
        return sum;
    }

    public static void normalisation(double[] d, double v) {
        Normalisation.normalisation(d, v, d, 0);
    }

    public static void normalisation(double[] d, double v, double[] dest, int start) {
        int i = 0;
        while (i < d.length) {
            dest[start] = d[i] / v;
            ++i;
            ++start;
        }
    }

    public static void normalisation(double[] d, double v, int start, int end) {
        while (start < end) {
            int n = start++;
            d[n] = d[n] / v;
        }
    }
}

