/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import de.jstacs.io.RegExFilenameFilter;
import de.jstacs.utils.RUtils;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.RList;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RserveException;

public class REnvironment {
    private RConnection c;
    private HashSet<String> filesOnTheServer;
    private int initSize;
    private boolean windows;
    private boolean pngOkay;

    private REnvironment(String server, boolean defaultPort, int port, String user, String passwd, int initSize) throws Exception {
        this.c = defaultPort ? new RConnection(server) : new RConnection(server, port);
        if (this.c.needLogin()) {
            this.c.login(user, passwd);
        }
        if (initSize < 1) {
            throw new IOException("initSize has to be at least 1");
        }
        this.initSize = initSize;
        this.resetFilesOnTheServer();
        this.windows = this.eval(".Platform$OS.type").asString().equalsIgnoreCase("windows");
        this.pngOkay = Integer.parseInt(System.getProperty("java.version").substring(2, 3)) > 5;
    }

    public REnvironment(String server, String user, String passwd, int initSize) throws Exception {
        this(server, true, -1, user, passwd, initSize);
    }

    public REnvironment(String server, String user, String passwd) throws Exception {
        this(server, true, -1, user, passwd, 10);
    }

    public REnvironment(String server, int port, String user, String passwd, int initSize) throws Exception {
        this(server, false, port, user, passwd, initSize);
    }

    public REnvironment(String server, int port, String user, String passwd) throws Exception {
        this(server, false, port, user, passwd, 10);
    }

    public boolean copyFileFromServer(String serverFileName, String clientFileName, boolean overwriteExistingFile) throws Exception {
        if (!new File(clientFileName).exists() || overwriteExistingFile) {
            RUtils.copyFileFromServer(serverFileName, clientFileName, this.c);
            return true;
        }
        return false;
    }

    public boolean copyFileToServer(String clientFileName, String serverFileName, boolean overwriteExistingFile) throws Exception {
        if (this.filesOnTheServer.contains(serverFileName)) {
            if (overwriteExistingFile) {
                RUtils.copyFileToServer(clientFileName, serverFileName, this.c);
                return true;
            }
            return false;
        }
        RUtils.copyFileToServer(clientFileName, serverFileName, this.c);
        this.filesOnTheServer.add(serverFileName);
        return true;
    }

    public void close() throws Exception {
        this.deleteAllFilesAtTheServer();
        this.c.close();
    }

    public REXP createMatrix(String matrixName, int[][] matrix) throws RserveException, IllegalArgumentException {
        StringBuffer cmd = new StringBuffer(matrix.length * matrix[0].length * 20);
        cmd.append(matrixName + " = matrix( c(");
        int rows = matrix.length;
        int columns = matrix[0].length;
        for (int counter1 = 0; counter1 < rows; ++counter1) {
            if (columns != matrix[0].length) {
                throw new IllegalArgumentException("The matrix is not rectangular");
            }
            for (int counter2 = 0; counter2 < columns; ++counter2) {
                if (counter1 == 0 && counter2 == 0) {
                    cmd.append(matrix[counter1][counter2]);
                    continue;
                }
                cmd.append(", " + matrix[counter1][counter2]);
            }
        }
        return this.c.eval(cmd + "), nrow = " + rows + ", ncol = " + columns + ", byrow = TRUE );");
    }

    public REXP createMatrix(String matrixName, double[][] matrix) throws RserveException, IllegalArgumentException {
        StringBuffer cmd = new StringBuffer(matrix.length * matrix[0].length * 20);
        cmd.append(matrixName + " = matrix( c(");
        int rows = matrix.length;
        int columns = matrix[0].length;
        for (int counter1 = 0; counter1 < rows; ++counter1) {
            if (columns != matrix[0].length) {
                throw new IllegalArgumentException("The matrix is not rectangular");
            }
            for (int counter2 = 0; counter2 < columns; ++counter2) {
                if (counter1 == 0 && counter2 == 0) {
                    cmd.append(this.getDoubleVal(matrix[counter1][counter2]));
                    continue;
                }
                cmd.append(", " + this.getDoubleVal(matrix[counter1][counter2]));
            }
        }
        cmd.append("), nrow = " + rows + ", ncol = " + columns + ", byrow = TRUE );");
        return this.c.eval(cmd.toString());
    }

    private String getDoubleVal(double val) {
        if (Double.isInfinite(val)) {
            if (Double.NEGATIVE_INFINITY == val) {
                return "-Inf";
            }
            return "Inf";
        }
        return "" + val;
    }

    public REXP createVector(String vectorName, String[] vector) throws RserveException {
        StringBuffer cmd = new StringBuffer(vector.length * 100);
        cmd.append(vectorName + " = c(\"" + vector[0] + "\"");
        for (int i = 1; i < vector.length; ++i) {
            cmd.append(", \"" + vector[i] + "\"");
        }
        return this.c.eval(cmd + ");");
    }

    public REXP createVector(String vectorName, int[] vector) throws RserveException {
        StringBuffer cmd = new StringBuffer(vector.length * 20);
        cmd.append(vectorName + " = c(" + vector[0]);
        for (int i = 1; i < vector.length; ++i) {
            cmd.append(", " + vector[i]);
        }
        return this.c.eval(cmd + ");");
    }

    public REXP createVector(String vectorName, long[] vector) throws RserveException {
        StringBuffer cmd = new StringBuffer(vector.length * 20);
        cmd.append(vectorName + " = c(" + vector[0]);
        for (int i = 1; i < vector.length; ++i) {
            cmd.append(", " + vector[i]);
        }
        return this.c.eval(cmd + ");");
    }

    public REXP createVector(String vectorName, double[] vector) throws RserveException {
        StringBuffer cmd = new StringBuffer(vector.length * 20);
        cmd.append(vectorName + " = c(" + this.getDoubleVal(vector[0]));
        for (int i = 1; i < vector.length; ++i) {
            cmd.append(", " + this.getDoubleVal(vector[i]));
        }
        return this.c.eval(cmd + ");");
    }

    public void deleteAllFilesAtTheServer() throws Exception {
        Iterator<String> it = this.filesOnTheServer.iterator();
        Exception e = null;
        int removed = 0;
        int resisted = 0;
        while (it.hasNext()) {
            try {
                this.c.removeFile(it.next());
                ++removed;
            }
            catch (Exception ex) {
                e = ex;
                ++resisted;
            }
        }
        this.resetFilesOnTheServer();
        if (e != null) {
            System.err.println(resisted + " files resisted (" + removed + " files could be removed)");
            throw e;
        }
    }

    public REXP eval(String cmd) throws Exception {
        return this.c.eval(cmd);
    }

    public String getVersionInformation() throws Exception {
        RList l = this.eval("version").asList();
        String[] s = l.keys();
        String erg = "";
        for (int counter1 = 0; counter1 < s.length; ++counter1) {
            erg = erg + s[counter1] + ": \"" + l.at(s[counter1]).asString() + "\"\n";
        }
        return erg;
    }

    public void installScript(String clientFileName, String serverFileName, boolean overwriteExistingFile) throws Exception {
        this.copyFileToServer(clientFileName, serverFileName, overwriteExistingFile);
        this.voidEval("source(\"" + serverFileName + "\")");
    }

    public BufferedImage plot(String pltcmd) throws Exception {
        return this.plot(pltcmd, -1.0, -1.0);
    }

    public BufferedImage plot(String pltcmd, double width, double height) throws Exception {
        String serverFileName = "help-" + System.currentTimeMillis();
        if (this.windows) {
            if (this.pngOkay) {
                if (height > 0.0 && width > 0.0) {
                    this.plot(this.eval("try( png( filename = \"" + serverFileName + "\", width = " + width + ", height = " + height + " ) )"), pltcmd, "png");
                } else {
                    this.plot(this.eval("try( png( filename = \"" + serverFileName + "\" ) )"), pltcmd, "png");
                }
            } else if (height > 0.0 && width > 0.0) {
                this.plot(this.eval("try( jpeg( filename = \"" + serverFileName + "\", width = " + width + ", height = " + height + ", quality = 100) )"), pltcmd, "jpeg");
            } else {
                this.plot(this.eval("try( jpeg( filename = \"" + serverFileName + "\" ), quality = 100 )"), pltcmd, "jpeg");
            }
        } else {
            String type;
            String file;
            if (this.pngOkay) {
                file = "png";
                type = "png16m";
            } else {
                file = "jpeg";
                type = "jpeg";
            }
            if (height > 0.0 && width > 0.0) {
                this.plot(this.eval("try( bitmap( file = \"" + serverFileName + "\", width = " + width / 72.0 + ", height = " + height / 72.0 + ", type=\"" + type + "\" ) )"), pltcmd, file);
            } else {
                this.plot(this.eval("try( bitmap( file = \"" + serverFileName + "\", type=\"" + type + "\" ) )"), pltcmd, file);
            }
        }
        BufferedImage i = ImageIO.read(new BufferedInputStream(new ByteArrayInputStream(RUtils.getBytesFromFileOnServer(serverFileName, this.c))));
        this.filesOnTheServer.add(serverFileName);
        return i;
    }

    public void plot(String pltcmd, double width, double height, String formatName, OutputStream out) throws IOException, Exception {
        ImageIO.write((RenderedImage)this.plot(pltcmd, width, height), formatName, out);
    }

    public boolean plotToPDF(String pltcmd, String fileName, boolean overwriteExistingFile) throws Exception {
        return this.plotToPDF(pltcmd, -1.0, -1.0, fileName, overwriteExistingFile);
    }

    public boolean plotToPDF(String pltcmd, double width, double height, String fileName, boolean overwriteExistingFile) throws Exception {
        String graphicTyp = "pdf";
        String serverFileName = "tmp-" + System.currentTimeMillis() + "." + graphicTyp;
        if (height > 0.0 && width > 0.0) {
            return this.plotToFile(this.eval("try( pdf( \"" + serverFileName + "\", width = " + width + ", height = " + height + " ) )"), pltcmd, fileName, serverFileName, graphicTyp, overwriteExistingFile);
        }
        return this.plotToFile(this.eval("try( pdf( \"" + serverFileName + "\" ) )"), pltcmd, fileName, serverFileName, graphicTyp, overwriteExistingFile);
    }

    public boolean plotToTexFile(String pltcmd, String fileName, boolean overwriteExistingFile) throws Exception {
        return this.plotToTexFile(pltcmd, -1.0, -1.0, fileName, overwriteExistingFile);
    }

    public boolean plotToTexFile(String pltcmd, double width, double height, String fileName, boolean overwriteExistingFile) throws Exception {
        String graphicTyp = "tex";
        String serverFileName = "tmp-" + System.currentTimeMillis() + "." + graphicTyp;
        if (height > 0.0 && width > 0.0) {
            return this.plotToFile(this.eval("try( pictex( \"" + serverFileName + "\", width = " + width + ", height = " + height + " ) )"), pltcmd, fileName, serverFileName, graphicTyp, overwriteExistingFile);
        }
        return this.plotToFile(this.eval("try( pictex( \"" + serverFileName + "\" ) )"), pltcmd, fileName, serverFileName, graphicTyp, overwriteExistingFile);
    }

    public void voidEval(String cmd) throws Exception {
        this.c.voidEval(cmd);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private boolean plotToFile(REXP xp, String pltcmd, String fileName, String serverFileName, String graphicTyp, boolean overwriteExistingFile) throws Exception {
        this.filesOnTheServer.add(serverFileName);
        this.plot(xp, pltcmd, graphicTyp);
        boolean b = this.copyFileFromServer(serverFileName, fileName, overwriteExistingFile);
        return b;
    }

    private void plot(REXP xp, String pltcmd, String graphicTyp) throws Exception {
        if (!xp.isNull()) {
            String msg = "Can't open " + graphicTyp + " graphics device:\n\t" + xp.asString();
            xp = this.eval("if (exists(\"last.warning\") && length(last.warning)>0) names(last.warning)[1] else 0");
            if (xp.asString() != null) {
                msg = msg + "\t=> " + xp.asString();
            }
            throw new IOException(msg);
        }
        this.voidEval(pltcmd);
        this.voidEval("dev.off()");
    }

    private void resetFilesOnTheServer() {
        if (this.filesOnTheServer == null) {
            this.filesOnTheServer = new HashSet(this.initSize);
        } else {
            this.filesOnTheServer.clear();
        }
    }

    public static JFrame showImage(String title, BufferedImage img) throws InterruptedException {
        return REnvironment.showImage(title, img, 2);
    }

    public static JFrame showImage(String title, BufferedImage img, int defaultCloseOperation) throws InterruptedException {
        JFrame f = new JFrame(title);
        f.add(new ImageDisplay(img, true));
        f.setDefaultCloseOperation(defaultCloseOperation);
        f.pack();
        f.setVisible(true);
        return f;
    }

    private static class ImageDisplay
    extends Canvas {
        private static final long serialVersionUID = 1L;
        private boolean rescale;
        private BufferedImage img;

        public ImageDisplay(BufferedImage img, boolean rescale) throws InterruptedException {
            this.img = img;
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(img, 0);
            mediaTracker.waitForID(0);
            this.setSize(img.getWidth(this), img.getHeight(this));
            this.setRescale(rescale);
            this.addMouseListener(new MyMouseListener());
        }

        public ImageDisplay(BufferedImage img, boolean rescale, int width, int height) throws InterruptedException {
            this.img = img;
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(img, 0);
            mediaTracker.waitForID(0);
            this.setSize(width, height);
            this.setRescale(rescale);
        }

        private void setRescale(boolean rescale) {
            this.rescale = rescale;
        }

        @Override
        public void paint(Graphics g) {
            if (this.rescale) {
                g.drawImage(this.img.getScaledInstance(this.getWidth(), this.getHeight(), 4), 0, 0, null);
            } else {
                g.drawImage(this.img, 0, 0, null);
            }
        }

        private class MyMouseListener
        implements MouseListener {
            private MyMouseListener() {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setAcceptAllFileFilterUsed(false);
                chooser.setFileFilter(new RegExFilenameFilter("png-image", true, false, ".*\\.png"));
                chooser.setMultiSelectionEnabled(false);
                if (chooser.showSaveDialog(new JFrame()) == 0) {
                    try {
                        File f = chooser.getSelectedFile();
                        String name = f.getAbsolutePath();
                        if (!name.endsWith(".png")) {
                            f = new File(name + ".png");
                        }
                        ImageIO.write((RenderedImage)ImageDisplay.this.img, "png", f);
                    }
                    catch (Exception ex) {
                        JOptionPane.showMessageDialog(new JFrame(), "Could not save the image:" + ex.getClass().getName());
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        }
    }
}

