/*
 * This file is part of Jstacs.
 *
 * Jstacs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Jstacs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jstacs.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package de.jstacs.algorithms.optimization.termination;

import de.jstacs.utils.Time;


/**
 * This class stops an optimization if the value of the function
 * becomes less or equal to an absolute value, i.e.,
 * {@latex.inline $f(\\underline{x}_i) \\le t$}.
 * 
 * @author Jens Keilwagen
 * 
 * @deprecated use of the absolute value condition is not recommended and it may be removed in future releases
 */
public class AbsoluteValueCondition implements TerminationCondition {

	private double threshold;
	
	/**
	 * This constructor creates an instance that stops an minimization when the value of the function is below the given <code>threshold</code>  
	 * <br>
	 * 
	 * Be careful! If you set the value too low the minimization will not terminate.
	 * 
	 * @param threshold the threshold for stopping the optimization
	 */
	public AbsoluteValueCondition( double threshold ) {
		this.threshold = threshold;
	}
	
	public boolean doNextIteration( int iteration, double f_last, double f_current, double[] gradient, double[] direction, double alpha,
			Time t ) {
		return threshold > f_current;
	}
}
