/*
 * This file is part of Jstacs.
 *
 * Jstacs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Jstacs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jstacs.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package de.jstacs.algorithms.optimization.termination;

import de.jstacs.utils.Time;

/**
 * This class will stop an optimization if the number of iteration reaches  a given number.
 * 
 * @author Jens Keilwagen
 */
public class IterationCondition implements TerminationCondition {

	private int maxIter;
	
	/**
	 * This constructor creates an instance that does not allow any further iteration after <code>maxIter</code> iterations.
	 * 
	 * @param maxIter the maximal number of iterations
	 */
	public IterationCondition( int maxIter ) {
		if( maxIter < 0 ) {
			throw new IllegalArgumentException( "The number of maximal iteration has to be non-negative." );
		}
		this.maxIter = maxIter;
	}
	
	public boolean doNextIteration( int iteration, double f_last, double f_current, double[] gradient, double[] direction, double alpha,
			Time t ) {
		return iteration < maxIter;
	}
}
