package de.jstacs.io;

import java.io.File;
import java.io.FileFilter;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * This class implements a {@link FileFilter} that accepts {@link File}s that were modified after the date that is given in the constructor.
 * 
 * @author Jens Keilwagen
 */
public class DateFileFilter implements FileFilter {

	private long time;
	private String desc;
	
	/**
	 * Creates an instance that accepts {@link File}s that were modified after the given year, month, ... .
	 * 
	 * @param year the year
	 * @param month the month
	 * @param dayOfMonth the day of the month
	 * @param hrs the hours
	 * @param min the minutes
	 * @param sec the seconds
	 * 
	 * @see GregorianCalendar#GregorianCalendar(int, int, int, int, int, int)
	 */
	public DateFileFilter( int year, int month, int dayOfMonth, int hrs, int min, int sec ) {
		this( new GregorianCalendar(year, month, dayOfMonth, hrs, min, sec).getTime() );
	}
	
	/**
	 * Creates an instance that accepts {@link File}s that were modified after <code>d</code>.
	 * 
	 * @param d the date used to decide whether a {@link File} will be accepted or not
	 */
	public DateFileFilter( Date d ) {
		time = d.getTime();
		desc = d.toString() + " (" + time +")";
	}
	
	public boolean accept(File f) {
		return f.isDirectory() || f.lastModified() >= time;
	}

	public String toString() {
		return desc;
	}
}

