/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.scoringFunctionBased.logPrior;

import de.jstacs.NonParsableException;
import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.classifier.scoringFunctionBased.logPrior.SeparateLogPrior;

public class SeparateGaussianLogPrior
extends SeparateLogPrior {
    private double[] vars2;
    private double[] mus;

    public SeparateGaussianLogPrior(double[] vars, double[] classVars, double[] classMus) {
        super(vars, classVars, classMus);
    }

    public SeparateGaussianLogPrior(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public void unset() {
        this.vars2 = null;
        this.mus = null;
    }

    private void computeVars() {
        int i;
        int num = this.funs.length - (this.freeParameters ? 1 : 0);
        for (i = 0; i < this.funs.length; ++i) {
            num += this.funs[i].getNumberOfParameters();
        }
        this.vars2 = new double[num];
        this.mus = new double[num];
        for (num = 0; num < this.funs.length - (this.freeParameters ? 1 : 0); ++num) {
            this.vars2[num] = this.classVars[num];
            this.mus[num] = this.classMus[num];
        }
        for (i = 0; i < this.funs.length; ++i) {
            for (int j = 0; j < this.funs[i].getNumberOfParameters(); ++j) {
                this.vars2[num] = this.vars[i] * (double)this.funs[i].getSizeOfEventSpaceForRandomVariablesOfParameter(j);
                this.mus[num] = 0.0;
                ++num;
            }
        }
    }

    @Override
    public void addGradientFor(double[] params, double[] grad) {
        if (this.vars2 == null) {
            this.computeVars();
        }
        for (int j = 0; j < params.length; ++j) {
            int n = j;
            grad[n] = grad[n] - (params[j] - this.mus[j]) / this.vars2[j];
        }
    }

    @Override
    public double evaluateFunction(double[] x) throws DimensionException, EvaluationException {
        if (this.vars2 == null) {
            this.computeVars();
        }
        double prior = 0.0;
        for (int i = 0; i < x.length; ++i) {
            prior -= (x[i] - this.mus[i]) * (x[i] - this.mus[i]) / this.vars2[i];
        }
        return prior /= 2.0;
    }

    @Override
    public int getDimensionOfScope() {
        if (this.vars2 == null) {
            return -1;
        }
        return this.vars2.length;
    }

    @Override
    public String getInstanceName() {
        return "Separate Gaussian prior";
    }
}

