/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class ToolBox {
    public static <K> Hashtable<K, Integer> parseHashSet2IndexHashtable(HashSet<K> set) {
        Hashtable<K, Integer> hash = new Hashtable<K, Integer>();
        if (set != null) {
            Iterator<K> it = set.iterator();
            int i = 0;
            while (it.hasNext()) {
                hash.put(it.next(), i);
                ++i;
            }
        }
        return hash;
    }

    public static double max(double[] array) {
        return ToolBox.max(0, array.length, array);
    }

    public static double min(double[] array) {
        return ToolBox.min(0, array.length, array);
    }

    public static double max(int start, int end, double[] array) {
        if (end <= start) {
            throw new IllegalArgumentException();
        }
        double max = array[start];
        ++start;
        while (start < end) {
            if (max < array[start]) {
                max = array[start];
            }
            ++start;
        }
        return max;
    }

    public static double min(int start, int end, double[] array) {
        if (end <= start) {
            throw new IllegalArgumentException();
        }
        double min = array[start];
        ++start;
        while (start < end) {
            if (min > array[start]) {
                min = array[start];
            }
            ++start;
        }
        return min;
    }

    public static final int getMaxIndex(double[] w) {
        return ToolBox.getMaxIndex(0, w.length, w);
    }

    public static final int getMaxIndex(int start, int end, double[] w) {
        int max = start;
        for (int i = 1; i < end; ++i) {
            if (!(w[i] > w[max])) continue;
            max = i;
        }
        return max;
    }

    public static final int[] rank(double[] values, boolean sameRank) {
        int n = values.length;
        double[][] help = new double[n][2];
        for (int i = 0; i < n; ++i) {
            help[i][0] = values[i];
            help[i][1] = i;
        }
        Arrays.sort(help, new DoubleArrayComparator());
        int[] ranks = new int[n];
        int rank = 0;
        for (int i = --n; i >= 0; --i) {
            ranks[(int)Math.round((double)help[i][1])] = rank;
            if (sameRank && (i <= 0 || help[i][0] == help[i - 1][0])) continue;
            ++rank;
        }
        return ranks;
    }

    public static double spearmanCorrelation(double[] v1, double[] v2) throws Exception {
        if (v1.length != v2.length) {
            throw new Exception("Number of values in both vector differ.");
        }
        int[] rankTruth = ToolBox.rank(v2, true);
        int[] rankPred = ToolBox.rank(v1, true);
        double sumTruth = 0.0;
        double sumPred = 0.0;
        double sqTruth = 0.0;
        double sqPred = 0.0;
        double cross = 0.0;
        double n = rankTruth.length;
        for (int i = 0; i < rankTruth.length; ++i) {
            sumTruth += (double)rankTruth[i];
            sumPred += (double)rankPred[i];
            sqTruth += (double)(rankTruth[i] * rankTruth[i]);
            sqPred += (double)(rankPred[i] * rankPred[i]);
            cross += (double)(rankTruth[i] * rankPred[i]);
        }
        return (cross - sumTruth * sumPred / n) / (Math.sqrt(sqTruth - sumTruth * sumTruth / n) * Math.sqrt(sqPred - sumPred * sumPred / n));
    }

    public static double pearsonCorrelation(double[] v1, double[] v2) throws Exception {
        if (v1.length != v2.length) {
            throw new Exception("Number of values in both vector differ.");
        }
        double sumTruth = 0.0;
        double sumPred = 0.0;
        double sqTruth = 0.0;
        double sqPred = 0.0;
        double cross = 0.0;
        double n = v2.length;
        for (int i = 0; i < v2.length; ++i) {
            sumTruth += v2[i];
            sumPred += v1[i];
            sqTruth += v2[i] * v2[i];
            sqPred += v1[i] * v1[i];
            cross += v2[i] * v1[i];
        }
        return (cross - sumTruth * sumPred / n) / (Math.sqrt(sqTruth - sumTruth * sumTruth / n) * Math.sqrt(sqPred - sumPred * sumPred / n));
    }

    private static class DoubleArrayComparator
    implements Comparator<double[]> {
        private DoubleArrayComparator() {
        }

        @Override
        public int compare(double[] o1, double[] o2) {
            return (int)Math.signum(o1[0] - o2[0]);
        }
    }
}

