/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.geodesic;

import de.jtem.numericalMethods.geometry.geodesic.BaryCoords3d;
import de.jtem.numericalMethods.geometry.geodesic.DoubleVectorList;
import de.jtem.numericalMethods.geometry.geodesic.IntList;

public class PolygonOnTriangulation {
    static final double eps = 1.0E-12;
    IntList strip = new IntList();
    DoubleVectorList baryCoords = new DoubleVectorList(3);

    PolygonOnTriangulation() {
    }

    public void removeAll() {
        this.strip.removeAll();
        this.baryCoords.removeAll();
    }

    public void add(int n, double[] dArray) {
        this.strip.add(n);
        this.baryCoords.add(dArray);
    }

    public void assignGeodesic(int n, double[] dArray, double[] dArray2, int[][] nArray, int[][] nArray2, double[][] dArray3) {
        double d = 1.0;
        if (n < 0 || n >= nArray[0].length) {
            throw new IllegalArgumentException("element not in element list of triangulation");
        }
        if (!BaryCoords3d.isPoint(dArray, 1.0E-12) || !BaryCoords3d.isInsideElement(dArray, 1.0E-12)) {
            throw new IllegalArgumentException("no valid barycentric coords");
        }
        if (!BaryCoords3d.isVector(dArray, 1.0E-12)) {
            throw new IllegalArgumentException("no valid barycentric vector");
        }
        this.removeAll();
        double[] dArray4 = (double[])dArray2.clone();
        dArray2 = (double[])dArray2.clone();
        this.add(n, (double[])dArray.clone());
        while (true) {
            int n2;
            double[] dArray5 = this.baryCoords.getNewLast();
            this.strip.add(n);
            double d2 = BaryCoords3d.add(dArray, dArray5, dArray4);
            if (0.999999999999 < d2) break;
            int n3 = BaryCoords3d.getEdge(dArray5);
            if (n3 != -1) {
                n2 = nArray2[n][n3];
                if (n2 == -1) {
                    throw new RuntimeException("hit boundary edge");
                }
            } else {
                n2 = BaryCoords3d.getVertex(dArray);
                if (n2 != -1) {
                    throw new RuntimeException("geodesic hit vertex; this case is not implemented yet");
                }
                throw new RuntimeException("fatal, error in code");
            }
            BaryCoords3d.changeToOtherElementAtEdge(n, n2, n3, dArray2, dArray4, nArray, dArray3[n], dArray3[n2]);
            n = n2;
            dArray = dArray5;
            double[] dArray6 = dArray4;
            dArray4 = dArray2;
            dArray2 = dArray6;
            BaryCoords3d.vecScl(dArray4, dArray4, d *= 1.0 - d2);
        }
    }

    public double[][] getSpaceCurve(int[][] nArray, double[][] dArray) {
        int n = dArray[0].length;
        int n2 = this.strip.size();
        double[][] dArray2 = new double[n2][n];
        for (int i = 0; i < n2; ++i) {
            double[] dArray3 = this.baryCoords.get(i);
            double d = dArray3[0];
            double d2 = dArray3[1];
            double d3 = dArray3[2];
            int[] nArray2 = nArray[this.strip.get(i)];
            double[] dArray4 = dArray[nArray2[0]];
            double[] dArray5 = dArray[nArray2[1]];
            double[] dArray6 = dArray[nArray2[2]];
            double[] dArray7 = dArray2[i];
            for (int j = 0; j < n; ++j) {
                dArray7[j] = d * dArray4[j] + d2 * dArray5[j] + d3 * dArray6[j];
            }
        }
        return dArray2;
    }

    public double[] getSpaceCurve(int[][] nArray, double[] dArray, int n) {
        int n2 = this.strip.size();
        double[] dArray2 = new double[n2 * n];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            double[] dArray3 = this.baryCoords.get(i);
            double d = dArray3[0];
            double d2 = dArray3[1];
            double d3 = dArray3[2];
            int[] nArray2 = nArray[this.strip.get(i)];
            int n4 = nArray2[0] * n;
            int n5 = nArray2[1] * n;
            int n6 = nArray2[2] * n;
            int n7 = 0;
            while (n7 < n) {
                dArray2[n3] = d * dArray[n4 + n7] + d2 * dArray[n5 + n7] + d3 * dArray[n6 + n7];
                ++n7;
                ++n3;
            }
        }
        return dArray2;
    }
}

