/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.phylo.io.nexus;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.seq.io.ParseException;
import org.biojavax.bio.phylo.io.nexus.NexusBlock;
import org.biojavax.bio.phylo.io.nexus.NexusComment;
import org.biojavax.bio.phylo.io.nexus.NexusFileFormat;

public class CharactersBlock
extends NexusBlock.Abstract {
    public static final String CHARACTERS_BLOCK = "CHARACTERS";
    private int dimensionsNTax = 0;
    private int dimensionsNChar = 0;
    private String dataType = "STANDARD";
    private boolean respectCase = false;
    private String missing = "?";
    private String gap;
    private List symbols = new ArrayList();
    private Map equate = new LinkedHashMap();
    private String matchChar;
    private boolean labels = true;
    private boolean transposed = false;
    private boolean interleaved = false;
    private List items = new ArrayList();
    private String statesFormat = "STATESPRESENT";
    private boolean tokens = false;
    private int eliminateStart = 0;
    private int eliminateEnd = 0;
    private List taxLabels = new ArrayList();
    private Map charStateLabels = new LinkedHashMap();
    private List charLabels = new ArrayList();
    private Map stateLabels = new LinkedHashMap();
    private Map matrix = new LinkedHashMap();
    private List comments = new ArrayList();

    public CharactersBlock() {
        this(CHARACTERS_BLOCK);
    }

    protected CharactersBlock(String replacementLabel) {
        super(replacementLabel);
    }

    public void setDimensionsNTax(int dimensionsNTax) {
        this.dimensionsNTax = dimensionsNTax;
    }

    public int getDimensionsNTax() {
        return this.dimensionsNTax;
    }

    public void setDimensionsNChar(int dimensionsNChar) {
        this.dimensionsNChar = dimensionsNChar;
    }

    public int getDimensionsNChar() {
        return this.dimensionsNChar;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setRespectCase(boolean respectCase) {
        this.respectCase = respectCase;
    }

    public boolean isRespectCase() {
        return this.respectCase;
    }

    public void setMissing(String missing) {
        this.missing = missing;
    }

    public String getMissing() {
        return this.missing;
    }

    public void setGap(String gap) {
        this.gap = gap;
    }

    public String getGap() {
        return this.gap;
    }

    public void addSymbol(String symbol) {
        if (!this.symbols.contains(symbol)) {
            this.symbols.add(symbol);
        }
    }

    public void removeSymbol(String symbol) {
        this.symbols.remove(symbol);
    }

    public void removeAllSymbols() {
        this.symbols.clear();
    }

    public List getSymbols() {
        return this.symbols;
    }

    public void addEquate(String symbol, List symbols) {
        this.equate.put(symbol, symbols);
    }

    public void removeEquate(String symbol) {
        this.equate.remove(symbol);
    }

    public Map getEquates() {
        return this.equate;
    }

    public void setMatchChar(String matchChar) {
        this.matchChar = matchChar;
    }

    public String getMatchChar() {
        return this.matchChar;
    }

    public void setLabels(boolean labels) {
        this.labels = labels;
    }

    public boolean isLabels() {
        return this.labels;
    }

    public void setTransposed(boolean transposed) {
        this.transposed = transposed;
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    public void setInterleaved(boolean interleaved) {
        this.interleaved = interleaved;
    }

    public boolean isInterleaved() {
        return this.interleaved;
    }

    public void addItem(String item) {
        if (!this.items.contains(item)) {
            this.items.add(item);
        }
    }

    public void removeItem(String item) {
        this.items.remove(item);
    }

    public void removeAllItems() {
        this.items.clear();
    }

    public List getItems() {
        return this.items;
    }

    public void setStatesFormat(String statesFormat) {
        this.statesFormat = statesFormat;
    }

    public String getStatesFormat() {
        return this.statesFormat;
    }

    public void setTokens(boolean tokens) {
        this.tokens = tokens;
    }

    public boolean isTokens() {
        return this.tokens;
    }

    public void setEliminateStart(int eliminateStart) {
        this.eliminateStart = eliminateStart;
    }

    public int getEliminateStart() {
        return this.eliminateStart;
    }

    public void setEliminateEnd(int eliminateEnd) {
        this.eliminateEnd = eliminateEnd;
    }

    public int getEliminateEnd() {
        return this.eliminateEnd;
    }

    public void addTaxLabel(String taxLabel) throws ParseException {
        if (this.taxLabels.contains(taxLabel)) {
            throw new ParseException("Duplicate taxa label: " + taxLabel);
        }
        try {
            int i = Integer.parseInt(taxLabel);
            if (i <= this.taxLabels.size() + 1) {
                throw new ParseException("Taxa label " + i + " refers to already extant taxa position");
            }
        }
        catch (NumberFormatException e) {
        }
        catch (ParseException e) {
            throw e;
        }
        this.taxLabels.add(taxLabel);
    }

    public void removeTaxLabel(String taxLabel) {
        this.taxLabels.remove(taxLabel);
    }

    public boolean containsTaxLabel(String taxLabel) {
        if (this.taxLabels.contains(taxLabel)) {
            return true;
        }
        try {
            int i = Integer.parseInt(taxLabel);
            if (i <= this.taxLabels.size() + 1) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public List getTaxLabels() {
        return this.taxLabels;
    }

    public void addCharState(String charState) {
        this.charStateLabels.put(charState, new Object[]{null, new ArrayList()});
    }

    public void setCharStateLabel(String charState, String label) {
        if (!this.charStateLabels.containsKey(charState)) {
            this.addCharState(charState);
        }
        ((Object[])this.charStateLabels.get((Object)charState))[0] = label;
    }

    public void addCharStateKeyword(String charState, String keyword) {
        if (!this.charStateLabels.containsKey(charState)) {
            this.addCharState(charState);
        }
        ((List)((Object[])this.charStateLabels.get(charState))[1]).add(keyword);
    }

    public String getCharStateLabel(String charState) {
        return (String)((Object[])this.charStateLabels.get(charState))[0];
    }

    public List getCharStateLabelKeywords(String charState) {
        return (List)((Object[])this.charStateLabels.get(charState))[1];
    }

    public void removeCharState(String charState) {
        this.charStateLabels.remove(charState);
    }

    public Set getAllCharStates() {
        return this.charStateLabels.keySet();
    }

    public void addCharLabel(String charLabel) {
        this.charLabels.add(charLabel);
    }

    public void removeCharLabel(String charLabel) {
        this.charLabels.remove(charLabel);
    }

    public boolean containsCharLabel(String charLabel) {
        return this.charLabels.contains(charLabel);
    }

    public List getCharLabels() {
        return this.charLabels;
    }

    public void addState(String state) {
        this.stateLabels.put(state, new ArrayList());
    }

    public void addStateLabel(String state, String label) {
        if (!this.stateLabels.containsKey(state)) {
            this.addState(state);
        }
        ((List)this.stateLabels.get(state)).add(label);
    }

    public List getStateLabels(String state) {
        return (List)this.stateLabels.get(state);
    }

    public void removeState(String state) {
        this.stateLabels.remove(state);
    }

    public void addMatrixEntry(String taxa) {
        if (!this.matrix.containsKey(taxa)) {
            this.matrix.put(taxa, new ArrayList());
        }
    }

    public void appendMatrixData(String taxa, Object data) {
        ((List)this.matrix.get(taxa)).add(data);
    }

    public List getMatrixData(String taxa) {
        return (List)this.matrix.get(taxa);
    }

    public Collection getMatrixLabels() {
        return Collections.unmodifiableSet(this.matrix.keySet());
    }

    public void addComment(NexusComment comment) {
        this.comments.add(comment);
    }

    public void removeComment(NexusComment comment) {
        this.comments.remove(comment);
    }

    public List getComments() {
        return this.comments;
    }

    protected void writeBlockContents(Writer writer) throws IOException {
        Iterator<Object> i;
        Iterator i2 = this.comments.iterator();
        while (i2.hasNext()) {
            ((NexusComment)i2.next()).writeObject(writer);
            writer.write(NexusFileFormat.NEW_LINE);
        }
        writer.write(" DIMENSIONS ");
        if (!this.taxLabels.isEmpty()) {
            writer.write("NEWTAXA ");
        }
        if (this.dimensionsNTax > 0) {
            writer.write("NTAX=" + this.dimensionsNTax + " ");
        }
        writer.write("NCHAR=" + this.dimensionsNChar + ";" + NexusFileFormat.NEW_LINE);
        writer.write(" FORMAT DATATYPE=");
        this.writeToken(writer, this.dataType);
        if (this.respectCase && "STANDARD".equals(this.dataType)) {
            writer.write(" RESPECTCASE");
        }
        writer.write(" MISSING=");
        this.writeToken(writer, this.missing);
        writer.write(" GAP=");
        this.writeToken(writer, this.gap);
        writer.write(" SYMBOLS=\"");
        if (this.symbols.isEmpty()) {
            this.symbols.add("0");
            this.symbols.add("1");
        }
        Iterator<Object> i3 = this.symbols.iterator();
        while (i3.hasNext()) {
            this.writeToken(writer, (String)i3.next());
        }
        writer.write(34);
        if (!this.equate.isEmpty()) {
            writer.write(" EQUATE=\"");
            i3 = this.equate.entrySet().iterator();
            while (i3.hasNext()) {
                Map.Entry entry = (Map.Entry)i3.next();
                this.writeToken(writer, "" + entry.getKey());
                writer.write("=(");
                Iterator iterator = ((List)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    this.writeToken(writer, "" + iterator.next());
                }
                writer.write(41);
                if (!i3.hasNext()) continue;
                writer.write(32);
            }
            writer.write(34);
        }
        if (this.matchChar != null) {
            writer.write(" MATCHCHAR=");
            this.writeToken(writer, this.matchChar);
        }
        writer.write(this.labels ? " LABELS" : " NOLABELS");
        if (this.transposed) {
            writer.write(" TRANSPOSED");
        }
        writer.write(" ITEMS=");
        if (this.items.isEmpty()) {
            this.items.add("STATES");
        }
        if (this.items.size() > 1) {
            writer.write(40);
        }
        i3 = this.items.iterator();
        while (i3.hasNext()) {
            this.writeToken(writer, "" + i3.next());
            if (!i3.hasNext()) continue;
            writer.write(32);
        }
        if (this.items.size() > 1) {
            writer.write(41);
        }
        writer.write(" STATESFORMAT=");
        this.writeToken(writer, this.statesFormat);
        boolean reallyUseTokens = (this.tokens || "CONTINUOUS".equals(this.dataType)) && !"DNA".equals(this.dataType) && !"RNA".equals(this.dataType) && !"NUCLEOTIDE".equals(this.dataType);
        writer.write(reallyUseTokens ? " TOKENS" : " NOTOKENS");
        writer.write(";" + NexusFileFormat.NEW_LINE);
        if (this.eliminateStart > 0 && this.eliminateEnd > 0) {
            writer.write(" ELIMINATE " + this.eliminateStart + "-" + this.eliminateEnd);
            writer.write(";" + NexusFileFormat.NEW_LINE);
        }
        if (this.taxLabels.size() > 0) {
            writer.write(" TAXLABELS");
            i = this.taxLabels.iterator();
            while (i.hasNext()) {
                writer.write(32);
                this.writeToken(writer, (String)i.next());
            }
            writer.write(";" + NexusFileFormat.NEW_LINE);
        }
        if (!this.charStateLabels.isEmpty() && !"CONTINUOUS".equals(this.dataType)) {
            writer.write(" CHARSTATELABELS" + NexusFileFormat.NEW_LINE);
            i = this.charStateLabels.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                writer.write(9);
                this.writeToken(writer, "" + entry.getKey());
                writer.write(9);
                Object[] parts = (Object[])entry.getValue();
                this.writeToken(writer, "" + parts[0]);
                List names = (List)parts[1];
                if (!names.isEmpty()) {
                    writer.write(47);
                    Iterator k = names.iterator();
                    while (k.hasNext()) {
                        this.writeToken(writer, "" + k.next());
                        if (!k.hasNext()) continue;
                        writer.write(32);
                    }
                }
                if (!i.hasNext()) {
                    writer.write(59);
                } else {
                    writer.write(44);
                }
                writer.write(NexusFileFormat.NEW_LINE);
            }
        }
        if (!this.charLabels.isEmpty() && !this.transposed) {
            writer.write(" CHARLABELS" + NexusFileFormat.NEW_LINE);
            writer.write(9);
            i = this.charLabels.iterator();
            while (i.hasNext()) {
                this.writeToken(writer, "" + i.next());
                if (!i.hasNext()) continue;
                writer.write(32);
            }
            writer.write(";" + NexusFileFormat.NEW_LINE);
        }
        if (!this.stateLabels.isEmpty() && !"CONTINUOUS".equals(this.dataType)) {
            writer.write(" STATELABELS" + NexusFileFormat.NEW_LINE);
            i = this.stateLabels.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = (Map.Entry)i.next();
                writer.write(9);
                this.writeToken(writer, "" + entry.getKey());
                writer.write(9);
                List names = (List)entry.getValue();
                Iterator k = names.iterator();
                while (k.hasNext()) {
                    this.writeToken(writer, "" + k.next());
                    if (!k.hasNext()) continue;
                    writer.write(32);
                }
                if (!i.hasNext()) {
                    writer.write(59);
                } else {
                    writer.write(44);
                }
                writer.write(NexusFileFormat.NEW_LINE);
            }
        }
        writer.write(" MATRIX" + NexusFileFormat.NEW_LINE);
        for (Map.Entry entry : this.matrix.entrySet()) {
            writer.write(9);
            this.writeToken(writer, "" + entry.getKey());
            writer.write(9);
            Iterator j = ((List)entry.getValue()).iterator();
            while (j.hasNext()) {
                this.writeMatrixEntry(writer, j.next(), reallyUseTokens);
                if (!reallyUseTokens || !j.hasNext()) continue;
                writer.write(32);
            }
            writer.write(NexusFileFormat.NEW_LINE);
        }
        writer.write(";" + NexusFileFormat.NEW_LINE);
    }

    private void writeMatrixEntry(Writer writer, Object obj, boolean reallyUseTokens) throws IOException {
        if (obj == null) {
            this.writeToken(writer, this.missing);
        } else if (obj instanceof String) {
            this.writeToken(writer, (String)obj);
        } else if (obj instanceof List) {
            writer.write(40);
            Iterator k = ((List)obj).iterator();
            while (k.hasNext()) {
                this.writeMatrixEntry(writer, k.next(), reallyUseTokens);
                if (!k.hasNext() || !reallyUseTokens) continue;
                writer.write(32);
            }
            writer.write(41);
        } else if (obj instanceof Set) {
            writer.write(123);
            Iterator k = ((Set)obj).iterator();
            while (k.hasNext()) {
                this.writeMatrixEntry(writer, k.next(), reallyUseTokens);
                if (!k.hasNext() || !reallyUseTokens) continue;
                writer.write(32);
            }
            writer.write(125);
        }
    }
}

