/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SymbolTokenization;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleSymbolList;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import org.biojavax.Namespace;
import org.biojavax.RichObjectFactory;
import org.biojavax.SimpleNamespace;
import org.biojavax.bio.seq.RichSequence;
import org.biojavax.bio.seq.io.RichSeqIOListener;
import org.biojavax.bio.seq.io.RichSequenceFormat;

public class FastaFormat
extends RichSequenceFormat.HeaderlessFormat {
    public static final String FASTA_FORMAT = "FASTA";
    protected static final Pattern hp;
    protected static final Pattern dp;
    protected static final Pattern readableFiles;
    protected static final Pattern aminoAcids;

    public boolean canRead(File file) throws IOException {
        if (readableFiles.matcher(file.getName()).matches()) {
            return true;
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        String firstLine = br.readLine();
        boolean readable = firstLine != null && firstLine.startsWith(">");
        br.close();
        return readable;
    }

    public SymbolTokenization guessSymbolTokenization(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        br.readLine();
        boolean aa = aminoAcids.matcher(br.readLine()).matches();
        br.close();
        if (aa) {
            return RichSequence.IOTools.getProteinParser();
        }
        return RichSequence.IOTools.getDNAParser();
    }

    public boolean canRead(BufferedInputStream stream) throws IOException {
        stream.mark(2000);
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        String firstLine = br.readLine();
        boolean readable = firstLine != null && firstLine.startsWith(">");
        stream.reset();
        return readable;
    }

    public SymbolTokenization guessSymbolTokenization(BufferedInputStream stream) throws IOException {
        stream.mark(2000);
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        br.readLine();
        boolean aa = aminoAcids.matcher(br.readLine()).matches();
        stream.reset();
        if (aa) {
            return RichSequence.IOTools.getProteinParser();
        }
        return RichSequence.IOTools.getDNAParser();
    }

    public boolean readSequence(BufferedReader reader, SymbolTokenization symParser, SeqIOListener listener) throws IllegalSymbolException, IOException, ParseException {
        if (!(listener instanceof RichSeqIOListener)) {
            throw new IllegalArgumentException("Only accepting RichSeqIOListeners today");
        }
        return this.readRichSequence(reader, symParser, (RichSeqIOListener)listener, null);
    }

    public boolean readRichSequence(BufferedReader reader, SymbolTokenization symParser, RichSeqIOListener rsiol, Namespace ns) throws IllegalSymbolException, IOException, ParseException {
        String line = reader.readLine();
        if (line == null) {
            throw new IOException("Premature stream end");
        }
        while (line.length() == 0) {
            line = reader.readLine();
            if (line != null) continue;
            throw new IOException("Premature stream end");
        }
        if (!line.startsWith(">")) {
            throw new IOException("Stream does not appear to contain FASTA formatted data: " + line);
        }
        rsiol.startSequence();
        Matcher m = hp.matcher(line);
        if (!m.matches()) {
            throw new IOException("Stream does not appear to contain FASTA formatted data: " + line);
        }
        String name = m.group(1);
        String desc = m.group(3);
        String gi = null;
        m = dp.matcher(name);
        if (m.matches()) {
            gi = m.group(2);
            String namespace = m.group(3);
            String accession = m.group(4);
            String verString = m.group(6);
            int version = verString == null ? 0 : Integer.parseInt(verString);
            name = m.group(7);
            if (name == null) {
                name = accession;
            }
            rsiol.setAccession(accession);
            rsiol.setVersion(version);
            if (gi != null) {
                rsiol.setIdentifier(gi);
            }
            if (ns == null) {
                rsiol.setNamespace((Namespace)RichObjectFactory.getObject(SimpleNamespace.class, new Object[]{namespace}));
            } else {
                rsiol.setNamespace(ns);
            }
        } else {
            rsiol.setAccession(name);
            rsiol.setNamespace(ns == null ? RichObjectFactory.getDefaultNamespace() : ns);
        }
        rsiol.setName(name);
        if (!this.getElideComments()) {
            rsiol.setDescription(desc);
        }
        StringBuffer seq = new StringBuffer();
        boolean hasMoreSeq = true;
        while (hasMoreSeq) {
            reader.mark(500);
            line = reader.readLine();
            if (line != null) {
                if ((line = line.trim()).length() > 0 && line.charAt(0) == '>') {
                    reader.reset();
                    hasMoreSeq = false;
                    continue;
                }
                seq.append(line);
                continue;
            }
            hasMoreSeq = false;
        }
        if (!this.getElideSymbols()) {
            try {
                SimpleSymbolList sl = new SimpleSymbolList(symParser, seq.toString().replaceAll("\\s+", "").replaceAll("[\\.|~]", "-"));
                rsiol.addSymbols(symParser.getAlphabet(), sl.toList().toArray(new Symbol[0]), 0, sl.length());
            }
            catch (Exception e) {
                String message = ParseException.newMessage(this.getClass(), name, gi, "problem parsing symbols", seq.toString());
                throw new ParseException(e, message);
            }
        }
        rsiol.endSequence();
        return line != null;
    }

    public void writeSequence(Sequence seq, PrintStream os) throws IOException {
        if (this.getPrintStream() == null) {
            this.setPrintStream(os);
        }
        this.writeSequence(seq, RichObjectFactory.getDefaultNamespace());
    }

    public void writeSequence(Sequence seq, String format, PrintStream os) throws IOException {
        if (this.getPrintStream() == null) {
            this.setPrintStream(os);
        }
        if (!format.equals(this.getDefaultFormat())) {
            throw new IllegalArgumentException("Unknown format: " + format);
        }
        this.writeSequence(seq, RichObjectFactory.getDefaultNamespace());
    }

    public void writeSequence(Sequence seq, Namespace ns) throws IOException {
        RichSequence rs;
        try {
            rs = seq instanceof RichSequence ? (RichSequence)seq : RichSequence.Tools.enrich(seq);
        }
        catch (ChangeVetoException e) {
            IOException e2 = new IOException("Unable to enrich sequence");
            e2.initCause(e);
            throw e2;
        }
        this.getPrintStream().print(">");
        String identifier = rs.getIdentifier();
        if (identifier != null && !"".equals(identifier)) {
            this.getPrintStream().print("gi|");
            this.getPrintStream().print(identifier);
            this.getPrintStream().print("|");
        }
        this.getPrintStream().print(ns == null ? rs.getNamespace().getName() : ns.getName());
        this.getPrintStream().print("|");
        this.getPrintStream().print(rs.getAccession());
        this.getPrintStream().print(".");
        this.getPrintStream().print(rs.getVersion());
        this.getPrintStream().print("|");
        this.getPrintStream().print(rs.getName());
        this.getPrintStream().print(" ");
        String desc = rs.getDescription();
        if (desc != null && !"".equals(desc)) {
            this.getPrintStream().print(desc.replaceAll("\\n", " "));
        }
        this.getPrintStream().println();
        int length = rs.length();
        for (int pos = 1; pos <= length; pos += this.getLineWidth()) {
            int end = Math.min(pos + this.getLineWidth() - 1, length);
            this.getPrintStream().println(rs.subStr(pos, end));
        }
    }

    public String getDefaultFormat() {
        return FASTA_FORMAT;
    }

    static {
        RichSequence.IOTools.registerFormat(FastaFormat.class);
        hp = Pattern.compile(">\\s*(\\S+)(\\s+(.*))?");
        dp = Pattern.compile("^(gi\\|(\\d+)\\|)?(\\w+)\\|(\\w+?)(\\.(\\d+))?\\|(\\w+)?$");
        readableFiles = Pattern.compile(".*(fa|fas)$");
        aminoAcids = Pattern.compile(".*[FLIPQE].*");
    }
}

