/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.data.Alphabet;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.ArrayParameterSet;
import de.jstacs.parameters.CollectionParameter;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import java.util.Iterator;
import java.util.LinkedList;

public class AlphabetContainerParameterSet
extends InstanceParameterSet {
    private AlphabetContainer.AlphabetContainerType type;
    private boolean simple;

    public AlphabetContainerParameterSet(AlphabetContainer.AlphabetContainerType type, boolean simple) {
        super(AlphabetContainer.class);
        this.type = type;
        this.simple = simple;
    }

    public AlphabetContainerParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public AlphabetContainerParameterSet(Alphabet alph) throws Exception {
        super(AlphabetContainer.class);
        this.type = alph instanceof DiscreteAlphabet ? AlphabetContainer.AlphabetContainerType.DISCRETE : AlphabetContainer.AlphabetContainerType.CONTINUOUS;
        this.simple = true;
        this.loadParameters();
        if (this.type == AlphabetContainer.AlphabetContainerType.CONTINUOUS) {
            ((Parameter)this.parameters.get(0)).setValue(alph.getCurrentParameterSet());
        } else {
            InstanceParameterSet ap = alph.getCurrentParameterSet();
            ((Parameter)this.parameters.get(0)).setValue(ap.getInstanceName());
            ((CollectionParameter)this.parameters.get(0)).getParametersInCollection().getParameterAt(((CollectionParameter)this.parameters.get(0)).getSelected()).setValue(ap);
        }
    }

    public AlphabetContainerParameterSet(Alphabet[] alphabets) throws Exception {
        super(AlphabetContainer.class);
        this.simple = false;
        this.type = AlphabetContainer.AlphabetContainerType.determineType(alphabets);
        this.loadParameters();
        AlphabetArrayParameterSet pars = new AlphabetArrayParameterSet(alphabets, this.type);
        ((Parameter)this.parameters.get(0)).setValue(pars.getInstanceName());
        ((CollectionParameter)this.parameters.get(0)).getParametersInCollection().getParameterAt(((CollectionParameter)this.parameters.get(0)).getSelected()).setValue(pars);
    }

    public AlphabetContainerParameterSet(Alphabet[] alphabets, int[] indexes) throws Exception {
        super(AlphabetContainer.class);
        this.simple = false;
        this.type = AlphabetContainer.AlphabetContainerType.determineType(alphabets);
        this.loadParameters();
        SectionDefinedAlphabetParameterSet pars = new SectionDefinedAlphabetParameterSet(alphabets, indexes);
        ((Parameter)this.parameters.get(0)).setValue(pars.getInstanceName());
        ((CollectionParameter)this.parameters.get(0)).getParametersInCollection().getParameterAt(((CollectionParameter)this.parameters.get(0)).getSelected()).setValue(pars);
    }

    @Override
    public AlphabetContainerParameterSet clone() throws CloneNotSupportedException {
        AlphabetContainerParameterSet clone = (AlphabetContainerParameterSet)super.clone();
        return clone;
    }

    public boolean isDiscrete() {
        return this.type == AlphabetContainer.AlphabetContainerType.DISCRETE;
    }

    public boolean isSimple() {
        return this.simple;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superParameters");
        XMLParser.appendObjectWithTags(buf, (Object)this.type, "type");
        XMLParser.appendObjectWithTags(buf, this.simple, "simple");
        XMLParser.addTags(buf, "alphabetContainerParameterSet");
        return buf;
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "alphabetContainerParameterSet");
        super.fromXML(XMLParser.extractForTag(representation, "superParameters"));
        this.type = XMLParser.extractObjectForTags(representation, "type", AlphabetContainer.AlphabetContainerType.class);
        this.simple = XMLParser.extractObjectForTags(representation, "simple", Boolean.TYPE);
    }

    public int getPossibleLength() {
        Object o = ((Parameter)this.parameters.get(0)).getValue();
        if (o instanceof DNAAlphabet.DNAAlphabetParameterSet || o instanceof DiscreteAlphabet.DiscreteAlphabetParameterSet || o instanceof ContinuousAlphabet.ContinuousAlphabetParameterSet) {
            return 0;
        }
        ParameterSet set = (ParameterSet)o;
        return (Integer)set.getParameterAt(0).getValue();
    }

    @Override
    protected void loadParameters() throws Exception {
        this.initParameterList();
        if (this.simple) {
            if (this.type == AlphabetContainer.AlphabetContainerType.DISCRETE) {
                DNAAlphabet.DNAAlphabetParameterSet simpleDNA = new DNAAlphabet.DNAAlphabetParameterSet();
                DiscreteAlphabet.DiscreteAlphabetParameterSet simpleDisc = new DiscreteAlphabet.DiscreteAlphabetParameterSet();
                this.parameters.add(new CollectionParameter(new InstanceParameterSet[]{simpleDNA, simpleDisc}, "Alphabet", "Select a discrete alphabet", true));
            } else if (this.type == AlphabetContainer.AlphabetContainerType.CONTINUOUS) {
                ContinuousAlphabet.ContinuousAlphabetParameterSet simpleCont = new ContinuousAlphabet.ContinuousAlphabetParameterSet();
                this.parameters.add(new ParameterSetContainer("Alphabet", "Set the continuous alphabet", simpleCont));
            } else {
                DNAAlphabet.DNAAlphabetParameterSet simpleDNA = new DNAAlphabet.DNAAlphabetParameterSet();
                DiscreteAlphabet.DiscreteAlphabetParameterSet simpleDisc = new DiscreteAlphabet.DiscreteAlphabetParameterSet();
                ContinuousAlphabet.ContinuousAlphabetParameterSet simpleCont = new ContinuousAlphabet.ContinuousAlphabetParameterSet();
                this.parameters.add(new CollectionParameter(new InstanceParameterSet[]{simpleDNA, simpleDisc, simpleCont}, "Alphabet", "Select an alphabet", true));
            }
        } else {
            AlphabetArrayParameterSet arrayParameters = new AlphabetArrayParameterSet(this.type);
            SectionDefinedAlphabetParameterSet sectionParameters = new SectionDefinedAlphabetParameterSet(this.type);
            if (this.type == AlphabetContainer.AlphabetContainerType.DISCRETE) {
                DNAAlphabet.DNAAlphabetParameterSet simpleDNA = new DNAAlphabet.DNAAlphabetParameterSet();
                DiscreteAlphabet.DiscreteAlphabetParameterSet simpleDisc = new DiscreteAlphabet.DiscreteAlphabetParameterSet();
                ParameterSet[] ar = new ParameterSet[]{simpleDNA, simpleDisc, arrayParameters, sectionParameters};
                this.parameters.add(new CollectionParameter(ar, new String[]{((InstanceParameterSet)simpleDNA).getInstanceName(), ((InstanceParameterSet)simpleDisc).getInstanceName(), arrayParameters.getInstanceName(), sectionParameters.getInstanceName()}, new String[]{((InstanceParameterSet)simpleDNA).getInstanceComment(), ((InstanceParameterSet)simpleDisc).getInstanceComment(), arrayParameters.getInstanceComment(), sectionParameters.getInstanceComment()}, "Alphabet", "Select a discrete alphabet", true));
            } else if (this.type == AlphabetContainer.AlphabetContainerType.CONTINUOUS) {
                ContinuousAlphabet.ContinuousAlphabetParameterSet simpleCont = new ContinuousAlphabet.ContinuousAlphabetParameterSet();
                ParameterSet[] ar = new ParameterSet[]{simpleCont, arrayParameters, sectionParameters};
                this.parameters.add(new CollectionParameter(ar, new String[]{((InstanceParameterSet)simpleCont).getInstanceName(), arrayParameters.getInstanceName(), sectionParameters.getInstanceName()}, new String[]{((InstanceParameterSet)simpleCont).getInstanceComment(), arrayParameters.getInstanceComment(), sectionParameters.getInstanceComment()}, "Alphabet", "Select a continuous alphabet", true));
            } else {
                DNAAlphabet.DNAAlphabetParameterSet simpleDNA = new DNAAlphabet.DNAAlphabetParameterSet();
                DiscreteAlphabet.DiscreteAlphabetParameterSet simpleDisc = new DiscreteAlphabet.DiscreteAlphabetParameterSet();
                ContinuousAlphabet.ContinuousAlphabetParameterSet simpleCont = new ContinuousAlphabet.ContinuousAlphabetParameterSet();
                ParameterSet[] ar = new ParameterSet[]{simpleDNA, simpleDisc, simpleCont, arrayParameters, sectionParameters};
                this.parameters.add(new CollectionParameter(ar, new String[]{((InstanceParameterSet)simpleDNA).getInstanceName(), ((InstanceParameterSet)simpleDisc).getInstanceName(), ((InstanceParameterSet)simpleCont).getInstanceName(), arrayParameters.getInstanceName(), sectionParameters.getInstanceName()}, new String[]{((InstanceParameterSet)simpleDNA).getInstanceComment(), ((InstanceParameterSet)simpleDisc).getInstanceComment(), ((InstanceParameterSet)simpleCont).getInstanceName(), arrayParameters.getInstanceComment(), sectionParameters.getInstanceComment()}, "Alphabet", "Select an alphabet", true));
            }
        }
    }

    @Override
    public String getInstanceName() {
        return "Alphabet";
    }

    @Override
    public String getInstanceComment() {
        return "Set an alphabet for your model or data.";
    }

    public static class AlphabetArrayParameterSet
    extends ArrayParameterSet {
        private AlphabetContainer.AlphabetContainerType type;

        public AlphabetArrayParameterSet(AlphabetContainer.AlphabetContainerType type) throws Exception {
            super(type == AlphabetContainer.AlphabetContainerType.CONTINUOUS ? new ContinuousAlphabet.ContinuousAlphabetParameterSet() : (type == AlphabetContainer.AlphabetContainerType.DISCRETE ? new SimpleParameterSet(new CollectionParameter(new InstanceParameterSet[]{new DNAAlphabet.DNAAlphabetParameterSet(), new DiscreteAlphabet.DiscreteAlphabetParameterSet()}, "Type of alphabet", "Select the type of the alphabet", true)) : new SimpleParameterSet(new CollectionParameter(new InstanceParameterSet[]{new DNAAlphabet.DNAAlphabetParameterSet(), new DiscreteAlphabet.DiscreteAlphabetParameterSet(), new ContinuousAlphabet.ContinuousAlphabetParameterSet()}, "Type of alphabet", "Select the type of the alphabet", true))), "Alphabet", "Set the alphabet");
        }

        public AlphabetArrayParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        public AlphabetArrayParameterSet(Alphabet[] alphabets, AlphabetContainer.AlphabetContainerType type) throws Exception {
            this(type);
            this.loadParameters();
            ((Parameter)this.parameters.get(0)).setValue(alphabets.length);
            this.loadParameters();
            for (int i = 0; i < alphabets.length; ++i) {
                if (type == AlphabetContainer.AlphabetContainerType.CONTINUOUS) {
                    ((Parameter)this.parameters.get(i + 1)).setValue(alphabets[i].getCurrentParameterSet());
                    continue;
                }
                InstanceParameterSet ap = alphabets[i].getCurrentParameterSet();
                ((ParameterSet)((Parameter)this.parameters.get(i + 1)).getValue()).getParameterAt(0).setValue(ap.getInstanceName());
                ((CollectionParameter)((ParameterSet)((Parameter)this.parameters.get(i + 1)).getValue()).getParameterAt(0)).getParametersInCollection().getParameterAt(((CollectionParameter)((ParameterSet)((Parameter)this.parameters.get(i + 1)).getValue()).getParameterAt(0)).getSelected()).setValue(ap);
            }
        }

        @Override
        public AlphabetArrayParameterSet clone() throws CloneNotSupportedException {
            try {
                AlphabetArrayParameterSet clone = (AlphabetArrayParameterSet)super.clone();
                return clone;
            }
            catch (Exception e) {
                throw new CloneNotSupportedException(e.getCause().getMessage());
            }
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer buf = super.toXML();
            XMLParser.addTags(buf, "superParameters");
            XMLParser.appendObjectWithTags(buf, (Object)this.type, "type");
            XMLParser.addTags(buf, "alphabetArrayParameterSet");
            return buf;
        }

        @Override
        public void fromXML(StringBuffer representation) throws NonParsableException {
            representation = XMLParser.extractForTag(representation, "alphabetArrayParameterSet");
            super.fromXML(XMLParser.extractForTag(representation, "superParameters"));
            this.type = XMLParser.extractObjectForTags(representation, "type", AlphabetContainer.AlphabetContainerType.class);
        }

        public String getInstanceName() {
            return "Alphabet-array";
        }

        public String getInstanceComment() {
            return "An array of alphabets where each position can have its own alphabet.";
        }
    }

    public static class SectionDefinedAlphabetParameterSet
    extends ExpandableParameterSet {
        private AlphabetContainer.AlphabetContainerType type;

        public SectionDefinedAlphabetParameterSet(AlphabetContainer.AlphabetContainerType type) throws Exception {
            super(new SimpleParameterSet(type == AlphabetContainer.AlphabetContainerType.DISCRETE ? new CollectionParameter(new InstanceParameterSet[]{new DNAAlphabet.DNAAlphabetParameterSet(), new DiscreteAlphabet.DiscreteAlphabetParameterSet()}, "Alphabet", "Set the parameters of the alphabet.", true) : (type == AlphabetContainer.AlphabetContainerType.CONTINUOUS ? new ParameterSetContainer("Alphabet", "Set the parameters of the alphabet.", new ContinuousAlphabet.ContinuousAlphabetParameterSet()) : new CollectionParameter(new InstanceParameterSet[]{new DNAAlphabet.DNAAlphabetParameterSet(), new DiscreteAlphabet.DiscreteAlphabetParameterSet(), new ContinuousAlphabet.ContinuousAlphabetParameterSet()}, "Type of alphabet", "Select the type of the alphabet", true)), new SimpleParameter(DataType.STRING, "Section", "The section for that this alphabet is applied. Use &quot;,&quot; to separate different positions and &quot;-&quot; to indicate ranges, e.g. 1-3,5.", true)), "Alphabet", "Set the alphabet");
            this.template.getParameterAt(1).setNeededReference(this);
            this.type = type;
        }

        public SectionDefinedAlphabetParameterSet(Alphabet[] alphabets, int[] indexes) throws Exception {
            this(AlphabetContainer.AlphabetContainerType.determineType(alphabets));
            int i;
            this.loadParameters();
            ((Parameter)this.parameters.get(0)).setValue(indexes.length);
            for (i = 0; i < alphabets.length; ++i) {
                this.addParameterToSet();
            }
            for (i = 0; i < alphabets.length; ++i) {
                ParameterSet temp = (ParameterSet)((Parameter)this.parameters.get(i + 1)).getValue();
                if (this.type == AlphabetContainer.AlphabetContainerType.CONTINUOUS) {
                    temp.getParameterAt(0).setValue(alphabets[i].getCurrentParameterSet());
                } else {
                    InstanceParameterSet ap = alphabets[i].getCurrentParameterSet();
                    temp.getParameterAt(0).setValue(ap.getInstanceName());
                    ((CollectionParameter)temp.getParameterAt(0)).getParametersInCollection().getParameterAt(((CollectionParameter)temp.getParameterAt(0)).getSelected()).setValue(ap);
                }
                StringBuffer sections = new StringBuffer();
                for (int j = 0; j < indexes.length; ++j) {
                    if (indexes[j] != i) continue;
                    sections.append(j + 1 + ", ");
                }
                sections.delete(sections.length() - 2, sections.length());
                temp.getParameterAt(1).setValue(sections.toString());
            }
        }

        public SectionDefinedAlphabetParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        @Override
        protected void loadParameters() throws Exception {
            this.initParameterList();
            SimpleParameter length = new SimpleParameter(DataType.INT, "Length", "The length of the array.", true);
            length.setRangeable(false);
            length.setNeededReference(this);
            this.parameters.add(length);
            super.loadParameters();
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer buf = super.toXML();
            XMLParser.addTags(buf, "superParameters");
            XMLParser.appendObjectWithTags(buf, (Object)this.type, "type");
            XMLParser.addTags(buf, "sectionDefinedAlphabetParameterSet");
            return buf;
        }

        @Override
        public void fromXML(StringBuffer representation) throws NonParsableException {
            representation = XMLParser.extractForTag(representation, "sectionDefinedAlphabetParameterSet");
            super.fromXML(XMLParser.extractForTag(representation, "superParameters"));
            if (this.parameters != null) {
                ((Parameter)this.parameters.get(0)).setNeededReference(this);
                for (int i = 1; i < this.parameters.size(); ++i) {
                    ((ParameterSetContainer)this.parameters.get(i)).getValue().getParameterAt(1).setNeededReference(this);
                }
            }
            this.type = XMLParser.extractObjectForTags(representation, "type", AlphabetContainer.AlphabetContainerType.class);
        }

        @Override
        public boolean hasDefaultOrIsSet() {
            if (!super.hasDefaultOrIsSet()) {
                return false;
            }
            Iterator it = this.parameters.iterator();
            boolean[] set = new boolean[((Integer)((Parameter)it.next()).getValue()).intValue()];
            int no = 0;
            while (it.hasNext()) {
                ++no;
                ParameterSet temp = (ParameterSet)((Parameter)it.next()).getValue();
                String section = (String)temp.getParameterAt(1).getValue();
                try {
                    LinkedList<Integer> tempList = SectionDefinedAlphabetParameterSet.parseSections(section);
                    Iterator posIt = tempList.iterator();
                    while (posIt.hasNext()) {
                        int curr = (Integer)posIt.next();
                        if (curr >= set.length) {
                            this.errorMessage = "Position " + (curr + 1) + " out of range defined by length.";
                            return false;
                        }
                        if (set[curr]) {
                            this.errorMessage = "Alphabet for position " + (curr + 1) + " defined at least twice.";
                            return false;
                        }
                        set[curr] = true;
                    }
                }
                catch (Exception e) {
                    this.errorMessage = "Malformed section definition no. " + no;
                    e.printStackTrace();
                    return false;
                }
            }
            for (int i = 0; i < set.length; ++i) {
                if (set[i]) continue;
                this.errorMessage = "No alphabet defined for position " + (i + 1) + ".";
                return false;
            }
            this.errorMessage = null;
            return true;
        }

        public static LinkedList<Integer> parseSections(String sections) throws Exception {
            String[] secs = sections.split("(\\s*,\\s*)");
            LinkedList<Integer> list = new LinkedList<Integer>();
            for (int i = 0; i < secs.length; ++i) {
                String[] temp = secs[i].split("(\\s*-\\s*)");
                if (temp.length == 2) {
                    int end;
                    int start = Integer.parseInt(temp[0]) - 1;
                    start = start <= (end = Integer.parseInt(temp[1]) - 1) ? start : end;
                    int n = end = end >= start ? end : start;
                    if (start < 0) {
                        throw new Exception("Malformed sections, no negative values allowed.");
                    }
                    for (int j = start; j <= end; ++j) {
                        list.add(j);
                    }
                    continue;
                }
                if (temp.length == 1) {
                    int pos = Integer.parseInt(temp[0]) - 1;
                    if (pos < 0) {
                        throw new Exception("Malformed sections, no negative values allowed.");
                    }
                    list.add(pos);
                    continue;
                }
                throw new Exception("Malformed sections.");
            }
            return list;
        }

        @Override
        public SectionDefinedAlphabetParameterSet clone() throws CloneNotSupportedException {
            try {
                SectionDefinedAlphabetParameterSet clone = (SectionDefinedAlphabetParameterSet)super.clone();
                if (clone.parameters != null) {
                    ((Parameter)clone.parameters.get(0)).setNeededReference(clone);
                    for (int i = 1; i < clone.parameters.size(); ++i) {
                        ((ParameterSetContainer)clone.parameters.get(i)).getValue().getParameterAt(1).setNeededReference(clone);
                    }
                }
                return clone;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new CloneNotSupportedException(e.getCause().getMessage());
            }
        }

        public String getInstanceName() {
            return "Alphabets defined by section";
        }

        public String getInstanceComment() {
            return "Set the alphabets for all positions.";
        }
    }
}

