/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.WrongAlphabetException;
import de.jstacs.data.Alphabet;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sequence;
import de.jstacs.data.alphabets.DiscreteAlphabetMapping;
import de.jstacs.data.sequences.SimpleDiscreteSequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;

public class MappedDiscreteSequence
extends SimpleDiscreteSequence {
    protected SimpleDiscreteSequence original;
    protected AlphabetContainer originalAlphabetContainer;
    protected DiscreteAlphabetMapping[] transformation;

    public static final AlphabetContainer getNewAlphabetContainer(AlphabetContainer original, DiscreteAlphabetMapping ... transformation) {
        int[] index = original.getIndexForAlphabets();
        if (index == null && transformation.length != 1 || index != null && index.length != transformation.length) {
            throw new IllegalArgumentException("Check number of transformations.");
        }
        Alphabet[] abc = new Alphabet[transformation.length];
        for (int i = 0; i < abc.length; ++i) {
            abc[i] = transformation[i].getNewAlphabet();
        }
        return new AlphabetContainer(abc, index);
    }

    protected MappedDiscreteSequence(AlphabetContainer originalAlphabetContainer, SequenceAnnotation[] seqAn, DiscreteAlphabetMapping ... transformation) throws WrongAlphabetException {
        super(MappedDiscreteSequence.getNewAlphabetContainer(originalAlphabetContainer, transformation), seqAn);
        this.originalAlphabetContainer = originalAlphabetContainer;
        this.transformation = (DiscreteAlphabetMapping[])transformation.clone();
    }

    public MappedDiscreteSequence(SimpleDiscreteSequence original, DiscreteAlphabetMapping ... transformation) throws WrongAlphabetException {
        this(original.getAlphabetContainer(), original.getAnnotation(), transformation);
        this.original = original;
    }

    @Override
    public int discreteVal(int pos) {
        return this.transformation[this.originalAlphabetContainer.getAlphabetIndexForPosition(pos)].getNewDiscreteValue(this.original.discreteVal(pos));
    }

    @Override
    protected Sequence flatCloneWithoutAnnotation() {
        return null;
    }

    @Override
    public int getLength() {
        return this.original.getLength();
    }

    public double getLogNumberOfPossibleOriginalSequences() {
        return this.getLogNumberOfPossibleOriginalSequences(0, this.getLength());
    }

    public double getLogNumberOfPossibleOriginalSequences(int start, int end) {
        double res = 0.0;
        while (start < end) {
            res += this.transformation[this.originalAlphabetContainer.getAlphabetIndexForPosition(start)].getLogNumberOfSimilarSymbols(this.original.discreteVal(start));
            ++start;
        }
        return res;
    }

    @Override
    public final int[] getEmptyContainer() {
        return new int[1];
    }

    @Override
    public final void fillContainer(int[] container, int pos) {
        container[0] = this.discreteVal(pos);
    }
}

