/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.SimpleDiscreteSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.SymbolExtractor;

public class ShortSequence
extends SimpleDiscreteSequence {
    private short[] content;

    public ShortSequence(AlphabetContainer alphabetContainer, short[] content) throws WrongAlphabetException, WrongSequenceTypeException {
        super(alphabetContainer, null);
        if (alphabetContainer.getMaximalAlphabetLength() > 32767.0) {
            throw new WrongSequenceTypeException();
        }
        this.content = new short[content.length];
        for (int i = 0; i < content.length; ++i) {
            if (!alphabetContainer.isEncodedSymbol(i, content[i])) {
                throw new WrongAlphabetException();
            }
            this.content[i] = content[i];
        }
    }

    private ShortSequence(AlphabetContainer cont, SequenceAnnotation[] annotation, short[] content) throws WrongAlphabetException {
        super(cont, annotation);
        this.content = content;
    }

    public ShortSequence(AlphabetContainer alphabetContainer, String sequence) throws WrongAlphabetException, WrongSequenceTypeException {
        this(alphabetContainer, null, sequence, alphabetContainer.getDelim());
    }

    public ShortSequence(AlphabetContainer alphabetContainer, SequenceAnnotation[] annotation, String sequence, String delim) throws WrongAlphabetException, WrongSequenceTypeException {
        this(alphabetContainer, annotation, new SymbolExtractor(sequence, delim));
    }

    public ShortSequence(AlphabetContainer alphabetContainer, SequenceAnnotation[] annotation, SymbolExtractor extractor) throws WrongAlphabetException, WrongSequenceTypeException {
        super(alphabetContainer, annotation);
        if (alphabetContainer.getMaximalAlphabetLength() > 32767.0) {
            throw new WrongSequenceTypeException();
        }
        this.content = new short[extractor.countElements()];
        for (int k = 0; k < this.content.length; ++k) {
            this.content[k] = (short)alphabetContainer.getCode(k, extractor.nextElement());
        }
    }

    @Override
    public int discreteVal(int pos) {
        return this.content[pos];
    }

    @Override
    public int getLength() {
        return this.content.length;
    }

    @Override
    protected ShortSequence flatCloneWithoutAnnotation() {
        try {
            return new ShortSequence(this.alphabetCon, null, this.content);
        }
        catch (Exception doesnothappen) {
            throw new RuntimeException(doesnothappen);
        }
    }
}

