/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences.annotation;

import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.ListResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import java.util.Collection;
import java.util.LinkedList;

public class SequenceAnnotation
extends ResultSet {
    private String type;
    private String identifier;

    public SequenceAnnotation(String type, String identifier, Result result) {
        super(result);
        this.type = type;
        this.identifier = identifier;
    }

    public SequenceAnnotation(String type, String identifier, Result[] ... results) {
        super(results);
        this.type = type;
        this.identifier = identifier;
    }

    public SequenceAnnotation(String type, String identifier, SequenceAnnotation[] subAnnotations, Result ... additionalAnnotation) {
        super(new Result[][]{SequenceAnnotation.fuse(additionalAnnotation, subAnnotations)});
        this.type = type;
        this.identifier = identifier;
    }

    public SequenceAnnotation(String type, String identifier, Collection<? extends Result> results) {
        super(results);
        this.type = type;
        this.identifier = identifier;
    }

    public SequenceAnnotation(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public String getType() {
        return this.type;
    }

    public Result[] getAnnotations() {
        if (this.results.length > 0) {
            LinkedList<Result> list = new LinkedList<Result>();
            for (int i = 0; i < this.results.length; ++i) {
                boolean add = true;
                if (this.results[i] instanceof ListResult) {
                    ListResult lr = (ListResult)this.results[i];
                    ResultSet[] rs = lr.getRawResult();
                    for (int j = 0; j < rs.length; ++j) {
                        if (!(rs[j] instanceof SequenceAnnotation)) continue;
                        add = false;
                    }
                }
                if (!add) continue;
                list.add(this.results[i]);
            }
            if (list.size() > 0) {
                return list.toArray(new Result[0]);
            }
            return null;
        }
        return null;
    }

    public SequenceAnnotation[] getSubAnnotations() {
        if (this.results.length > 0 && this.results[this.results.length - 1] instanceof ListResult) {
            ListResult lr = (ListResult)this.results[this.results.length - 1];
            ResultSet[] rs = lr.getRawResult();
            int num = 0;
            for (int i = 0; i < rs.length; ++i) {
                if (!(rs[i] instanceof SequenceAnnotation)) continue;
                ++num;
            }
            if (num == 0) {
                return null;
            }
            SequenceAnnotation[] annot = new SequenceAnnotation[num];
            num = 0;
            for (int i = 0; i < rs.length; ++i) {
                if (!(rs[i] instanceof SequenceAnnotation)) continue;
                annot[num] = (SequenceAnnotation)rs[i];
                ++num;
            }
            return annot;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.type);
        buf.append(", ");
        buf.append(this.identifier);
        buf.append(":\n");
        for (int i = 0; i < this.results.length; ++i) {
            if (this.results[i] instanceof ListResult) {
                ResultSet[] ress = (ResultSet[])this.results[i].getResult();
                for (int j = 0; j < ress.length; ++j) {
                    buf.append(ress[j].toString());
                    buf.append("\n");
                }
                continue;
            }
            buf.append(this.results[i].toString());
            buf.append("\n");
        }
        return buf.toString();
    }

    @Override
    protected void fromXML(StringBuffer source) throws NonParsableException {
        source = XMLParser.extractForTag(source, "sequenceAnnotation");
        super.fromXML(XMLParser.extractForTag(source, "results"));
        this.type = XMLParser.extractObjectForTags(source, "type", String.class);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "results");
        XMLParser.appendObjectWithTags(buf, this.type, "type");
        XMLParser.addTags(buf, "sequenceAnnotation");
        return buf;
    }

    private static Result[] fuse(Result[] res, SequenceAnnotation[] res2) {
        if (res2 == null || res2.length == 0) {
            return res;
        }
        Result[] ress = new Result[res.length + 1];
        for (int i = 0; i < res.length; ++i) {
            ress[i] = res[i];
        }
        ress[ress.length - 1] = new ListResult("Sub-annotation", "The list of sub-annotations", null, res2);
        return ress;
    }

    public String getIdentifier() {
        return this.identifier;
    }
}

