/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models;

import de.jstacs.NonParsableException;
import de.jstacs.NotTrainedException;
import de.jstacs.Storable;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.models.Model;
import de.jstacs.results.ResultSet;
import de.jstacs.results.StorableResult;

public abstract class AbstractModel
implements Cloneable,
Storable,
Model {
    protected int length;
    protected AlphabetContainer alphabets;

    public AbstractModel(AlphabetContainer alphabets, int length) {
        this.length = length;
        this.alphabets = alphabets;
        if (alphabets.getPossibleLength() > 0 && alphabets.getPossibleLength() != length) {
            throw new IllegalArgumentException("The length and the alphabet container does not match.");
        }
    }

    public AbstractModel(StringBuffer stringBuff) throws NonParsableException {
        this.alphabets = null;
        this.length = -1;
        this.fromXML(stringBuff);
        if (this.alphabets == null) {
            throw new NonParsableException("The alphabets were not set correctly.");
        }
        if (this.length < 0) {
            throw new NonParsableException("The length was not set correctly.");
        }
        if (this.alphabets.getPossibleLength() > 0 && this.alphabets.getPossibleLength() != this.length) {
            throw new IllegalArgumentException("The length and the alphabet container doesnot not match.");
        }
    }

    @Override
    public AbstractModel clone() throws CloneNotSupportedException {
        return (AbstractModel)super.clone();
    }

    @Override
    public void train(Sample data) throws Exception {
        this.train(data, null);
    }

    @Override
    public double getProbFor(Sequence sequence) throws NotTrainedException, Exception {
        return this.getProbFor(sequence, 0, sequence.getLength() - 1);
    }

    @Override
    public double getProbFor(Sequence sequence, int startpos) throws NotTrainedException, Exception {
        if (this.length == 0) {
            return this.getProbFor(sequence, startpos, sequence.getLength() - 1);
        }
        return this.getProbFor(sequence, startpos, startpos + this.length - 1);
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos, int endpos) throws Exception {
        return StrictMath.log(this.getProbFor(sequence, startpos, endpos));
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos) throws Exception {
        if (this.length == 0) {
            return this.getLogProbFor(sequence, startpos, sequence.getLength() - 1);
        }
        return this.getLogProbFor(sequence, startpos, startpos + this.length - 1);
    }

    @Override
    public double getLogProbFor(Sequence sequence) throws Exception {
        return this.getLogProbFor(sequence, 0, sequence.getLength() - 1);
    }

    @Override
    public double[] getLogProbFor(Sample data) throws Exception {
        double[] res = new double[data.getNumberOfElements()];
        this.getLogProbFor(data, res);
        return res;
    }

    @Override
    public void getLogProbFor(Sample data, double[] res) throws Exception {
        if (res.length != data.getNumberOfElements()) {
            throw new IllegalArgumentException("The array has wrong dimension.");
        }
        Sample.ElementEnumerator ei = new Sample.ElementEnumerator(data);
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.getLogProbFor(ei.nextElement());
        }
    }

    @Override
    public double getPriorTerm() throws Exception {
        return Math.exp(this.getLogPriorTerm());
    }

    @Override
    public Sample emitSample(int numberOfSequences, int ... seqLength) throws NotTrainedException, Exception {
        throw new Exception("Standard implementation of emitSample used for " + this.getInstanceName() + ". You have to overwrite this method to use it in a proper way.");
    }

    @Override
    public final AlphabetContainer getAlphabetContainer() {
        return this.alphabets;
    }

    @Override
    public final int getLength() {
        return this.length;
    }

    @Override
    public byte getMaximalMarkovOrder() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The maximal markov order for this model in undefined.");
    }

    @Override
    public ResultSet getCharacteristics() throws Exception {
        return new ResultSet(this.getNumericalCharacteristics().getResults(), {new StorableResult("model", "the xml representation of the model", this)});
    }

    protected abstract void fromXML(StringBuffer var1) throws NonParsableException;

    @Override
    public final boolean setNewAlphabetContainerInstance(AlphabetContainer abc) {
        if (abc.checkConsistency(this.alphabets)) {
            this.set(abc);
            this.alphabets = abc;
            return true;
        }
        return false;
    }

    protected void set(AlphabetContainer abc) {
    }
}

