/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models;

import de.jstacs.NonParsableException;
import de.jstacs.NotTrainedException;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.io.XMLParser;
import de.jstacs.models.AbstractModel;
import de.jstacs.models.Model;
import de.jstacs.results.NumericalResultSet;

public class VariableLengthWrapperModel
extends AbstractModel {
    private Model m;

    public VariableLengthWrapperModel(Model m) throws CloneNotSupportedException {
        super(m.getAlphabetContainer(), m.getLength());
        this.m = m.clone();
    }

    public VariableLengthWrapperModel(StringBuffer stringBuff) throws NonParsableException {
        super(stringBuff);
    }

    @Override
    public VariableLengthWrapperModel clone() throws CloneNotSupportedException {
        VariableLengthWrapperModel clone = (VariableLengthWrapperModel)super.clone();
        clone.m = this.m.clone();
        return clone;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        StringBuffer content = XMLParser.extractForTag(xml, this.getInstanceName());
        this.m = XMLParser.extractObjectForTags(content, "model", Model.class);
        this.alphabets = this.m.getAlphabetContainer();
        this.length = this.m.getLength();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.m, "model");
        XMLParser.addTags(xml, this.getInstanceName());
        return xml;
    }

    @Override
    public String getInstanceName() {
        return this.m.getInstanceName();
    }

    @Override
    public double getLogPriorTerm() throws Exception {
        return this.m.getLogPriorTerm();
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        return this.m.getNumericalCharacteristics();
    }

    @Override
    public double getProbFor(Sequence sequence, int startpos, int endpos) throws NotTrainedException, Exception {
        return this.m.getProbFor(sequence, startpos, endpos);
    }

    @Override
    public boolean isTrained() {
        return this.m.isTrained();
    }

    @Override
    public void train(Sample data, double[] weights) throws Exception {
        Sample.WeightedSampleFactory wsf = new Sample.WeightedSampleFactory(Sample.WeightedSampleFactory.SortOperation.NO_SORT, data, weights, this.length);
        this.m.train(wsf.getSample(), wsf.getWeights());
    }
}

