/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery.history;

import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.history.History;
import java.util.Arrays;

public class SimpleHistory
implements History {
    private int[][] memory;
    private int index;
    private boolean allowShift;
    private boolean allowShrink;
    private boolean allowExpand;

    public SimpleHistory(int slots) {
        this(slots, true, true, true);
    }

    public SimpleHistory(int slots, boolean allowShift, boolean allowShrink, boolean allowExpand) {
        this.memory = new int[slots][];
        this.index = 0;
        this.allowShift = allowShift;
        this.allowShrink = allowShrink;
        this.allowExpand = allowExpand;
    }

    public SimpleHistory(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, this.getXMLTag());
        this.memory = (int[][])XMLParser.extractObjectForTags(xml, "memory");
        this.index = (Integer)XMLParser.extractObjectForTags(xml, "index");
        this.allowExpand = (Boolean)XMLParser.extractObjectForTags(xml, "allowExpand");
        this.allowShift = (Boolean)XMLParser.extractObjectForTags(xml, "allowShift");
        this.allowShrink = (Boolean)XMLParser.extractObjectForTags(xml, "allowShrink");
    }

    private String getXMLTag() {
        return this.getClass().getSimpleName();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.memory, "memory");
        XMLParser.appendObjectWithTags(xml, this.index, "index");
        XMLParser.appendObjectWithTags(xml, this.allowExpand, "allowExpand");
        XMLParser.appendObjectWithTags(xml, this.allowShift, "allowShift");
        XMLParser.appendObjectWithTags(xml, this.allowShrink, "allowShrink");
        XMLParser.addTags(xml, this.getXMLTag());
        return xml;
    }

    @Override
    public boolean operationAllowed(int ... operation) {
        if (operation.length != 2) {
            return false;
        }
        int sum = operation[1] - operation[0];
        if (sum < 0) {
            return this.allowShrink;
        }
        if (!this.allowShift && sum == 0 || !this.allowExpand && sum > 0) {
            return false;
        }
        for (int i = 0; i < this.memory.length; ++i) {
            int j;
            if (this.memory[i] == null || operation.length != this.memory[i].length) continue;
            for (j = 0; j < this.memory[i].length && this.memory[i][j] == -operation[j]; ++j) {
            }
            if (j != this.memory[i].length) continue;
            return false;
        }
        return true;
    }

    @Override
    public void operationPerfomed(int ... operation) {
        if (this.memory.length != 0) {
            this.memory[this.index] = operation;
            ++this.index;
            this.index %= this.memory.length;
        }
    }

    @Override
    public void clear() {
        Arrays.fill((Object[])this.memory, null);
        this.index = 0;
    }

    @Override
    public SimpleHistory clone() throws CloneNotSupportedException {
        SimpleHistory clone = (SimpleHistory)super.clone();
        clone.memory = new int[this.memory.length][];
        for (int i = 0; i < this.memory.length; ++i) {
            if (this.memory[i] == null) continue;
            clone.memory[i] = (int[])this.memory[i].clone();
        }
        return clone;
    }
}

