/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters.validation;

import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.validation.Constraint;
import de.jstacs.parameters.validation.ParameterValidator;
import java.util.Iterator;
import java.util.LinkedList;

public class ConstraintValidator
implements ParameterValidator {
    private LinkedList<Constraint> constraints;
    private String errorMessage;

    public ConstraintValidator() {
        this.constraints = new LinkedList();
    }

    public ConstraintValidator(StringBuffer representation) throws NonParsableException {
        this.fromXML(representation);
    }

    @Override
    public ConstraintValidator clone() throws CloneNotSupportedException {
        ConstraintValidator clone = new ConstraintValidator();
        Iterator constIt = this.constraints.iterator();
        while (constIt.hasNext()) {
            clone.constraints.add(((Constraint)constIt.next()).clone());
        }
        clone.errorMessage = this.errorMessage;
        return clone;
    }

    public void addConstraint(Constraint c) {
        this.constraints.add(c);
    }

    @Override
    public boolean checkValue(Object value) {
        Iterator it = this.constraints.iterator();
        boolean checkPassed = true;
        this.errorMessage = null;
        while (it.hasNext()) {
            if (((Constraint)it.next()).check(value)) continue;
            this.errorMessage = this.errorMessage == null ? ((Constraint)it.next()).getErrorMessage() : this.errorMessage + "; " + ((Constraint)it.next()).getErrorMessage();
            checkPassed = false;
        }
        return checkPassed;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendObjectWithTags(buf, this.errorMessage, "errorMessage");
        XMLParser.appendObjectWithTags(buf, this.constraints.size(), "size");
        Iterator it = this.constraints.iterator();
        StringBuffer buf2 = new StringBuffer();
        while (it.hasNext()) {
            XMLParser.appendObjectWithTags(buf2, it.next(), "constraint");
        }
        XMLParser.addTags(buf2, "constraints");
        buf.append(buf2);
        XMLParser.addTags(buf, "referenceValidator");
        return buf;
    }

    public void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "referenceValidator");
        this.errorMessage = XMLParser.extractObjectForTags(representation, "errorMessage", String.class);
        int size = XMLParser.extractObjectForTags(representation, "size", Integer.TYPE);
        this.constraints = new LinkedList();
        representation = XMLParser.extractForTag(representation, "constraints");
        for (int i = 0; i < size; ++i) {
            this.constraints.add(XMLParser.extractObjectForTags(representation, "constraint", Constraint.class));
        }
    }
}

