/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.ImageResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.StorableResult;
import java.awt.image.BufferedImage;

public abstract class Result
implements Storable {
    protected String name;
    protected String comment;
    protected DataType datatype;

    protected Result(String name, String comment, DataType datatype) {
        this.name = name;
        this.comment = comment;
        this.datatype = datatype;
    }

    protected Result(StringBuffer rep) throws NonParsableException {
        this.fromXML(rep);
    }

    protected abstract void fromXML(StringBuffer var1) throws NonParsableException;

    protected void appendMainInfo(StringBuffer buf) {
        XMLParser.appendObjectWithTags(buf, this.name, "name");
        XMLParser.appendObjectWithTags(buf, this.comment, "comment");
        XMLParser.appendObjectWithTags(buf, (Object)this.datatype, "datatype");
    }

    protected void extractMainInfo(StringBuffer buf) throws NonParsableException {
        this.name = XMLParser.extractObjectForTags(buf, "name", String.class);
        this.comment = XMLParser.extractObjectForTags(buf, "comment", String.class);
        this.datatype = XMLParser.extractObjectForTags(buf, "datatype", DataType.class);
    }

    public final DataType getDatatype() {
        return this.datatype;
    }

    public abstract Object getResult();

    public final String getName() {
        return this.name;
    }

    public final String getComment() {
        return this.comment;
    }

    public boolean isComparableResult(Result test) {
        return this.datatype == test.datatype && this.name.equals(test.name) && this.comment.equals(test.comment);
    }

    public boolean isCastableResult(Result test) {
        return DataType.canBeCastedFromTo(test.datatype, this.datatype) && this.name.equals(test.name) && this.comment.equals(test.comment);
    }

    public static boolean checkDatatype(DataType datatype, Object value) {
        if (value instanceof String) {
            String val = (String)value;
            try {
                switch (datatype) {
                    case DOUBLE: {
                        Double.parseDouble(val);
                        break;
                    }
                    case LONG: {
                        Long.parseLong(val);
                        break;
                    }
                    case INT: {
                        Integer.parseInt(val);
                        break;
                    }
                    case STRING: {
                        break;
                    }
                    case BOOLEAN: {
                        Boolean.parseBoolean(val);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        switch (datatype) {
            case DOUBLE: {
                return value instanceof Double || value instanceof Float;
            }
            case LONG: {
                return value instanceof Long;
            }
            case INT: {
                return value instanceof Integer || value instanceof Byte || value instanceof Short;
            }
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case PNG: {
                return value instanceof BufferedImage;
            }
            case STORABLE: {
                return value instanceof Storable;
            }
        }
        return false;
    }

    public static Result createResult(String name, String comment, DataType datatype, Object value) throws SimpleParameter.IllegalValueException {
        switch (datatype) {
            case DOUBLE: 
            case LONG: 
            case INT: {
                return new NumericalResult(datatype, name, comment, (Comparable)value);
            }
            case STRING: 
            case BOOLEAN: {
                return new CategoricalResult(datatype, name, comment, (Comparable)value);
            }
            case PNG: {
                return new ImageResult(name, comment, (BufferedImage)value);
            }
            case STORABLE: {
                return new StorableResult(name, comment, (Storable)value);
            }
        }
        throw new SimpleParameter.IllegalValueException("wrong datatype");
    }
}

