/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions;

import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.AbstractNormalizableScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;

public class UniformScoringFunction
extends AbstractNormalizableScoringFunction {
    private double ess;
    private double logP;

    public UniformScoringFunction(AlphabetContainer alphabets, int length, double ess) {
        super(alphabets, length);
        if (!alphabets.isDiscrete()) {
            throw new IllegalArgumentException("The given AlphabetContainer has to be discrete.");
        }
        int l = alphabets.getPossibleLength();
        if (l != 0 && l != length) {
            throw new IllegalArgumentException("The given AlphabetContainer (possible length = " + l + ") and length (" + length + ") do not match.");
        }
        if (ess < 0.0) {
            throw new IllegalArgumentException("The given ess has to be non-negative.");
        }
        this.ess = ess;
        this.computeLogP();
    }

    public UniformScoringFunction(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.computeLogP();
    }

    private void computeLogP() {
        this.logP = 1.0;
        for (int i = 0; i < this.length; ++i) {
            this.logP *= this.alphabets.getAlphabetLengthAt(i);
        }
        this.logP = -Math.log(this.logP);
    }

    @Override
    public String getInstanceName() {
        return "uniform";
    }

    @Override
    public double getLogScore(Sequence seq, int start) {
        return this.logP;
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList dList) {
        return this.logP;
    }

    @Override
    public int getNumberOfParameters() {
        return 0;
    }

    @Override
    public void setParameters(double[] params, int start) {
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer b = new StringBuffer(1000);
        XMLParser.appendObjectWithTags(b, this.length, "length");
        XMLParser.appendObjectWithTags(b, this.alphabets, "alphabets");
        XMLParser.appendObjectWithTags(b, this.ess, "ess");
        XMLParser.addTags(b, this.getClass().getSimpleName());
        return b;
    }

    @Override
    public double getLogNormalizationConstant() {
        return 0.0;
    }

    @Override
    public void initializeFunction(int index, boolean meila, Sample[] data, double[][] weights) {
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        StringBuffer b = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.length = XMLParser.extractObjectForTags(b, "length", Integer.TYPE);
        this.alphabets = XMLParser.extractObjectForTags(b, "alphabets", AlphabetContainer.class);
        try {
            this.ess = XMLParser.extractObjectForTags(b, "ess", Double.TYPE);
        }
        catch (NonParsableException n) {
            this.ess = 0.0;
        }
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 0;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        throw new IndexOutOfBoundsException("Since a uniform scoring function has no parameters, this method can not be used");
    }

    @Override
    public double getEss() {
        return this.ess;
    }

    public String toString() {
        StringBuffer info = new StringBuffer(this.length * 100);
        for (int j = 0; j < this.length; ++j) {
            double val = 1.0 / this.alphabets.getAlphabetLengthAt(0);
            info.append(j + "\t" + val + " for each element of " + this.alphabets.getAlphabetAt(j).toString());
            if (j >= this.length - 1) continue;
            info.append("\n");
        }
        return info.toString();
    }

    @Override
    public double getLogPriorTerm() {
        return 0.0;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) {
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        return new double[0];
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public boolean isNormalized() {
        return true;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
    }
}

