/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.btMeasures;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.algorithms.graphs.MST;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.Measure;

public class BTExplainingAwayResidual
extends Measure {
    private BTExplainingAwayResidualParameterSet parameters;
    private double[] ess;

    public BTExplainingAwayResidual(double[] ess) {
        this.ess = ess;
    }

    public BTExplainingAwayResidual(BTExplainingAwayResidualParameterSet parameters) {
        this(parameters.getEss());
        this.parameters = parameters;
    }

    public BTExplainingAwayResidual(StringBuffer buf) throws NonParsableException {
        buf = XMLParser.extractForTag(buf, "btExplainingAwayResidual");
        this.ess = XMLParser.extractObjectForTags(buf, "ess", double[].class);
    }

    @Override
    public BTExplainingAwayResidual clone() throws CloneNotSupportedException {
        BTExplainingAwayResidual clone = (BTExplainingAwayResidual)super.clone();
        clone.ess = (double[])this.ess.clone();
        return clone;
    }

    @Override
    public String getInstanceName() {
        return "Bayesian tree with explaining away residual";
    }

    @Override
    public int[][] getParents(Sample fg, Sample bg, double[] weightsFg, double[] weightsBg, int length) throws Exception {
        int i;
        double[][][][] statFg = BTExplainingAwayResidual.getStatistics(fg, weightsFg, length, this.ess[0]);
        double[][][][] statBg = BTExplainingAwayResidual.getStatistics(bg, weightsBg, length, this.ess[1]);
        double nFg = BTExplainingAwayResidual.sum(weightsFg) + this.ess[0];
        double nBg = BTExplainingAwayResidual.sum(weightsBg) + this.ess[1];
        double[][] ear = BTExplainingAwayResidual.getEAR(statFg, statBg, nFg, nBg);
        int[][] p = MST.kruskal(ear);
        int[][] parents = new int[length][1];
        for (i = 0; i < parents.length; ++i) {
            parents[i][0] = i;
        }
        for (i = 0; i < p.length; ++i) {
            int idx = p[i][1];
            parents[idx] = new int[2];
            parents[idx][0] = p[i][0];
            parents[idx][1] = idx;
        }
        return parents;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendObjectWithTags(buf, this.ess, "ess");
        XMLParser.addTags(buf, "btExplainingAwayResidual");
        return buf;
    }

    @Override
    public InstanceParameterSet getCurrentParameterSet() throws Exception {
        if (this.parameters != null) {
            return this.parameters;
        }
        return new BTExplainingAwayResidualParameterSet(this.ess);
    }

    public static class BTExplainingAwayResidualParameterSet
    extends InstanceParameterSet {
        public BTExplainingAwayResidualParameterSet() {
            super(BTExplainingAwayResidual.class);
        }

        public BTExplainingAwayResidualParameterSet(double[] ess) throws Exception {
            super(BTExplainingAwayResidual.class);
            this.loadParameters();
            ((Parameter)this.parameters.get(0)).setValue(ess[0]);
            ((Parameter)this.parameters.get(1)).setValue(ess[1]);
        }

        public BTExplainingAwayResidualParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        public double[] getEss() {
            return new double[]{(Double)((Parameter)this.parameters.get(0)).getValue(), (Double)((Parameter)this.parameters.get(1)).getValue()};
        }

        @Override
        public String getInstanceComment() {
            return "Bayesian tree - explaining away residual";
        }

        @Override
        public String getInstanceName() {
            return "Build a Bayesian tree using explaining away residual as structure measure.";
        }

        @Override
        protected void loadParameters() throws Exception {
            this.initParameterList();
            this.parameters.add(new SimpleParameter(DataType.DOUBLE, "Foreground ESS", "The equivalent sample size for the foreground.", true));
            this.parameters.add(new SimpleParameter(DataType.DOUBLE, "Background ESS", "The equivalent sample size for the background, i.e. the background class or (in case of more than two classes) all non-foreground classes.", true));
        }
    }
}

