/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.io.XMLParser;
import java.util.Arrays;
import java.util.TreeMap;

public final class DoubleList
implements Storable,
Cloneable {
    private int size;
    private double[] array;

    public DoubleList() {
        this(10);
    }

    public DoubleList(int size) throws IllegalArgumentException {
        if (size <= 0) {
            throw new IllegalArgumentException("The size has to be positive.");
        }
        this.size = 0;
        this.array = new double[size];
    }

    public DoubleList clone() throws CloneNotSupportedException {
        DoubleList clone = (DoubleList)super.clone();
        clone.array = (double[])this.array.clone();
        return clone;
    }

    public DoubleList(StringBuffer rep) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(rep, this.getClass().getSimpleName());
        this.size = XMLParser.extractObjectForTags(xml, "size", Integer.TYPE);
        this.array = new double[this.size];
        TreeMap<String, String> filter = new TreeMap<String, String>();
        for (int i = 0; i < this.size; ++i) {
            filter.clear();
            filter.put("val", "" + i);
            this.array[i] = XMLParser.extractObjectAndAttributesForTags(xml, "pos", null, filter, Double.TYPE);
        }
    }

    public void addAll(DoubleList list2) {
        if (this.array.length <= this.size + list2.length()) {
            double[] help = new double[2 * (this.array.length + list2.length())];
            System.arraycopy(this.array, 0, help, 0, this.size);
            this.array = help;
        }
        System.arraycopy(list2.array, 0, this.array, this.size, list2.length());
        this.size += list2.length();
    }

    public void add(double val) {
        if (this.array.length == this.size) {
            double[] help = new double[2 * this.array.length];
            System.arraycopy(this.array, 0, help, 0, this.size);
            this.array = help;
        }
        this.array[this.size++] = val;
    }

    public void add(double val, int fromIndex, int toIndex) {
        if (toIndex > this.array.length) {
            double[] help = new double[toIndex];
            System.arraycopy(this.array, 0, help, 0, this.size);
            this.array = help;
        }
        while (fromIndex < toIndex) {
            this.array[fromIndex++] = val;
        }
        if (this.size < toIndex) {
            this.size = toIndex;
        }
    }

    public void clear() {
        this.size = 0;
    }

    public double get(int index) {
        if (index < this.size) {
            return this.array[index];
        }
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public int length() {
        return this.size;
    }

    public double[] toArray() {
        double[] erg = new double[this.size];
        System.arraycopy(this.array, 0, erg, 0, this.size);
        return erg;
    }

    public void multiply(int start, int end, double factor) {
        while (start < end) {
            int n = start++;
            this.array[n] = this.array[n] * factor;
        }
    }

    public double mean(int start, int end) {
        if (start >= end) {
            throw new IllegalArgumentException("The start index has to be smaller than the end index.");
        }
        double sum = 0.0;
        for (int k = start; k < end; ++k) {
            sum += this.array[k];
        }
        return sum / (double)(end - start);
    }

    public double median(int start, int end) {
        if (start >= end) {
            throw new IllegalArgumentException("The start index has to be smaller than the end index.");
        }
        double[] part = new double[end - start];
        System.arraycopy(this.array, start, part, 0, part.length);
        Arrays.sort(part);
        if (part.length % 2 == 0) {
            return (part[part.length / 2] + part[part.length / 2 - 1]) / 2.0;
        }
        return part[(part.length - 1) / 2];
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(this.size * 30);
        XMLParser.appendObjectWithTags(xml, this.size, "size");
        for (int i = 0; i < this.size; ++i) {
            XMLParser.appendObjectWithTagsAndAttributes(xml, this.array[i], "pos", "val=\"" + i + "\"");
        }
        XMLParser.addTags(xml, this.getClass().getSimpleName());
        return xml;
    }
}

