/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.optimization.termination;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.algorithms.optimization.termination.AbstractTerminationCondition;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.utils.Time;

public class IterationCondition
extends AbstractTerminationCondition {
    private int maxIter;

    public IterationCondition(int maxIter) throws Exception {
        this(new IterationConditionParameterSet(maxIter));
    }

    public IterationCondition(IterationConditionParameterSet parameter) throws CloneNotSupportedException {
        super(parameter);
    }

    @Override
    protected void set() {
        this.maxIter = (Integer)this.parameter.getParameterAt(0).getValue();
    }

    @Override
    protected String getXmlTag() {
        return "IterationCondition";
    }

    public IterationCondition(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public boolean doNextIteration(int iteration, double f_last, double f_current, double[] gradient, double[] direction, double alpha, Time t) {
        return iteration < this.maxIter;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    public static class IterationConditionParameterSet
    extends AbstractTerminationCondition.AbstractTerminationConditionParameterSet {
        public IterationConditionParameterSet() {
            super(IterationCondition.class);
        }

        public IterationConditionParameterSet(StringBuffer xml) throws NonParsableException {
            super(xml);
        }

        public IterationConditionParameterSet(int maxIter) throws IllegalArgumentException, SimpleParameter.IllegalValueException {
            this();
            this.getParameterAt(0).setValue(maxIter);
        }

        @Override
        public String getInstanceComment() {
            return "a set of parameters for the IterationCondition";
        }

        @Override
        public String getInstanceName() {
            return "IterationConditionParameterSet";
        }

        @Override
        protected void loadParameters() throws Exception {
            this.initParameterList();
            this.parameters.add(new SimpleParameter(DataType.INT, "maximal iteration", "the maximal number of iterations for stopping an algorithm", true, new NumberValidator<Integer>(new Integer(0), new Integer(Integer.MAX_VALUE))));
        }
    }
}

