/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters.validation;

import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.validation.ParameterValidator;

public class NumberValidator<E extends Comparable<? extends Number>>
implements ParameterValidator {
    private E lowerBound;
    private E upperBound;
    private Class clazz;
    private String errorMessage;

    public NumberValidator(E lowerBound, E upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.clazz = lowerBound.getClass();
    }

    public NumberValidator(StringBuffer representation) throws NonParsableException {
        this.fromXML(representation);
    }

    @Override
    public NumberValidator clone() {
        NumberValidator<E> clone = new NumberValidator<E>(this.lowerBound, this.upperBound);
        clone.errorMessage = this.errorMessage;
        return clone;
    }

    public E getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean checkValue(Object value) {
        if (value == null) {
            this.errorMessage = "Value is null.";
            return false;
        }
        if (!(this.clazz.isInstance(value) && value instanceof Comparable && value instanceof Number)) {
            this.errorMessage = "Value is not of the correct numeric datatype but of " + value.getClass() + ".";
            return false;
        }
        Comparable c = (Comparable)value;
        if (c.compareTo(this.lowerBound) < 0) {
            this.errorMessage = "Value " + c.toString() + " is less than the lower bound " + this.lowerBound + ".";
            return false;
        }
        if (c.compareTo(this.upperBound) > 0) {
            this.errorMessage = "Value " + c.toString() + " is greater than the upper bound " + this.upperBound + ".";
            return false;
        }
        this.errorMessage = null;
        return true;
    }

    public void fromXML(StringBuffer representation) throws NonParsableException {
        block8: {
            representation = XMLParser.extractForTag(representation, "NumberValidator");
            String className = XMLParser.extractObjectForTags(representation, "className", String.class);
            try {
                this.clazz = Class.forName(className);
                String lower = XMLParser.extractObjectForTags(representation, "lowerBound", String.class);
                String upper = XMLParser.extractObjectForTags(representation, "upperBound", String.class);
                if (this.clazz.equals(Double.class)) {
                    this.lowerBound = new Double(lower);
                    this.upperBound = new Double(upper);
                    break block8;
                }
                if (this.clazz.equals(Float.class)) {
                    this.lowerBound = new Float(lower);
                    this.upperBound = new Float(upper);
                    break block8;
                }
                if (this.clazz.equals(Byte.class)) {
                    this.lowerBound = new Byte(lower);
                    this.upperBound = new Byte(upper);
                    break block8;
                }
                if (this.clazz.equals(Short.class)) {
                    this.lowerBound = new Short(lower);
                    this.upperBound = new Short(upper);
                    break block8;
                }
                if (this.clazz.equals(Integer.class)) {
                    this.lowerBound = new Integer(lower);
                    this.upperBound = new Integer(upper);
                    break block8;
                }
                if (this.clazz.equals(Long.class)) {
                    this.lowerBound = new Long(lower);
                    this.upperBound = new Long(upper);
                    break block8;
                }
                throw new NonParsableException();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendObjectWithTags(buf, this.clazz.getName(), "className");
        XMLParser.appendObjectWithTags(buf, this.lowerBound.toString(), "lowerBound");
        XMLParser.appendObjectWithTags(buf, this.upperBound.toString(), "upperBound");
        XMLParser.addTags(buf, "NumberValidator");
        return buf;
    }

    public String toString() {
        return "valid range = [" + this.lowerBound + ", " + this.upperBound + "]";
    }
}

