/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.scoringFunctionBased;

import de.jstacs.NonParsableException;
import de.jstacs.NotTrainedException;
import de.jstacs.algorithms.optimization.ConstantStartDistance;
import de.jstacs.classifier.AbstractScoreBasedClassifier;
import de.jstacs.classifier.ClassDimensionException;
import de.jstacs.classifier.scoringFunctionBased.AbstractMultiThreadedOptimizableFunction;
import de.jstacs.classifier.scoringFunctionBased.OptimizableFunction;
import de.jstacs.classifier.scoringFunctionBased.SFBasedOptimizableFunction;
import de.jstacs.classifier.scoringFunctionBased.ScoreClassifierParameterSet;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MutableMotifDiscovererToolbox;
import de.jstacs.motifDiscovery.history.History;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.scoringFunctions.AbstractNormalizableScoringFunction;
import de.jstacs.scoringFunctions.ScoringFunction;
import de.jstacs.utils.SafeOutputStream;
import java.io.OutputStream;

public abstract class ScoreClassifier
extends AbstractScoreBasedClassifier {
    protected ScoringFunction[] score;
    protected ScoreClassifierParameterSet params;
    protected boolean hasBeenOptimized;
    private double lastScore;
    protected SafeOutputStream sostream;
    public static final double NOT_TRAINED_VALUE = Double.NaN;
    protected History template = null;

    public ScoreClassifier(ScoreClassifierParameterSet params, double lastScore, ScoringFunction ... score) throws CloneNotSupportedException {
        super(params.getAlphabetContainer(), params.getLength(), score.length);
        int len = this.getLength();
        AlphabetContainer con = this.getAlphabetContainer();
        for (int i = 0; i < score.length; ++i) {
            int l = score[i].getLength();
            if ((l == 0 || l == len) && con.checkConsistency(score[i].getAlphabetContainer())) {
                continue;
            }
            throw new IllegalArgumentException("Please check the length (" + l + " vs. " + len + ")" + " and the AlphabetContainer of the ScoringFunction with index " + i + ".");
        }
        this.score = (ScoringFunction[])ArrayHandler.clone((Cloneable[])score);
        this.hasBeenOptimized = false;
        this.lastScore = this.isTrained() ? lastScore : Double.NaN;
        this.set((ScoreClassifierParameterSet)params.clone());
    }

    public ScoreClassifier(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public ScoreClassifier clone() throws CloneNotSupportedException {
        ScoreClassifier clone = (ScoreClassifier)super.clone();
        clone.params = (ScoreClassifierParameterSet)this.params.clone();
        clone.score = (ScoringFunction[])ArrayHandler.clone((Cloneable[])this.score);
        clone.setOutputStream(this.sostream.doesNothing() ? null : SafeOutputStream.DEFAULT_STREAM);
        return clone;
    }

    @Override
    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public CategoricalResult[] getClassifierAnnotation() {
        CategoricalResult[] res = new CategoricalResult[this.score.length + 1];
        res[0] = new CategoricalResult("classifier", "a <b>short</b> description of the classifier", this.getInstanceName());
        int i = 0;
        while (i < this.score.length) {
            res[i + 1] = new CategoricalResult("class info " + i, "some information about the class", this.score[i++].getInstanceName());
        }
        return res;
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        NumericalResult[] pars = new NumericalResult[this.score.length + (this.hasBeenOptimized ? 1 : 0)];
        if (this.hasBeenOptimized) {
            pars[0] = new NumericalResult("Last score", "The final score after the optimization", this.lastScore);
        }
        for (int i = 0; i < this.score.length; ++i) {
            pars[i + (this.hasBeenOptimized ? 1 : 0)] = new NumericalResult("Number of parameters " + (i + 1), "The number of parameters for scoring function " + (i + 1) + ", -1 indicates unknown number of parameters.", this.score[i].getNumberOfParameters());
        }
        return new NumericalResultSet(new NumericalResult[][]{pars});
    }

    @Override
    public boolean isTrained() {
        int i;
        for (i = 0; i < this.score.length && this.score[i].isInitialized(); ++i) {
        }
        return i == this.score.length;
    }

    public boolean hasBeenOptimized() {
        return this.hasBeenOptimized;
    }

    public void setOutputStream(OutputStream o) {
        this.sostream = new SafeOutputStream(o);
    }

    @Override
    public void train(Sample[] data, double[][] weights) throws Exception {
        this.hasBeenOptimized = false;
        if (weights != null && data.length != ((double[][])weights).length) {
            throw new IllegalArgumentException("data and weights do not match");
        }
        if (this.score.length != data.length) {
            throw new ClassDimensionException();
        }
        if (weights == null) {
            weights = new double[data.length][];
        }
        Sample[] reduced = new Sample[data.length];
        double[][] newWeights = new double[data.length][];
        AlphabetContainer abc = this.getAlphabetContainer();
        int l = this.getLength();
        for (int i = 0; i < this.score.length; ++i) {
            if (weights[i] != null && data[i].getNumberOfElements() != weights[i].length) {
                throw new IllegalArgumentException("At least for one sample: The dimension of the sample and the weight do not match.");
            }
            if (!abc.checkConsistency(data[i].getAlphabetContainer())) {
                throw new IllegalArgumentException("At least one sample is not defined over the correct alphabets.");
            }
            Sample.WeightedSampleFactory wsf = data[i].getElementLength() != l ? new Sample.WeightedSampleFactory(Sample.WeightedSampleFactory.SortOperation.NO_SORT, data[i], weights[i], l) : new Sample.WeightedSampleFactory(Sample.WeightedSampleFactory.SortOperation.NO_SORT, data[i], weights[i]);
            reduced[i] = wsf.getSample();
            newWeights[i] = wsf.getWeights();
        }
        this.lastScore = this.doOptimization(reduced, newWeights);
    }

    protected double doOptimization(Sample[] reduced, double[][] newWeights) throws Exception {
        byte algo = (Byte)this.params.getParameterAt(0).getValue();
        double eps = (Double)this.params.getParameterAt(1).getValue();
        double linEps = (Double)this.params.getParameterAt(2).getValue();
        double startDist = (Double)this.params.getParameterAt(3).getValue();
        double[] best = null;
        Object res = new double[2][];
        double max = Double.NEGATIVE_INFINITY;
        int iterations = AbstractNormalizableScoringFunction.getNumberOfStarts(this.score);
        this.sostream.writeln(this.getInstanceName());
        ScoringFunction[] bestSF = new ScoringFunction[this.score.length];
        Cloneable[] secure = iterations > 1 ? (ScoringFunction[])ArrayHandler.clone((Cloneable[])this.score) : null;
        History[][] hist = MutableMotifDiscovererToolbox.createHistoryArray(this.score, this.template);
        int[][] minimalNewLength = MutableMotifDiscovererToolbox.createMinimalNewLengthArray(this.score);
        ConstantStartDistance sd = new ConstantStartDistance(startDist);
        SFBasedOptimizableFunction f = this.getFunction(reduced, newWeights);
        int i = 0;
        while (i < iterations) {
            this.createStructure(reduced, newWeights);
            f.reset(this.score);
            if (i == 0) {
                this.sostream.writeln("optimizing " + f.getDimensionOfScope() + " parameters");
            }
            this.sostream.writeln("start " + ++i + ":");
            OptimizableFunction.KindOfParameter plugIn = this.preoptimize(f);
            MutableMotifDiscovererToolbox.clearHistoryArray(hist);
            sd.reset();
            res = MutableMotifDiscovererToolbox.optimize(this.score, f, algo, eps, linEps, sd, this.sostream, false, hist, minimalNewLength, plugIn, true);
            double current = res[0][0];
            if (current > max) {
                System.arraycopy(this.score, 0, bestSF, 0, this.score.length);
                best = res[1];
                max = current;
                System.gc();
            }
            if (iterations <= 1) continue;
            this.score = (ScoringFunction[])ArrayHandler.clone((Cloneable[])secure);
            if (!this.sostream.doesNothing()) continue;
            System.out.println("start " + i + ": " + res[0][0]);
        }
        this.sostream.writeln("best = " + max);
        this.score = bestSF;
        this.setClassWeights(false, best);
        this.hasBeenOptimized = true;
        if (f instanceof AbstractMultiThreadedOptimizableFunction) {
            f.stopThreads();
        }
        return max;
    }

    protected OptimizableFunction.KindOfParameter preoptimize(OptimizableFunction f) throws Exception {
        return (OptimizableFunction.KindOfParameter)((Object)this.params.getParameterAt(5).getValue());
    }

    protected void createStructure(Sample[] data, double[][] weights, boolean initRandomly) throws Exception {
        boolean freeParams = this.params.useOnlyFreeParameter();
        for (int i = 0; i < this.score.length; ++i) {
            if (initRandomly) {
                this.score[i].initializeFunctionRandomly(freeParams);
                continue;
            }
            this.score[i].initializeFunction(i, freeParams, data, weights);
        }
    }

    protected void createStructure(Sample[] data, double[][] weights) throws Exception {
        this.createStructure(data, weights, false);
    }

    @Override
    protected void extractFurtherClassifierInfosFromXML(StringBuffer xml) throws NonParsableException {
        super.extractFurtherClassifierInfosFromXML(xml);
        this.set((ScoreClassifierParameterSet)XMLParser.extractObjectForTags(xml, "params"));
        this.hasBeenOptimized = XMLParser.extractObjectForTags(xml, "hasBeenOptimized", Boolean.TYPE);
        this.lastScore = XMLParser.extractObjectForTags(xml, "lastScore", Double.TYPE);
        this.score = XMLParser.extractObjectForTags(xml, "score", ScoringFunction[].class);
    }

    protected abstract SFBasedOptimizableFunction getFunction(Sample[] var1, double[][] var2) throws Exception;

    @Override
    protected StringBuffer getFurtherClassifierInfos() {
        StringBuffer xml = super.getFurtherClassifierInfos();
        XMLParser.appendObjectWithTags(xml, this.params, "params");
        XMLParser.appendObjectWithTags(xml, this.hasBeenOptimized, "hasBeenOptimized");
        XMLParser.appendObjectWithTags(xml, this.lastScore, "lastScore");
        XMLParser.appendObjectWithTags(xml, this.score, "score");
        return xml;
    }

    @Override
    protected double getScore(Sequence seq, int i, boolean check) throws IllegalArgumentException, NotTrainedException, Exception {
        if (check) {
            this.check(seq);
        }
        return this.getClassWeight(i) + this.score[i].getLogScore(seq, 0);
    }

    public double getLastScore() {
        return this.lastScore;
    }

    public ScoringFunction getScoringFunction(int i) throws CloneNotSupportedException {
        return this.score[i].clone();
    }

    public ScoringFunction[] getScoringFunctions() throws CloneNotSupportedException {
        return (ScoringFunction[])ArrayHandler.clone((Cloneable[])this.score);
    }

    @Override
    protected abstract String getXMLTag();

    private void set(ScoreClassifierParameterSet params) {
        this.params = params;
        this.setOutputStream(SafeOutputStream.DEFAULT_STREAM);
    }

    public ScoreClassifierParameterSet getCurrentParameterSet() throws CloneNotSupportedException {
        return (ScoreClassifierParameterSet)this.params.clone();
    }
}

