/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences.annotation;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.results.Result;

public class ReferenceSequenceAnnotationParser
extends SplitSequenceAnnotationParser {
    private String key;
    private AlphabetContainer alphabet;

    public ReferenceSequenceAnnotationParser(String key, AlphabetContainer alphabet, String keyValueDelimiter, String annotationDelimiter) throws IllegalArgumentException {
        super(keyValueDelimiter, annotationDelimiter);
        this.key = key;
        this.alphabet = alphabet;
    }

    @Override
    protected void add(String type, String identifier) {
        if (type.equalsIgnoreCase(this.key)) {
            try {
                this.annot.add(new ReferenceSequenceAnnotation(this.key, Sequence.create(this.alphabet, identifier), new Result[0]));
            }
            catch (Exception e) {
                RuntimeException re = new RuntimeException(e.getMessage());
                re.setStackTrace(e.getStackTrace());
                throw re;
            }
        } else {
            super.add(type, identifier);
        }
    }
}

