/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete.homogeneous;

import de.jstacs.NonParsableException;
import de.jstacs.NotTrainedException;
import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.EmptySampleException;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.models.discrete.Constraint;
import de.jstacs.models.discrete.DGMParameterSet;
import de.jstacs.models.discrete.DiscreteGraphicalModel;
import de.jstacs.models.discrete.homogeneous.parameters.HomogeneousModelParameterSet;
import de.jstacs.results.NumericalResultSet;
import java.util.Random;

public abstract class HomogeneousModel
extends DiscreteGraphicalModel {
    protected int[] powers;
    protected byte order;

    public HomogeneousModel(HomogeneousModelParameterSet params) throws CloneNotSupportedException, IllegalArgumentException, NonParsableException {
        super(params);
    }

    public HomogeneousModel(StringBuffer stringBuff) throws NonParsableException {
        super(stringBuff);
    }

    @Override
    public final Sample emitSample(int no, int ... length) throws NotTrainedException, IllegalArgumentException, EmptySampleException, WrongAlphabetException, WrongSequenceTypeException {
        if (!this.trained) {
            throw new NotTrainedException();
        }
        Sequence[] seq = new Sequence[no];
        if (length.length == 1) {
            for (int i = 0; i < no; ++i) {
                seq[i] = this.getRandomSequence(new Random(), length[0]);
            }
        } else if (length.length == no) {
            for (int i = 0; i < no; ++i) {
                seq[i] = this.getRandomSequence(new Random(), length[i]);
            }
        } else {
            throw new IllegalArgumentException("The dimension of the array length is not correct.");
        }
        return new Sample("sampled from " + this.getInstanceName(), seq);
    }

    protected abstract Sequence getRandomSequence(Random var1, int var2) throws WrongAlphabetException, WrongSequenceTypeException;

    @Override
    public byte getMaximalMarkovOrder() {
        return this.order;
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        return null;
    }

    @Override
    public final double getLogProbFor(Sequence sequence, int startpos, int endpos) throws NotTrainedException, Exception {
        this.check(sequence, startpos, endpos);
        return this.logProbFor(sequence, startpos, endpos);
    }

    @Override
    public final double getProbFor(Sequence sequence, int startpos, int endpos) throws NotTrainedException, Exception {
        this.check(sequence, startpos, endpos);
        return this.probFor(sequence, startpos, endpos);
    }

    public void train(Sample[] data) throws Exception {
        this.train(data, new double[data.length][]);
    }

    public abstract void train(Sample[] var1, double[][] var2) throws Exception;

    @Override
    protected void set(DGMParameterSet params, boolean trained) throws CloneNotSupportedException, NonParsableException {
        super.set(params, trained);
        this.order = (Byte)params.getParameterAt(2).getValue();
        this.powers = new int[Math.max(this.order + 1, 2)];
        this.powers[0] = 1;
        this.powers[1] = (int)this.alphabets.getAlphabetLengthAt(0);
        for (int i = 1; i < this.powers.length; ++i) {
            this.powers[i] = this.powers[1] * this.powers[i - 1];
        }
    }

    @Override
    protected void check(Sequence sequence, int startpos, int endpos) throws NotTrainedException, IllegalArgumentException {
        super.check(sequence, startpos, endpos);
        if (endpos >= sequence.getLength()) {
            throw new IllegalArgumentException("This endposition is impossible. Try: endposistion < sequence.length");
        }
    }

    protected final int chooseFromDistr(Constraint distr, int start, int end, double randNo) {
        int c = start;
        while (randNo > distr.getFreq(c) && c <= end) {
            randNo -= distr.getFreq(c++);
        }
        return c - start;
    }

    protected abstract double logProbFor(Sequence var1, int var2, int var3);

    protected abstract double probFor(Sequence var1, int var2, int var3);

    protected HomCondProb[] cloneHomProb(HomCondProb[] p) {
        HomCondProb[] condProb = new HomCondProb[p.length];
        for (int i = 0; i < condProb.length; ++i) {
            condProb[i] = new HomCondProb(p[i]);
        }
        return condProb;
    }

    protected class HomCondProb
    extends Constraint {
        private double[] lnFreq;
        private static final String XML_TAG = "HomCondProb";

        public HomCondProb(int[] pos, int n) {
            super(pos, n);
        }

        public HomCondProb(StringBuffer xml) throws NonParsableException {
            super(xml);
        }

        public HomCondProb(HomCondProb old) {
            this(old.usedPositions, old.freq.length);
            System.arraycopy(old.freq, 0, this.freq, 0, this.freq.length);
            if (old.lnFreq != null) {
                this.lnFreq(0, this.freq.length);
            }
        }

        @Override
        public void estimate(double ess) {
            double pc = ess / (double)this.getNumberOfSpecificConstraints();
            if (this.usedPositions.length == 1) {
                this.estimateUnConditional(0, this.freq.length, pc, false);
            } else {
                for (int counter1 = 0; counter1 < this.freq.length; counter1 += HomogeneousModel.this.powers[1]) {
                    this.estimateUnConditional(counter1, counter1 + HomogeneousModel.this.powers[1], pc, false);
                }
            }
        }

        public double getLnFreq(int index) {
            return this.lnFreq[index];
        }

        @Override
        public int satisfiesSpecificConstraint(Sequence seq, int start) {
            int erg = 0;
            int counter = 0;
            int p = this.usedPositions.length - 1;
            while (counter < this.usedPositions.length) {
                erg += HomogeneousModel.this.powers[p] * seq.discreteVal(start + this.usedPositions[counter]);
                ++counter;
                --p;
            }
            return erg;
        }

        @Override
        public String toString() {
            String erg = "";
            int i = 1;
            int l = this.usedPositions.length - 1;
            if (l > 0) {
                erg = erg + this.usedPositions[0];
                while (i < l) {
                    erg = erg + ", " + this.usedPositions[i++];
                }
                erg = erg + " -> ";
            }
            return erg + this.usedPositions[l];
        }

        public final void addAll(Sequence seq, double weight, int start, int prevIndex) {
            int l = seq.getLength();
            while (start < l) {
                int n = prevIndex = prevIndex % HomogeneousModel.this.powers[HomogeneousModel.this.order] * HomogeneousModel.this.powers[1] + seq.discreteVal(start++);
                this.counts[n] = this.counts[n] + weight;
            }
        }

        @Override
        protected void appendAdditionalInfo(StringBuffer xml) {
        }

        @Override
        protected String getXMLTag() {
            return XML_TAG;
        }

        @Override
        protected void estimateUnConditional(int start, int end, double pc, boolean exceptionWhenNoData) {
            super.estimateUnConditional(start, end, pc, exceptionWhenNoData);
            this.lnFreq(start, end);
        }

        private void lnFreq(int start, int end) {
            if (this.lnFreq == null) {
                this.lnFreq = new double[this.freq.length];
            }
            for (int i = start; i < end; ++i) {
                this.lnFreq[i] = Math.log(this.freq[i]);
            }
        }

        @Override
        protected void extractAdditionalInfo(StringBuffer xml) throws NonParsableException {
            this.lnFreq(0, this.freq.length);
        }

        @Override
        public String getDescription(AlphabetContainer con, int i) {
            String res = null;
            for (int j = 0; j < this.usedPositions.length; ++j) {
                DiscreteAlphabet d = (DiscreteAlphabet)con.getAlphabetAt(this.usedPositions[j]);
                String s = "X_" + this.usedPositions[j] + "=" + d.getSymbolAt(i / HomogeneousModel.this.powers[this.usedPositions.length - 1 - j]);
                res = res == null ? s : s + ", " + res;
                i %= HomogeneousModel.this.powers[this.usedPositions.length - 1 - j];
            }
            res = res.replaceFirst(", ", " | ");
            return "P(" + res + ")";
        }
    }
}

