/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.pmmMeasures;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.algorithms.graphs.DAG;
import de.jstacs.algorithms.graphs.tensor.SymmetricTensor;
import de.jstacs.algorithms.graphs.tensor.Tensor;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.Measure;
import de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.btMeasures.BTMutualInformation;

public class PMMMutualInformation
extends Measure {
    private PMMMutualInformationParameterSet parameters;
    private BTMutualInformation.DataSource clazz;
    private byte order;
    private double[] ess;

    public PMMMutualInformation(byte order, BTMutualInformation.DataSource clazz, double[] ess) throws Exception {
        if (order < 1 || order > 2) {
            throw new Exception("Only order 1 and 2 allowed (yet).");
        }
        this.order = order;
        this.ess = ess;
        this.clazz = clazz;
    }

    public PMMMutualInformation(PMMMutualInformationParameterSet parameters) throws Exception {
        this(parameters.getOrder(), parameters.getClazz(), parameters.getEss());
        this.parameters = parameters;
    }

    public PMMMutualInformation(StringBuffer buf) throws NonParsableException {
        buf = XMLParser.extractForTag(buf, "pmmMutualInformation");
        this.order = XMLParser.extractObjectForTags(buf, "order", Byte.TYPE);
        this.clazz = XMLParser.extractObjectForTags(buf, "clazz", BTMutualInformation.DataSource.class);
        this.ess = XMLParser.extractObjectForTags(buf, "ess", double[].class);
    }

    @Override
    public PMMMutualInformation clone() throws CloneNotSupportedException {
        PMMMutualInformation clone = (PMMMutualInformation)super.clone();
        clone.ess = (double[])this.ess.clone();
        return clone;
    }

    @Override
    public String getInstanceName() {
        String str = "Permuted Markov model of order " + this.order + " with mutual information of";
        if (this.clazz == BTMutualInformation.DataSource.FG) {
            return str + " foreground";
        }
        if (this.clazz == BTMutualInformation.DataSource.BG) {
            return str + " background";
        }
        return str + " foreground and background";
    }

    @Override
    public int[][] getParents(Sample fg, Sample bg, double[] weightsFg, double[] weightsBg, int length) throws Exception {
        Sample data = null;
        double[] weights = null;
        double ess2 = 0.0;
        if (this.clazz == BTMutualInformation.DataSource.FG) {
            data = fg;
            weights = weightsFg;
            ess2 = this.ess[0];
        } else if (this.clazz == BTMutualInformation.DataSource.BG) {
            data = bg;
            weights = weightsBg;
            ess2 = this.ess[1];
        } else {
            data = Sample.union(fg, bg);
            weights = PMMMutualInformation.union(new double[][]{weightsFg, weightsBg});
            ess2 = this.ess[0] + this.ess[1];
        }
        SymmetricTensor t = new SymmetricTensor(length, this.order);
        PMMMutualInformation.fillTensor((Tensor)t, PMMMutualInformation.getMI(PMMMutualInformation.getStatistics(data, weights, length, ess2), PMMMutualInformation.sum(weights) + ess2));
        if (this.order == 2) {
            PMMMutualInformation.fillTensor((Tensor)t, PMMMutualInformation.getMI(PMMMutualInformation.getStatisticsOrderTwo(data, weights, length, ess2), PMMMutualInformation.sum(weights) + ess2));
        }
        int[] o = DAG.computeMaximalHP(t);
        return PMMMutualInformation.toParents(o, this.order);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendObjectWithTags(buf, this.order, "order");
        XMLParser.appendObjectWithTags(buf, (Object)this.clazz, "clazz");
        XMLParser.appendObjectWithTags(buf, this.ess, "ess");
        XMLParser.addTags(buf, "pmmMutualInformation");
        return buf;
    }

    @Override
    public InstanceParameterSet getCurrentParameterSet() throws Exception {
        if (this.parameters != null) {
            return this.parameters;
        }
        return new PMMMutualInformationParameterSet(this.order, this.clazz, this.ess);
    }

    public static class PMMMutualInformationParameterSet
    extends InstanceParameterSet {
        public PMMMutualInformationParameterSet() {
            super(BTMutualInformation.class);
        }

        public PMMMutualInformationParameterSet(byte order, BTMutualInformation.DataSource clazz, double[] ess) throws Exception {
            super(BTMutualInformation.class);
            this.loadParameters();
            ((Parameter)this.parameters.get(0)).setValue(ess[0]);
            ((Parameter)this.parameters.get(1)).setValue(ess[1]);
            ((Parameter)this.parameters.get(2)).setValue((Object)clazz);
            ((Parameter)this.parameters.get(3)).setValue(order);
        }

        public PMMMutualInformationParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        public double[] getEss() {
            return new double[]{(Double)((Parameter)this.parameters.get(0)).getValue(), (Double)((Parameter)this.parameters.get(1)).getValue()};
        }

        public BTMutualInformation.DataSource getClazz() {
            return (BTMutualInformation.DataSource)((EnumParameter)this.parameters.get(2)).getValue();
        }

        public byte getOrder() {
            return (Byte)((Parameter)this.parameters.get(3)).getValue();
        }

        @Override
        public String getInstanceComment() {
            return "Permuted Markov model - mutual information";
        }

        @Override
        public String getInstanceName() {
            return "Build a permuted Markov model using mutual information as structure measure.";
        }

        @Override
        protected void loadParameters() throws Exception {
            this.initParameterList();
            this.parameters.add(new SimpleParameter(DataType.DOUBLE, "Foreground ESS", "The equivalent sample size for the foreground.", true));
            this.parameters.add(new SimpleParameter(DataType.DOUBLE, "Background ESS", "The equivalent sample size for the background, i.e. the background class or (in case of more than two classes) all non-foreground classes.", true));
            this.parameters.add(new EnumParameter(BTMutualInformation.DataSource.class, "The data used to compute mutual information.", true));
            this.parameters.add(new SimpleParameter(DataType.BYTE, "Order", "The order of the permuted Markov model. Only 1 or 2 allowed.", true));
        }
    }
}

