/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.mix.motifSearch;

import de.jstacs.NonParsableException;
import de.jstacs.data.Sample;
import de.jstacs.scoringFunctions.mix.motifSearch.DurationScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;

public final class UniformDurationScoringFunction
extends DurationScoringFunction {
    private double logP;

    public UniformDurationScoringFunction(int min, int max) {
        this(min, max, 0.0);
    }

    public UniformDurationScoringFunction(int min, int max, double ess) {
        super(min, max, ess);
        this.computeLogP();
    }

    public UniformDurationScoringFunction(StringBuffer b) throws NonParsableException {
        super(b);
        this.computeLogP();
    }

    private void computeLogP() {
        this.logP = -Math.log(this.delta + 1);
    }

    @Override
    public String getInstanceName() {
        return "uniform";
    }

    @Override
    public int getNumberOfParameters() {
        return 0;
    }

    @Override
    public void setParameters(double[] params, int start) {
    }

    @Override
    public void initializeFunction(int index, boolean meila, Sample[] data, double[][] weights) {
    }

    @Override
    protected String getRNotation(String distributionName) {
        return "l = " + this.min + ":" + this.max + "; n = length(l); " + distributionName + " = rep(1,n)/n;";
    }

    @Override
    public double getLogPriorTerm() {
        return 0.0;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) {
    }

    @Override
    public double getLogScore(int ... values) {
        return this.logP;
    }

    @Override
    public double getLogScoreAndPartialDerivation(IntList indices, DoubleList partialDer, int ... values) {
        return this.logP;
    }

    public void drawPosition(int[] positions) {
        positions[0] = this.min + r.nextInt(this.delta + 1);
    }

    @Override
    public double[] getCurrentParameterValues() throws Exception {
        return new double[0];
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public boolean isNormalized() {
        return true;
    }

    @Override
    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
    }

    @Override
    public void initializeUniformly() {
    }

    @Override
    public void adjust(int[] length, double[] weight) {
    }
}

