/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.parameters.MultiSelectionCollectionParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.Rangeable;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;

public class CollectionParameter
extends Parameter
implements Rangeable {
    protected ParameterSet parameters;
    private int selected;
    private int defaultSelected;
    protected boolean userSelected;
    private String name;
    private String comment;
    private boolean required;
    private DataType datatype;
    protected String errorMessage;
    private boolean rangeable;

    @Override
    public CollectionParameter clone() throws CloneNotSupportedException {
        CollectionParameter clone = (CollectionParameter)super.clone();
        clone.parameters = this.parameters == null ? null : this.parameters.clone();
        return clone;
    }

    private CollectionParameter(DataType datatype, String name, String comment, boolean required) {
        this.datatype = datatype;
        this.comment = comment;
        this.name = name;
        this.required = required;
        this.userSelected = false;
        this.rangeable = true;
        this.defaultSelected = -1;
        this.selected = 0;
    }

    protected CollectionParameter(ParameterSet options, int selected, int defaultSelected, boolean userSelected, String name, String comment, boolean required, DataType datatype, String errorMessage, boolean rangeable) {
        this.parameters = options;
        this.selected = selected;
        this.defaultSelected = defaultSelected;
        this.userSelected = userSelected;
        this.name = name;
        this.comment = comment;
        this.required = required;
        this.datatype = datatype;
        this.errorMessage = errorMessage;
        this.rangeable = rangeable;
    }

    public CollectionParameter(DataType datatype, String[] keys, Object[] values, String name, String comment, boolean required) throws InconsistentCollectionException, SimpleParameter.IllegalValueException, SimpleParameter.DatatypeNotValidException {
        this(datatype, keys, values, null, name, comment, required);
    }

    public CollectionParameter(DataType datatype, String[] keys, Object[] values, String[] comments, String name, String comment, boolean required) throws InconsistentCollectionException, SimpleParameter.IllegalValueException, SimpleParameter.DatatypeNotValidException {
        this(datatype, name, comment, required);
        if (keys.length != values.length || comments != null && keys.length != comments.length) {
            throw new InconsistentCollectionException("You have to define the same number of keys and values for a CollectionParameter!");
        }
        this.createParameterSet(values, keys, comments);
    }

    public CollectionParameter(ParameterSet[] values, String[] keys, String[] comments, String name, String comment, boolean required) {
        this(DataType.PARAMETERSET, name, comment, required);
        try {
            this.createParameterSet(values, keys, comments);
        }
        catch (Exception doesnothappen) {
            doesnothappen.printStackTrace();
        }
    }

    public CollectionParameter(InstanceParameterSet[] values, String name, String comment, boolean required) {
        this(DataType.PARAMETERSET, name, comment, required);
        try {
            this.createParameterSet(values, null, null);
        }
        catch (Exception doesnothappen) {
            // empty catch block
        }
    }

    protected void createParameterSet(Object[] values, String[] keys, String[] comments) throws SimpleParameter.DatatypeNotValidException, SimpleParameter.IllegalValueException {
        Parameter[] pars = new Parameter[values.length];
        for (int i = 0; i < pars.length; ++i) {
            String c;
            if (values[i] instanceof InstanceParameterSet) {
                InstanceParameterSet p = (InstanceParameterSet)values[i];
                String k = keys == null || keys[i] == null ? p.getInstanceName() : keys[i];
                c = comments == null ? p.getInstanceComment() : comments[i];
                pars[i] = new ParameterSetContainer(k, c, p);
                continue;
            }
            if (keys == null || keys[i] == null) {
                throw new IllegalArgumentException("You have to state the key for entity " + i);
            }
            c = comments != null ? comments[i] : "";
            if (values[i] instanceof ParameterSet) {
                pars[i] = new ParameterSetContainer(keys[i], c, (ParameterSet)values[i]);
                continue;
            }
            pars[i] = new SimpleParameter(this.datatype, keys[i], c, false);
            pars[i].setValue(values[i]);
        }
        this.parameters = new SimpleParameterSet(pars);
    }

    @Override
    public boolean isAtomic() {
        for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
            if (!(this.parameters.getParameterAt(i).getValue() instanceof ParameterSet)) continue;
            return false;
        }
        return true;
    }

    public boolean hasDefault() {
        return this.defaultSelected > -1;
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        if (this.getValue() instanceof ParameterSet) {
            if (!((ParameterSet)this.getValue()).hasDefaultOrIsSet()) {
                if (((ParameterSet)this.getValue()).getErrorMessage() != null) {
                    this.errorMessage = "Selected value has the following error: " + ((ParameterSet)this.getValue()).getErrorMessage();
                }
                return false;
            }
            return true;
        }
        return this.isSet() || this.selected == this.defaultSelected;
    }

    @Override
    public boolean isSet() {
        return this.isUserSelected();
    }

    public CollectionParameter(StringBuffer representation) throws NonParsableException {
        this.fromXML(representation);
    }

    public ParameterSet getParametersInCollection() {
        return this.parameters;
    }

    public void setRangeable(boolean rangeable) {
        this.rangeable = rangeable;
    }

    @Override
    public boolean isRangeable() {
        return this.rangeable;
    }

    @Override
    public boolean checkValue(Object value) {
        if (value == null) {
            return false;
        }
        if (!(value instanceof String)) {
            this.errorMessage = "The value is not in the set of defined values (and not even a String)." + value;
            return false;
        }
        for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
            if (!this.parameters.getParameterAt(i).getName().equals(value)) continue;
            this.errorMessage = null;
            return true;
        }
        this.errorMessage = "The value is not in the set of defined values: " + value + ".";
        return false;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superParameter");
        XMLParser.appendObjectWithTags(buf, (Object)this.datatype, "datatype");
        XMLParser.appendObjectWithTags(buf, this.name, "name");
        XMLParser.appendObjectWithTags(buf, this.comment, "comment");
        XMLParser.appendObjectWithTags(buf, this.required, "required");
        XMLParser.appendObjectWithTags(buf, this.userSelected, "userSelected");
        XMLParser.appendObjectWithTags(buf, this.errorMessage, "errorMessage");
        XMLParser.appendObjectWithTags(buf, this.selected, "selected");
        XMLParser.appendObjectWithTags(buf, this.defaultSelected, "defaultSelected");
        XMLParser.appendObjectWithTags(buf, this.rangeable, "rangeable");
        this.appendCollection(buf);
        XMLParser.addTags(buf, "collectionParameter");
        return buf;
    }

    protected void appendCollection(StringBuffer buf) {
        XMLParser.appendObjectWithTags(buf, this.parameters, "collection");
    }

    @Override
    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "collectionParameter");
        super.fromXML(XMLParser.extractForTag(representation, "superParameter"));
        this.datatype = XMLParser.extractObjectForTags(representation, "datatype", DataType.class);
        this.name = XMLParser.extractObjectForTags(representation, "name", String.class);
        this.comment = XMLParser.extractObjectForTags(representation, "comment", String.class);
        this.required = XMLParser.extractObjectForTags(representation, "required", Boolean.TYPE);
        this.userSelected = XMLParser.extractObjectForTags(representation, "userSelected", Boolean.TYPE);
        this.errorMessage = XMLParser.parseString(XMLParser.extractObjectForTags(representation, "errorMessage", String.class));
        this.selected = XMLParser.extractObjectForTags(representation, "selected", Integer.TYPE);
        this.defaultSelected = XMLParser.extractObjectForTags(representation, "defaultSelected", Integer.TYPE);
        StringBuffer help = XMLParser.extractForTag(representation, "rangeable");
        this.rangeable = help == null ? false : Boolean.parseBoolean(help.toString());
        this.extractCollection(representation);
    }

    protected void extractCollection(StringBuffer buf) throws NonParsableException {
        this.parameters = new SimpleParameterSet(XMLParser.extractForTag(buf, "collection"));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataType getDatatype() {
        return this.datatype;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public int getSelected() {
        return this.selected;
    }

    protected int getDefault() {
        return this.defaultSelected;
    }

    public boolean isUserSelected() {
        return this.userSelected;
    }

    @Override
    public void setValue(Object value) throws SimpleParameter.IllegalValueException {
        Object val2;
        if (value == null) {
            return;
        }
        Object object = val2 = value instanceof InstanceParameterSet ? ((InstanceParameterSet)value).getInstanceName() : value;
        if (this.checkValue(val2)) {
            for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
                if (!this.parameters.getParameterAt(i).getName().equals(val2)) continue;
                this.selected = i;
                this.userSelected = true;
                break;
            }
            if (value != val2) {
                this.parameters.getParameterAt(this.selected).setValue(value);
            }
        } else {
            String s = "";
            String sep = "";
            for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
                s = s + sep + this.parameters.getParameterAt(i).getName();
                sep = ", ";
            }
            throw new SimpleParameter.IllegalValueException("Value (" + val2 + ") not in Collection (" + s + ")!");
        }
    }

    @Override
    public void setDefault(Object defaultValue) throws SimpleParameter.IllegalValueException {
        this.setValue(defaultValue);
        this.defaultSelected = this.selected;
        this.userSelected = false;
    }

    @Override
    public void simplify() {
        for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
            if (i != this.selected && this.parameters.getParameterAt(i).getValue() instanceof ParameterSet) {
                this.parameters.getParameterAt(i).reset();
                continue;
            }
            this.parameters.getParameterAt(i).simplify();
        }
    }

    @Override
    public void reset() {
        this.selected = this.defaultSelected;
        this.simplify();
    }

    @Override
    public Object getValue() {
        if (this.selected < this.parameters.getNumberOfParameters()) {
            return this.parameters.getParameterAt(this.selected).getValue();
        }
        return null;
    }

    public boolean equals(Object o2) {
        if (o2 instanceof CollectionParameter) {
            ParameterSet parSet2 = ((CollectionParameter)o2).getParametersInCollection();
            if (parSet2.getNumberOfParameters() != this.parameters.getNumberOfParameters()) {
                return false;
            }
            if (!((CollectionParameter)o2).getName().equals(this.name) || !((CollectionParameter)o2).getComment().equals(this.comment)) {
                return false;
            }
            for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
                if (this.parameters.getParameterAt(i).equals(parSet2.getParameterAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Parameter getRangedInstance() throws Exception {
        boolean[] selected = new boolean[this.parameters.getNumberOfParameters()];
        selected[0] = true;
        MultiSelectionCollectionParameter par = new MultiSelectionCollectionParameter(this.parameters.clone(), selected, new boolean[this.parameters.getNumberOfParameters()], false, this.getName(), this.getComment(), this.required, this.datatype, this.errorMessage, 0, true);
        return par;
    }

    public String toString() {
        String s = this.parameters.getParameterAt(0).getName();
        for (int i = 1; i < this.parameters.getNumberOfParameters(); ++i) {
            s = s + ", " + this.parameters.getParameterAt(i).getName();
        }
        return this.name + " (" + this.comment + ", range={" + s + "}" + (this.defaultSelected >= 0 ? ", default = " + this.parameters.getParameterAt(this.defaultSelected).getValue() : "") + (this.required ? "" : ", OPTIONAL") + ")\t= " + this.getValue();
    }

    public class InconsistentCollectionException
    extends ParameterException {
        private static final long serialVersionUID = -2703514434545861722L;

        public InconsistentCollectionException(String message) {
            super(message);
        }
    }
}

