package de.jstacs.io;

import java.io.File;
import java.io.FileFilter;

/**
 * This class allows to combine several {@link FileFilter}s.
 * 
 * @author Jens Keilwagen
 *
 * @see RegExFilenameFilter
 * @see DateFileFilter
 */
public class CombinedFileFilter implements FileFilter {

	private int anz;
	private FileFilter[] filter;
	
	/**
	 * Creates an instance that accepts a {@link File} if at least <code>minAccepted</code> filters accept the {@link File}.
	 * 
	 * @param minAccepted the minimal number of filters that has to accept a {@link File}
	 * @param filter the filters internally used
	 */
	public CombinedFileFilter( int minAccepted, FileFilter... filter ) {
		if( minAccepted < 0 || minAccepted > filter.length ) {
			throw new IllegalArgumentException( "Check the value for the parameter anz" );
		}
		this.anz = minAccepted;
		this.filter = filter.clone();
	}
	
	public boolean accept(File pathname) {
		int accepted = 0, i = 0;
		for( ; i < filter.length; i++ ) {
			accepted += filter[i].accept(pathname) ? 1 : 0;
		}
		return accepted >= anz;
	}
	
	public String toString() {
		String desc = "filter (to be accepted: " + anz + "):\n";
		for( int i = 0; i < filter.length; i++ ) {
			desc += filter[i].toString() + "\n";
		}
		return desc;
	}
}
