/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.alignment;

import de.jstacs.algorithms.alignment.PairwiseStringAlignment;
import de.jstacs.algorithms.alignment.cost.Costs;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sequence;

public class Alignment {
    private AlignmentType type;
    private int startS1;
    private int endS1;
    private int startS2;
    private int endS2;
    private Sequence s1;
    private Sequence s2;
    private Costs costs;
    private D[][] d;
    private E[][] e;
    private F[][] f;
    private int offDiagonal;

    public Alignment(AlignmentType type, Costs costs) {
        this(type, costs, Integer.MAX_VALUE);
    }

    public Alignment(AlignmentType type, Costs costs, int offDiagonal) {
        this.type = type;
        this.costs = costs;
        this.offDiagonal = offDiagonal;
    }

    public PairwiseStringAlignment getAlignment(Sequence s1, Sequence s2) {
        return this.getAlignment(s1, 0, s1.getLength(), s2, 0, s2.getLength());
    }

    public PairwiseStringAlignment getAlignment(Sequence s1, int startS1, int endS1, Sequence s2, int startS2, int endS2) {
        int endPos;
        int j;
        int end;
        int start;
        int i;
        this.s1 = s1;
        this.startS1 = startS1;
        this.endS1 = endS1;
        this.s2 = s2;
        this.startS2 = startS2;
        this.endS2 = endS2;
        int l1 = endS1 - startS1;
        int l2 = endS2 - startS2;
        if (this.d == null || this.d.length < l1 + 1 || this.d[0].length < l2 + 1) {
            this.d = new D[l1 + 1][l2 + 1];
            this.e = new E[l1 + 1][l2 + 1];
            this.f = new F[l1 + 1][l2 + 1];
            for (i = 0; i <= l1; ++i) {
                start = Math.max(0, i - this.offDiagonal);
                end = Math.min(l2, Math.max(l2, i + this.offDiagonal));
                for (j = start; j <= end; ++j) {
                    this.e[i][j] = new E(i, j);
                    this.f[i][j] = new F(i, j);
                    this.d[i][j] = new D(i, j);
                }
            }
        } else {
            for (i = 0; i <= l1; ++i) {
                start = Math.max(0, i - this.offDiagonal);
                end = Math.min(l2, Math.max(l2, i + this.offDiagonal));
                for (j = start; j <= end; ++j) {
                    this.e[i][j].compute();
                    this.f[i][j].compute();
                    this.d[i][j].compute();
                }
            }
        }
        Element curr = null;
        int startPos = 0;
        if (this.type == AlignmentType.LOCAL) {
            endPos = -1;
            for (int i2 = 0; i2 <= l1; ++i2) {
                start = Math.max(0, i2 - this.offDiagonal);
                end = Math.min(l2, Math.max(l2, i2 + this.offDiagonal));
                for (int j2 = start; j2 <= end; ++j2) {
                    if (curr != null && !(this.d[i2][j2].cost < curr.cost)) continue;
                    curr = this.d[i2][j2];
                    endPos = startS1 + i2;
                }
            }
        } else {
            endPos = l1;
            curr = this.e[l1][l2].cost < this.f[l1][l2].cost && this.e[l1][l2].cost < this.d[l1][l2].cost ? this.e[l1][l2] : (this.f[l1][l2].cost < this.d[l1][l2].cost ? this.f[l1][l2] : this.d[l1][l2]);
        }
        double cost = curr.cost;
        StringBuffer b1 = new StringBuffer();
        StringBuffer b2 = new StringBuffer();
        AlphabetContainer cont = s1.getAlphabetContainer();
        while (curr.pre != null) {
            if (curr.direction == Costs.Direction.DIAGONAL) {
                b1.insert(0, cont.getSymbol(startS1 + curr.i - 1, s1.discreteVal(startS1 + curr.i - 1)));
                b2.insert(0, cont.getSymbol(startS2 + curr.j - 1, s2.discreteVal(startS2 + curr.j - 1)));
            } else if (curr.direction == Costs.Direction.LEFT) {
                b1.insert(0, '-');
                b2.insert(0, cont.getSymbol(startS2 + curr.j - 1, startS2 + s2.discreteVal(curr.j - 1)));
            } else if (curr.direction == Costs.Direction.TOP) {
                b1.insert(0, cont.getSymbol(startS1 + curr.j - 1, s1.discreteVal(startS1 + curr.i - 1)));
                b2.insert(0, '-');
            }
            if (curr.j == l2 && (curr.direction == Costs.Direction.DIAGONAL || curr.direction == Costs.Direction.LEFT)) {
                endPos = startS1 + curr.i;
            }
            if (!(this.type != AlignmentType.LOCAL && curr.j != 1 || curr.direction != Costs.Direction.DIAGONAL && curr.direction != Costs.Direction.TOP)) {
                startPos = startS1 + curr.i - 1;
            }
            curr = curr.pre;
        }
        return new PairwiseStringAlignment(b1.toString(), b2.toString(), cost, startPos, endPos);
    }

    private class F
    extends Element {
        private F(int i, int j) {
            super(i, j);
        }

        @Override
        public void compute() {
            if (this.i == 0 || Alignment.this.f[this.i - 1][this.j] == null) {
                this.cost = Double.POSITIVE_INFINITY;
            } else if (this.i > 0 && this.j == 0) {
                this.direction = Costs.Direction.TOP;
                this.cost = Alignment.this.type != AlignmentType.GLOBAL ? 0.0 : Alignment.this.costs.getGapCostsFor(this.i);
                this.pre = Alignment.this.type == AlignmentType.LOCAL ? null : Alignment.this.f[this.i - 1][this.j];
            } else if (Alignment.this.type == AlignmentType.SEMI_GLOBAL && this.i > 0 && this.j == Alignment.this.s2.getLength()) {
                this.direction = Costs.Direction.TOP;
                this.pre = Alignment.this.d[this.i - 1][this.j];
                this.cost = this.pre.cost;
            } else {
                double start;
                double elong = ((Alignment)Alignment.this).f[this.i - 1][this.j].cost + Alignment.this.costs.getElongateCosts();
                if (elong < (start = ((Alignment)Alignment.this).d[this.i - 1][this.j].cost + Alignment.this.costs.getGapCostsFor(1))) {
                    this.cost = elong;
                    this.direction = Costs.Direction.TOP;
                    this.pre = Alignment.this.f[this.i - 1][this.j];
                } else {
                    this.cost = start;
                    this.direction = Costs.Direction.TOP;
                    this.pre = Alignment.this.d[this.i - 1][this.j];
                }
            }
        }
    }

    private class E
    extends Element {
        private E(int i, int j) {
            super(i, j);
        }

        @Override
        public void compute() {
            if (this.j == 0 || Alignment.this.e[this.i][this.j - 1] == null) {
                this.cost = Double.POSITIVE_INFINITY;
            } else if (this.i == 0 && this.j > 0) {
                this.direction = Costs.Direction.LEFT;
                if (Alignment.this.type == AlignmentType.LOCAL) {
                    this.cost = 0.0;
                    this.pre = null;
                } else {
                    this.pre = Alignment.this.e[this.i][this.j - 1];
                    this.cost = Alignment.this.costs.getGapCostsFor(this.j);
                }
            } else {
                double start;
                double elong = ((Alignment)Alignment.this).e[this.i][this.j - 1].cost + Alignment.this.costs.getElongateCosts();
                if (elong < (start = ((Alignment)Alignment.this).d[this.i][this.j - 1].cost + Alignment.this.costs.getGapCostsFor(1))) {
                    this.cost = elong;
                    this.direction = Costs.Direction.LEFT;
                    this.pre = Alignment.this.e[this.i][this.j - 1];
                } else {
                    this.cost = start;
                    this.direction = Costs.Direction.LEFT;
                    this.pre = Alignment.this.d[this.i][this.j - 1];
                }
            }
        }
    }

    private class D
    extends Element {
        private D(int i, int j) {
            super(i, j);
        }

        @Override
        public void compute() {
            if (this.i == 0 && this.j == 0) {
                this.cost = 0.0;
            } else if (this.i == 0 && this.j > 0) {
                this.pre = Alignment.this.e[this.i][this.j];
                this.cost = this.pre.cost;
                this.direction = Costs.Direction.SELF;
            } else if (this.i > 0 && this.j == 0) {
                this.pre = Alignment.this.f[this.i][this.j];
                this.cost = this.pre.cost;
                this.direction = Costs.Direction.SELF;
            } else {
                double diag = ((Alignment)Alignment.this).d[this.i - 1][this.j - 1].cost + Alignment.this.costs.getCostFor(Alignment.this.s1, Alignment.this.s2, Alignment.this.startS1 + this.i, Alignment.this.startS2 + this.j, Costs.Direction.DIAGONAL);
                double left = ((Alignment)Alignment.this).e[this.i][this.j].cost;
                double top = ((Alignment)Alignment.this).f[this.i][this.j].cost;
                if (diag < left && diag < top) {
                    this.cost = diag;
                    this.direction = Costs.Direction.DIAGONAL;
                    this.pre = Alignment.this.d[this.i - 1][this.j - 1];
                } else if (left < top) {
                    this.cost = left;
                    this.direction = Costs.Direction.SELF;
                    this.pre = Alignment.this.e[this.i][this.j];
                } else {
                    this.cost = top;
                    this.direction = Costs.Direction.SELF;
                    this.pre = Alignment.this.f[this.i][this.j];
                }
                if (Alignment.this.type == AlignmentType.LOCAL && 0.0 < this.cost) {
                    this.cost = 0.0;
                    this.direction = Costs.Direction.SELF;
                    this.pre = null;
                }
            }
        }
    }

    private abstract class Element {
        protected int i;
        protected int j;
        double cost;
        protected Costs.Direction direction;
        protected Element pre;

        public Element(int i, int j) {
            this.i = i;
            this.j = j;
            this.compute();
        }

        public abstract void compute();
    }

    public static enum AlignmentType {
        GLOBAL,
        SEMI_GLOBAL,
        LOCAL;

    }
}

