/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models;

import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.algorithms.optimization.termination.TerminationCondition;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.io.ParameterSetParser;
import de.jstacs.models.AbstractModel;
import de.jstacs.models.Model;
import de.jstacs.models.discrete.homogeneous.HomogeneousMM;
import de.jstacs.models.discrete.homogeneous.parameters.HomMMParameterSet;
import de.jstacs.models.discrete.inhomogeneous.BayesianNetworkModel;
import de.jstacs.models.discrete.inhomogeneous.FSDAGModel;
import de.jstacs.models.discrete.inhomogeneous.StructureLearner;
import de.jstacs.models.discrete.inhomogeneous.parameters.BayesianNetworkModelParameterSet;
import de.jstacs.models.discrete.inhomogeneous.parameters.FSDAGMParameterSet;
import de.jstacs.models.mixture.AbstractMixtureModel;
import de.jstacs.models.mixture.MixtureModel;
import de.jstacs.models.mixture.StrandModel;
import de.jstacs.models.mixture.motif.SingleHiddenMotifMixture;
import de.jstacs.parameters.SequenceScoringParameterSet;

public class ModelFactory {
    private static AbstractModel getModelFromParameterSet(SequenceScoringParameterSet ps) throws ParameterSetParser.NotInstantiableException {
        return (AbstractModel)((Object)ps.getInstance());
    }

    public static FSDAGModel createPWM(AlphabetContainer con, int length, double ess) throws Exception {
        FSDAGMParameterSet ps = new FSDAGMParameterSet(con, length, ess, null, "");
        return (FSDAGModel)ModelFactory.getModelFromParameterSet(ps);
    }

    private static BayesianNetworkModel createBN(AlphabetContainer con, int length, double ess, StructureLearner.ModelType type, byte order) throws Exception {
        BayesianNetworkModelParameterSet ps = new BayesianNetworkModelParameterSet(con, length, ess, null, type, order, StructureLearner.LearningType.ML_OR_MAP);
        return (BayesianNetworkModel)ModelFactory.getModelFromParameterSet(ps);
    }

    public static BayesianNetworkModel createInhomogeneousMarkovModel(AlphabetContainer con, int length, double ess, byte order) throws Exception {
        return ModelFactory.createBN(con, length, ess, StructureLearner.ModelType.IMM, order);
    }

    public static BayesianNetworkModel createPermutedMarkovModel(AlphabetContainer con, int length, double ess, byte order) throws Exception {
        return ModelFactory.createBN(con, length, ess, StructureLearner.ModelType.PMM, order);
    }

    public static BayesianNetworkModel createBayesianNetworkModel(AlphabetContainer con, int length, double ess, byte order) throws Exception {
        return ModelFactory.createBN(con, length, ess, StructureLearner.ModelType.BN, order);
    }

    public static HomogeneousMM createHomogeneousMarkovModel(AlphabetContainer con, double ess, byte order) throws Exception {
        HomMMParameterSet ps = new HomMMParameterSet(con, ess, null, order);
        return (HomogeneousMM)ModelFactory.getModelFromParameterSet(ps);
    }

    public static StrandModel createStrandModel(Model model) throws Exception {
        return new StrandModel(model, 10, 0.5, 1.0, (TerminationCondition)new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), AbstractMixtureModel.Parameterization.LAMBDA);
    }

    public static MixtureModel createMixtureModel(double[] hyper, Model[] model) throws Exception {
        int i = 0;
        while (model[i].getLength() == 0) {
            ++i;
        }
        return new MixtureModel(i == model.length ? 0 : model[i].getLength(), model, 10, hyper, 1.0, (TerminationCondition)new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), AbstractMixtureModel.Parameterization.LAMBDA);
    }

    public static SingleHiddenMotifMixture createZOOPS(Model motif, Model bg, double[] hyper, boolean trainOnlyMotifModel) throws Exception {
        return new SingleHiddenMotifMixture(motif, bg, trainOnlyMotifModel, 10, hyper, null, 1.0, (TerminationCondition)new SmallDifferenceOfFunctionEvaluationsCondition(1.0E-6), AbstractMixtureModel.Parameterization.LAMBDA);
    }
}

