/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete.inhomogeneous.parameters;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.models.discrete.inhomogeneous.BayesianNetworkModel;
import de.jstacs.models.discrete.inhomogeneous.InhomogeneousDGM;
import de.jstacs.models.discrete.inhomogeneous.StructureLearner;
import de.jstacs.models.discrete.inhomogeneous.parameters.IDGMParameterSet;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;

public class BayesianNetworkModelParameterSet
extends IDGMParameterSet {
    public BayesianNetworkModelParameterSet(StringBuffer s) throws NonParsableException {
        super(s);
    }

    public BayesianNetworkModelParameterSet() {
        super(BayesianNetworkModel.class);
    }

    public BayesianNetworkModelParameterSet(AlphabetContainer alphabet, int length, double ess, String description, StructureLearner.ModelType model, byte order, StructureLearner.LearningType method) throws Exception {
        super((Class<? extends InhomogeneousDGM>)BayesianNetworkModel.class, alphabet, length, ess, description);
        ((Parameter)this.parameters.get(2)).setValue((Object)model);
        ((Parameter)this.parameters.get(3)).setValue(order);
        ((Parameter)this.parameters.get(4)).setValue((Object)method);
    }

    @Override
    protected void loadParameters() throws Exception {
        super.loadParameters();
        this.parameters.add(new EnumParameter(StructureLearner.ModelType.class, "the standard model that should be learned", true));
        this.parameters.add(new SimpleParameter(DataType.BYTE, "Markov order", "the used markov order is the number of used dependencies for (each) random variable", true, new NumberValidator<Byte>((byte)0, (byte)127)));
        this.parameters.add(new EnumParameter(StructureLearner.LearningType.class, "the learning method for the parameters of the model", true));
    }

    public void setModelType(String modelType) throws SimpleParameter.IllegalValueException {
        ((Parameter)this.parameters.get(2)).setValue(modelType);
    }

    @Override
    public String getInstanceComment() {
        return "a Bayesian Network model (i.e. inhomogeneous Markov model (iMM), permuted Markov model (pMM) or Bayesian network (BN)) with user-specified order";
    }

    public String getModelInstanceName() {
        return BayesianNetworkModelParameterSet.getModelInstanceName((StructureLearner.ModelType)((Object)((Parameter)this.parameters.get(2)).getValue()), (Byte)((Parameter)this.parameters.get(3)).getValue(), (StructureLearner.LearningType)((Object)((Parameter)this.parameters.get(4)).getValue()), (Double)((Parameter)this.parameters.get(0)).getValue());
    }
}

