/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.hmm.models;

import de.jstacs.NonParsableException;
import de.jstacs.NotTrainedException;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.io.XMLParser;
import de.jstacs.models.hmm.HMMTrainingParameterSet;
import de.jstacs.models.hmm.models.HigherOrderHMM;
import de.jstacs.models.hmm.states.SamplingState;
import de.jstacs.models.hmm.states.SimpleSamplingState;
import de.jstacs.models.hmm.states.emissions.SamplingEmission;
import de.jstacs.models.hmm.training.SamplingHMMTrainingParameterSet;
import de.jstacs.models.hmm.transitions.BasicHigherOrderTransition;
import de.jstacs.models.hmm.transitions.SamplingTransition;
import de.jstacs.models.hmm.transitions.TransitionWithSufficientStatistic;
import de.jstacs.models.hmm.transitions.elements.TransitionElement;
import de.jstacs.sampling.BurnInTest;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.Pair;
import java.io.IOException;
import java.util.Arrays;

public class SamplingHigherOrderHMM
extends HigherOrderHMM {
    protected BurnInTest burnInTest;
    protected boolean hasSampled;
    private int numberOfStarts;
    private IntList path;
    private static final String XML_TAG = "SamplingHigherOrderHMM";

    public SamplingHigherOrderHMM(SamplingHMMTrainingParameterSet trainingParameterSet, String[] name, int[] emissionIdx, boolean[] forward, SamplingEmission[] emission, TransitionElement ... te) throws Exception {
        super((HMMTrainingParameterSet)trainingParameterSet, name, emissionIdx, forward, emission, (BasicHigherOrderTransition.AbstractTransitionElement[])te);
        this.hasSampled = false;
        this.path = new IntList();
    }

    public SamplingHigherOrderHMM(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public SamplingHigherOrderHMM clone() throws CloneNotSupportedException {
        SamplingHigherOrderHMM clone = (SamplingHigherOrderHMM)super.clone();
        clone.path = this.path.clone();
        if (this.burnInTest != null) {
            clone.burnInTest = this.burnInTest.clone();
        }
        return clone;
    }

    @Override
    protected void createStates() {
        this.states = new SimpleSamplingState[this.emissionIdx.length];
        for (int i = 0; i < this.emissionIdx.length; ++i) {
            this.states[i] = new SimpleSamplingState((SamplingEmission)this.emission[this.emissionIdx[i]], this.name[i], this.forward[i]);
        }
    }

    protected void acceptParameters() throws IOException {
        ((SamplingTransition)this.transition).acceptParameters();
        for (int e = 0; e < this.emission.length; ++e) {
            ((SamplingEmission)this.emission[e]).acceptParameters();
        }
    }

    protected void drawFromStatistics() throws Exception {
        ((SamplingTransition)this.transition).drawParametersFromStatistic();
        for (int e = 0; e < this.emission.length; ++e) {
            ((SamplingEmission)this.emission[e]).drawParametersFromStatistic();
        }
    }

    protected double gibbsSampling(int startPos, int endPos, double weight, Sequence seq) throws Exception {
        this.samplePath(this.path, startPos, endPos, seq);
        this.addToStatistics(startPos, weight, seq, this.path);
        return this.bwdMatrix[0][0];
    }

    private void addToStatistics(int startPos, double weight, Sequence seq, IntList p) throws Exception {
        int layer = 0;
        this.container[1] = 0;
        for (int l = 0; l < p.length(); ++l) {
            int state = p.get(l);
            int childIdx = this.transition.getChildIdx(layer, this.container[1], state);
            if (childIdx < 0) {
                throw new IllegalArgumentException("Impossible path");
            }
            ((SamplingState)this.states[state]).addToStatistic(startPos, startPos, weight, seq);
            ((SamplingTransition)this.transition).addToStatistic(layer, this.container[1], childIdx, weight, seq, startPos);
            this.transition.fillTransitionInformation(layer, this.container[1], childIdx, this.container);
            if (this.container[2] != 1) continue;
            ++startPos;
            ++layer;
        }
    }

    private double getLogGammaScoreForCurrentStatistics() {
        double score = ((TransitionWithSufficientStatistic)this.transition).getLogGammaScoreFromStatistic();
        for (int state = 0; state < this.states.length; ++state) {
            score += ((SamplingState)this.states[state]).getLogGammaScoreForCurrentStatistic();
        }
        return score;
    }

    protected void gibbsSamplingStep(int sampling, int steps, boolean append, Sample data, double[] weights) throws Exception {
        double score = 0.0;
        double weight = 1.0;
        int N = data.getNumberOfElements();
        this.burnInTest.setCurrentSamplingIndex(sampling);
        ((SamplingTransition)this.transition).extendSampling(sampling, append);
        for (int e = 0; e < this.emission.length; ++e) {
            ((SamplingEmission)this.emission[e]).extendSampling(sampling, append);
        }
        this.sostream.writeln(sampling + " ----------------------------------------");
        for (int s = 0; s < steps; ++s) {
            this.resetStatistics();
            score = this.getLogPriorTerm();
            for (int n = 0; n < N; ++n) {
                Sequence seq = data.getElementAt(n);
                if (weights != null) {
                    weight = weights[n];
                }
                score += this.gibbsSampling(0, seq.getLength() - 1, weight, seq);
            }
            this.sostream.writeln(s + "\t" + score);
            this.burnInTest.setValue(score);
            this.getNewParameters();
            this.acceptParameters();
        }
    }

    protected void getNewParameters() throws Exception {
        this.drawFromStatistics();
    }

    @Override
    public void train(Sample data, double[] weights) throws Exception {
        int start;
        int numberOfBurnInSteps;
        int numberOfSteps = ((SamplingHMMTrainingParameterSet)this.trainingParameter).getNumberOfStepsInStationaryPhase();
        int steps = ((SamplingHMMTrainingParameterSet)this.trainingParameter).getNumberOfStepsPerIteration();
        int samplingCounter = 0;
        boolean append = false;
        this.initTraining(data, weights);
        this.sostream.writeln("GIBBS-SAMPLING - Burn-In ==============================");
        do {
            for (start = 0; start < this.numberOfStarts; ++start) {
                if (samplingCounter == 0) {
                    this.initializeRandomly();
                }
                this.gibbsSamplingStep(start, steps, append, data, weights);
            }
            append = true;
        } while ((samplingCounter += steps) - (numberOfBurnInSteps = this.burnInTest.getLengthOfBurnIn()) <= 0);
        this.sostream.writeln("GIBBS-SAMPLING - Final Sampling =======================");
        for (start = 0; start < this.numberOfStarts; ++start) {
            this.gibbsSamplingStep(start, numberOfSteps, append, data, weights);
        }
        ((SamplingTransition)this.transition).samplingStopped();
        for (int e = 0; e < this.emission.length; ++e) {
            ((SamplingEmission)this.emission[e]).samplingStopped();
        }
        this.hasSampled = true;
    }

    @Override
    public String getInstanceName() {
        return "Sampling HMM(" + this.transition.getMaximalMarkovOrder() + ")";
    }

    @Override
    public boolean isTrained() {
        return this.hasSampled;
    }

    @Override
    protected double logProb(int startpos, int endpos, Sequence sequence) throws Exception {
        double logProb = Double.NEGATIVE_INFINITY;
        int numSamples = 0;
        if (this.hasSampled) {
            for (int start = 0; start < this.numberOfStarts; ++start) {
                boolean furtherParam = this.parseParameterSet(start, this.burnInTest.getLengthOfBurnIn());
                while (furtherParam) {
                    logProb = Normalisation.getLogSum(logProb, super.logProb(startpos, endpos, sequence));
                    furtherParam = this.parseNextParameterSet();
                    ++numSamples;
                }
            }
        } else {
            throw new NotTrainedException();
        }
        return logProb - Math.log(numSamples);
    }

    protected boolean parseParameterSet(int sampling, int idx) throws Exception {
        boolean parsed = ((SamplingTransition)this.transition).parseParameterSet(sampling, idx);
        for (int e = 0; e < this.emission.length; ++e) {
            parsed &= ((SamplingEmission)this.emission[e]).parseParameterSet(sampling, idx);
        }
        return parsed;
    }

    protected boolean parseNextParameterSet() throws Exception {
        boolean parsed = ((SamplingTransition)this.transition).parseNextParameterSet();
        for (int e = 0; e < this.emission.length; ++e) {
            parsed &= ((SamplingEmission)this.emission[e]).parseNextParameterSet();
        }
        return parsed;
    }

    @Override
    protected String getXMLTag() {
        return XML_TAG;
    }

    @Override
    protected void appendFurtherInformation(StringBuffer xml) {
        super.appendFurtherInformation(xml);
        XMLParser.appendObjectWithTags(xml, this.burnInTest, "burnInTest");
        XMLParser.appendObjectWithTags(xml, this.hasSampled, "hasSampled");
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        super.extractFurtherInformation(xml);
        this.numberOfStarts = this.trainingParameter.getNumberOfStarts();
        this.burnInTest = XMLParser.extractObjectForTags(xml, "burnInTest", BurnInTest.class);
        this.hasSampled = XMLParser.extractObjectForTags(xml, "hasSampled", Boolean.TYPE);
        this.path = new IntList();
    }

    protected void initTraining(Sample data, double[] weights) throws Exception {
        this.numberOfStarts = this.trainingParameter.getNumberOfStarts();
        this.burnInTest = ((SamplingHMMTrainingParameterSet)this.trainingParameter).getBurnInTest();
        this.burnInTest.resetAllValues();
        ((SamplingTransition)this.transition).initForSampling(this.numberOfStarts);
        for (int e = 0; e < this.emission.length; ++e) {
            ((SamplingEmission)this.emission[e]).initForSampling(this.numberOfStarts);
        }
        this.furtherInits(data, weights);
    }

    protected void furtherInits(Sample data, double[] weights) throws Exception {
    }

    @Override
    public double[][] getLogStatePosteriorMatrixFor(int startPos, int endPos, Sequence seq) throws Exception {
        double[][] statePosterior = this.createMatrixForStatePosterior(startPos, endPos);
        double[][] tmp = this.createMatrixForStatePosterior(startPos, endPos);
        int numSamples = 0;
        for (int s = 0; s < this.states.length; ++s) {
            Arrays.fill(statePosterior[s], Double.NEGATIVE_INFINITY);
        }
        if (this.hasSampled) {
            for (int start = 0; start < this.numberOfStarts; ++start) {
                boolean furtherParam = this.parseParameterSet(start, this.burnInTest.getLengthOfBurnIn());
                while (furtherParam) {
                    this.fillLogStatePosteriorMatrix(tmp, startPos, endPos, seq, true);
                    for (int s = 0; s < this.states.length; ++s) {
                        for (int l = 0; l < statePosterior[s].length; ++l) {
                            statePosterior[s][l] = Normalisation.getLogSum(statePosterior[s][l], tmp[s][l]);
                        }
                    }
                    furtherParam = this.parseNextParameterSet();
                    ++numSamples;
                }
            }
            double d = Math.log(numSamples);
            for (int s = 0; s < this.states.length; ++s) {
                int l = 0;
                while (l < statePosterior[s].length) {
                    double[] dArray = statePosterior[s];
                    int n = l++;
                    dArray[n] = dArray[n] - d;
                }
            }
        } else {
            throw new NotTrainedException();
        }
        return this.getFinalStatePosterioriMatrix(statePosterior);
    }

    @Override
    public double getLogProbForPath(IntList path, int startPos, Sequence seq) throws Exception {
        int numSamples = 0;
        DoubleList d = new DoubleList(5000);
        if (this.hasSampled) {
            for (int start = 0; start < this.numberOfStarts; ++start) {
                boolean furtherParam = this.parseParameterSet(start, this.burnInTest.getLengthOfBurnIn());
                while (furtherParam) {
                    d.add(super.getLogProbForPath(path, startPos, seq));
                    furtherParam = this.parseNextParameterSet();
                    ++numSamples;
                }
            }
            return Normalisation.getLogSum(d.toArray()) - Math.log(numSamples);
        }
        throw new NotTrainedException();
    }

    @Override
    public Pair<IntList, Double> getViterbiPathFor(int startPos, int endPos, Sequence seq) throws Exception {
        return this.getViterbiPath(startPos, endPos, seq, ViterbiComputation.MAX);
    }

    public Pair<IntList, Double> getViterbiPath(int startPos, int endPos, Sequence seq, ViterbiComputation compute) throws Exception {
        IntList bestPath = new IntList();
        double bestScore = Double.NEGATIVE_INFINITY;
        if (this.hasSampled) {
            for (int start = 0; start < this.numberOfStarts; ++start) {
                boolean furtherParam = this.parseParameterSet(start, this.burnInTest.getLengthOfBurnIn());
                while (furtherParam) {
                    int i;
                    double score;
                    if (compute == ViterbiComputation.SAMPLING || compute == ViterbiComputation.SAMPLING_GAMMA || compute == ViterbiComputation.MAX_AND_SAMPLING || compute == ViterbiComputation.MAX_AND_SAMPLING_GAMMA) {
                        this.resetStatistics();
                        this.path.clear();
                        this.gibbsSampling(startPos, endPos, 1.0, seq);
                        double d = score = compute == ViterbiComputation.SAMPLING || compute == ViterbiComputation.MAX_AND_SAMPLING ? super.getLogProbForPath(this.path, startPos, seq) : this.getLogGammaScoreForCurrentStatistics();
                        if (score > bestScore) {
                            bestScore = score;
                            bestPath.clear();
                            for (i = 0; i < this.path.length(); ++i) {
                                bestPath.add(this.path.get(i));
                            }
                        }
                    }
                    if (compute == ViterbiComputation.MAX || compute == ViterbiComputation.MAX_GAMMA || compute == ViterbiComputation.MAX_AND_SAMPLING || compute == ViterbiComputation.MAX_AND_SAMPLING_GAMMA) {
                        this.resetStatistics();
                        this.path.clear();
                        score = this.viterbi(this.path, startPos, endPos, 0.0, seq);
                        this.addToStatistics(startPos, 1.0, seq, this.path);
                        double d = score = compute == ViterbiComputation.MAX || compute == ViterbiComputation.MAX_AND_SAMPLING ? score : this.getLogGammaScoreForCurrentStatistics();
                        if (score > bestScore) {
                            bestScore = score;
                            bestPath.clear();
                            for (i = 0; i < this.path.length(); ++i) {
                                bestPath.add(this.path.get(i));
                            }
                        }
                    }
                    furtherParam = this.parseNextParameterSet();
                }
            }
        } else {
            throw new NotTrainedException();
        }
        return new Pair<IntList, Double>(bestPath, bestScore);
    }

    protected double getLogPosteriorFromStatistic() {
        double logPosterior = ((SamplingTransition)this.transition).getLogPosteriorFromStatistic();
        for (int state = 0; state < this.states.length; ++state) {
            logPosterior += ((SimpleSamplingState)this.states[state]).getLogPosteriorFromStatistic();
        }
        return logPosterior;
    }

    public static enum ViterbiComputation {
        MAX,
        MAX_GAMMA,
        SAMPLING,
        SAMPLING_GAMMA,
        MAX_AND_SAMPLING,
        MAX_AND_SAMPLING_GAMMA;

    }
}

